/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditDayViewListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthWidget;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CalendarMonthView
implements CalendarEditDayViewListener,
SelectionListener {
    Shell monthShell;
    CalendarShowCase calendarShowCase;
    CalendarMonthWidget calendarmonthwidget;
    String[] stringMonths = new String[]{Messages.getString("CalendarMonthView.0"), Messages.getString("CalendarMonthView.1"), Messages.getString("CalendarMonthView.2"), Messages.getString("CalendarMonthView.3"), Messages.getString("CalendarMonthView.4"), Messages.getString("CalendarMonthView.5"), Messages.getString("CalendarMonthView.6"), Messages.getString("CalendarMonthView.7"), Messages.getString("CalendarMonthView.8"), Messages.getString("CalendarMonthView.9"), Messages.getString("CalendarMonthView.10"), Messages.getString("CalendarMonthView.11")};
    private Command commandEditDay;
    private Command commandMTChangeView;
    private Command commandGoToDate;
    private Command commandExit;

    public CalendarMonthView(CalendarShowCase calendarShowCase, CalendarDataBase calendarDataBase) {
        this.calendarShowCase = calendarShowCase;
        Shell shell = calendarShowCase.getComposite().getShell();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell.getClientArea();
        boolean bl = rectangle2.width > 240 && rectangle2.width > rectangle2.height;
        int n = 262176;
        if (bl) {
            n |= 0x800;
        }
        this.monthShell = new Shell(shell, n);
        this.monthShell.setText(Messages.getString("CalendarMonthView.12"));
        if (bl) {
            int n2 = rectangle.x + 5;
            int n3 = rectangle.y + 5;
            int n4 = rectangle.width / 2 - 15;
            int n5 = rectangle.height - 5;
            this.monthShell.setBounds(n2, n3, n4, n5);
        } else {
            this.monthShell.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.commandEditDay = new Command((Control)this.monthShell, 2, 4);
        this.commandEditDay.setText(bl ? Messages.getString("CalendarMonthView.13") : Messages.getString("CalendarMonthView.14"));
        this.commandEditDay.addSelectionListener((SelectionListener)this);
        this.commandEditDay.setDefaultCommand();
        this.commandMTChangeView = new Command((Control)this.monthShell, 1, 3);
        this.commandMTChangeView.setText(Messages.getString("CalendarMonthView.15"));
        this.commandMTChangeView.addSelectionListener((SelectionListener)this);
        this.commandGoToDate = new Command((Control)this.monthShell, 1, 2);
        this.commandGoToDate.setText(Messages.getString("CalendarMonthView.16"));
        this.commandGoToDate.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.monthShell, 7, 1);
        this.commandExit.setText(Messages.getString("CalendarMonthView.17"));
        this.commandExit.setLongLabel(Messages.getString("CalendarMonthView.18"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.calendarmonthwidget = new CalendarMonthWidget((Composite)this.monthShell, calendarDataBase);
        this.calendarmonthwidget.setLocation(0, 0);
        this.calendarmonthwidget.setSize(this.monthShell.getClientArea().width, this.monthShell.getClientArea().height);
        this.calendarmonthwidget.addCalendarMonthWidgetListener(calendarShowCase);
        this.setTitle(this.calendarmonthwidget.getSelecteddate());
        this.calendarmonthwidget.addTraverseListener(calendarShowCase);
        this.monthShell.open();
    }

    public void dispose() {
        this.commandExit.dispose();
        this.commandGoToDate.dispose();
        this.commandMTChangeView.dispose();
        this.commandEditDay.dispose();
        this.monthShell.dispose();
    }

    public Date getDate() {
        return this.calendarmonthwidget.getSelecteddate();
    }

    public void setDate(Date date) {
        this.calendarmonthwidget.setSelectedDate(date);
    }

    public void activate() {
        this.monthShell.forceActive();
        this.calendarmonthwidget.setFocus();
    }

    public boolean isSwitcher(Widget widget) {
        return widget == this.calendarmonthwidget;
    }

    public void redraw() {
        this.monthShell.redraw();
    }

    public void setTitle(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        String string = String.valueOf(new String(this.stringMonths[gregorianCalendar.get(2)])) + " ";
        string = String.valueOf(string) + gregorianCalendar.get(1);
        this.monthShell.setText(string);
    }

    public void EntriesUpdated() {
        this.calendarmonthwidget.redrawAllMonth();
        this.calendarmonthwidget.redraw();
    }

    public void notifyDateChanged(Date date) {
        this.setDate(date);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandExit) {
            this.calendarShowCase.quit();
        } else if (selectionEvent.widget == this.commandEditDay) {
            this.calendarShowCase.editDay();
        } else if (selectionEvent.widget == this.commandGoToDate) {
            this.calendarShowCase.goToDate(this.calendarShowCase.getComposite().getShell());
        } else if (selectionEvent.widget == this.commandMTChangeView) {
            this.calendarShowCase.getDayViewScreen().activate(this.calendarmonthwidget.getSelecteddate());
            if (this.calendarShowCase.getDayViewScreen().quitWanted()) {
                this.calendarShowCase.quit();
            } else {
                this.setDate(this.calendarShowCase.getDayViewScreen().getDisplayedDate());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

