/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.MobileShell;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MobileShellShowCase
extends ShowCase
implements PaintListener,
KeyListener,
TraverseListener,
SelectionListener,
ShellListener {
    MobileShell mobileShell;
    final String keyCodeString = Messages.getString("MobileShellShowCase.0");
    String keycode = "";
    boolean keypressed;
    boolean switchmode = false;
    int mode;
    Command commandFullscreen;
    Command commandFullscreenWithCmd;
    Command commandExit;
    Command commandBack;
    Button b;
    Color colBlue;
    Color colWhite;
    Color colRed;
    Image backbufferImage;
    GC backbufferGC;
    static int BACKGROUND_BORDER_WIDTH = 10;
    static int RED_RECTANGLES_WIDTH = 20;
    static int MODE_NORMAL = 1;
    static int MODE_FULLSCREEN = 2;
    static int MODE_FULLSCREENWITHCMD = 3;

    public String getName() {
        return Messages.getString("MobileShellShowCase.2");
    }

    public void show() {
        this.mobileShell = new MobileShell(Display.getCurrent(), 1264);
        this.mobileShell.setText(Messages.getString("MobileShellShowCase.3"));
        this.mobileShell.addPaintListener((PaintListener)this);
        this.mobileShell.addKeyListener((KeyListener)this);
        this.mobileShell.addTraverseListener((TraverseListener)this);
        this.mobileShell.addShellListener((ShellListener)this);
        this.b = new Button((Composite)this.mobileShell, 8);
        this.b.setText(Messages.getString("MobileShellShowCase.4"));
        this.b.setBounds(20, 20, 100, 40);
        this.b.addSelectionListener((SelectionListener)this);
        this.b.addKeyListener((KeyListener)this);
        this.mobileShell.redraw();
        this.mobileShell.setFocus();
        this.normalMode();
        this.mobileShell.open();
    }

    public void paintControl(PaintEvent paintEvent) {
        this.buildDoubleBufferingGC();
        Rectangle rectangle = this.textRectangle(String.valueOf(this.keyCodeString) + (this.keycode != null ? this.keycode : ""));
        if (paintEvent.height == rectangle.height && paintEvent.width == rectangle.width) {
            if (this.colWhite == null) {
                this.colWhite = new Color((Device)this.mobileShell.getDisplay(), 255, 255, 255);
            }
            this.backbufferGC.setBackground(this.colWhite);
            this.backbufferGC.setForeground(this.colWhite);
            this.backbufferGC.fillRectangle(new Rectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height));
        } else {
            this.drawBackground();
        }
        this.DrawText();
        paintEvent.gc.drawImage(this.backbufferImage, 0, 0);
    }

    private void drawBackground() {
        Rectangle rectangle = this.mobileShell.getClientArea();
        if (this.colBlue == null) {
            this.colBlue = new Color((Device)this.mobileShell.getDisplay(), 0, 0, 255);
        }
        this.backbufferGC.setBackground(this.colBlue);
        this.backbufferGC.setForeground(this.colBlue);
        this.backbufferGC.fillRectangle(rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle.x + BACKGROUND_BORDER_WIDTH, rectangle.y + BACKGROUND_BORDER_WIDTH, rectangle.width - BACKGROUND_BORDER_WIDTH * 2, rectangle.height - BACKGROUND_BORDER_WIDTH * 2);
        if (this.colWhite == null) {
            this.colWhite = new Color((Device)this.mobileShell.getDisplay(), 255, 255, 255);
        }
        this.backbufferGC.setBackground(this.colWhite);
        this.backbufferGC.setForeground(this.colWhite);
        this.backbufferGC.fillRectangle(rectangle2);
        int n = rectangle.width / (RED_RECTANGLES_WIDTH * 2) + 1;
        int n2 = rectangle.height / (RED_RECTANGLES_WIDTH * 2) + 1;
        if (this.colRed == null) {
            this.colRed = new Color((Device)this.mobileShell.getDisplay(), 255, 0, 0);
        }
        this.backbufferGC.setBackground(this.colRed);
        this.backbufferGC.setForeground(this.colRed);
        int n3 = 0;
        while (n3 < n) {
            this.backbufferGC.fillRectangle(n3 * 2 * RED_RECTANGLES_WIDTH, 0, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            this.backbufferGC.fillRectangle(n3 * 2 * RED_RECTANGLES_WIDTH, rectangle.height - RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.backbufferGC.fillRectangle(0, n3 * 2 * RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.backbufferGC.fillRectangle(rectangle.width - RED_RECTANGLES_WIDTH, n3 * 2 * RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++n3;
        }
    }

    private void DrawText() {
        this.backbufferGC.setBackground(this.mobileShell.getDisplay().getSystemColor(22));
        this.backbufferGC.setForeground(this.mobileShell.getDisplay().getSystemColor(21));
        String string = Messages.getString("MobileShellShowCase.6");
        if (this.keycode != null) {
            string = String.valueOf(string) + this.keycode;
        }
        Rectangle rectangle = this.textRectangle(string);
        this.backbufferGC.drawText(string, rectangle.x, rectangle.y);
        if (this.mode == MODE_FULLSCREEN) {
            Rectangle rectangle2 = this.mobileShell.getClientArea();
            string = Messages.getString("MobileShellShowCase.7");
            Point point = this.backbufferGC.textExtent(string);
            if (point.x < rectangle2.width) {
                this.backbufferGC.drawText(string, rectangle2.x + (rectangle2.width - point.x) / 2, rectangle2.y + (rectangle2.height / 2 - point.y) / 2);
            } else {
                string = Messages.getString("MobileShellShowCase.8");
                String string2 = Messages.getString("MobileShellShowCase.9");
                String string3 = Messages.getString("MobileShellShowCase.10");
                point = this.backbufferGC.textExtent(string);
                Point point2 = this.backbufferGC.textExtent(string2);
                Point point3 = this.backbufferGC.textExtent(string3);
                this.backbufferGC.drawText(string, rectangle2.x + (rectangle2.width - point.x) / 2, rectangle2.y + (rectangle2.height / 2 - point.y) / 2);
                this.backbufferGC.drawText(string2, rectangle2.x + (rectangle2.width - point2.x) / 2, rectangle2.y + (rectangle2.height / 2 - point.y) / 2 + point.y);
                this.backbufferGC.drawText(string3, rectangle2.x + (rectangle2.width - point3.x) / 2, rectangle2.y + (rectangle2.height / 2 - point.y) / 2 + point.y + point2.y);
            }
        }
    }

    public Rectangle textRectangle(String string) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.mobileShell.getClientArea();
        rectangle2 = this.mode == MODE_FULLSCREEN ? new Rectangle(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height / 2) : rectangle;
        Point point = this.backbufferGC.textExtent(string);
        return new Rectangle(rectangle2.x + (rectangle2.width - point.x) / 2, rectangle2.y + (rectangle2.height - point.y) / 2, point.x, point.y);
    }

    public void keyPressed(KeyEvent keyEvent) {
        Rectangle rectangle = this.textRectangle(String.valueOf(this.keyCodeString) + (this.keycode != null ? this.keycode : ""));
        this.keypressed = true;
        this.keycode = new Integer(keyEvent.keyCode).toString();
        String string = this.keyCodeString;
        if (this.keycode != null) {
            string = String.valueOf(string) + this.keycode;
        }
        Rectangle rectangle2 = this.textRectangle(string);
        Rectangle rectangle3 = rectangle.width > rectangle2.width ? rectangle : rectangle2;
        this.mobileShell.redraw(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, true);
        if (this.mode == MODE_FULLSCREEN && (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004 || keyEvent.keyCode == 174)) {
            this.normalMode();
        }
    }

    public void keyTraversed(TraverseEvent traverseEvent) {
        traverseEvent.doit = false;
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keypressed = false;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandFullscreen) {
            this.fullscreenMode();
        } else if (selectionEvent.widget == this.commandFullscreenWithCmd) {
            this.fullscreenModeWithCommands();
        } else if (selectionEvent.widget == this.commandExit) {
            this.quit();
        } else if (selectionEvent.widget == this.b || selectionEvent.widget == this.commandBack) {
            this.normalMode();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void normalMode() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_NORMAL;
        this.mobileShell.setFullScreenMode(false);
        this.commandFullscreen = new Command((Control)this.mobileShell, 1, 3);
        this.commandFullscreen.setText(Messages.getString("MobileShellShowCase.14"));
        this.commandFullscreen.addSelectionListener((SelectionListener)this);
        this.commandFullscreenWithCmd = new Command((Control)this.mobileShell, 1, 2);
        this.commandFullscreenWithCmd.setText(Messages.getString("MobileShellShowCase.15"));
        this.commandFullscreenWithCmd.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.mobileShell, 7, 1);
        this.commandExit.setText(Messages.getString("MobileShellShowCase.16"));
        this.commandExit.setLongLabel(Messages.getString("MobileShellShowCase.17"));
        this.commandExit.addSelectionListener((SelectionListener)this);
    }

    private void fullscreenMode() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_FULLSCREEN;
        this.mobileShell.setFullScreenMode(true);
    }

    private void fullscreenModeWithCommands() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_FULLSCREENWITHCMD;
        this.commandBack = new Command((Control)this.mobileShell, 6, 2);
        this.commandBack.setText(Messages.getString("MobileShellShowCase.18"));
        this.commandBack.addSelectionListener((SelectionListener)this);
        this.mobileShell.setFullScreenMode(true);
    }

    private void buildDoubleBufferingGC() {
        if (this.switchmode) {
            if (this.backbufferImage != null) {
                this.backbufferImage.dispose();
            }
            if (this.backbufferGC != null) {
                this.backbufferGC.dispose();
            }
            this.backbufferImage = new Image((Device)this.mobileShell.getDisplay(), this.mobileShell.getClientArea());
            this.backbufferGC = new GC((Drawable)this.backbufferImage);
            this.switchmode = false;
        }
    }

    private void releaseCommands() {
        if (this.commandFullscreen != null) {
            this.commandFullscreen.dispose();
            this.commandFullscreen = null;
        }
        if (this.commandFullscreenWithCmd != null) {
            this.commandFullscreenWithCmd.dispose();
            this.commandFullscreenWithCmd = null;
        }
        if (this.commandExit != null) {
            this.commandExit.dispose();
            this.commandExit = null;
        }
        if (this.commandBack != null) {
            this.commandBack.dispose();
            this.commandBack = null;
        }
    }

    private void quit() {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        if (this.colBlue != null) {
            this.colBlue.dispose();
            this.colBlue = null;
        }
        if (this.colWhite != null) {
            this.colWhite.dispose();
            this.colWhite = null;
        }
        if (this.colRed != null) {
            this.colRed.dispose();
            this.colRed = null;
        }
        this.releaseCommands();
        this.mobileShell.removeTraverseListener((TraverseListener)this);
        this.mobileShell.removePaintListener((PaintListener)this);
        this.mobileShell.removeKeyListener((KeyListener)this);
        this.mobileShell.dispose();
        this.dispose();
    }

    public void shellClosed(ShellEvent shellEvent) {
        this.dispose();
    }

    public void shellActivated(ShellEvent shellEvent) {
    }

    public void shellDeactivated(ShellEvent shellEvent) {
    }

    public void shellIconified(ShellEvent shellEvent) {
    }

    public void shellDeiconified(ShellEvent shellEvent) {
    }
}

