/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

public class Tokenizer {
    protected char[] value;
    protected int max;
    protected int cursor;

    public Tokenizer(String string) {
        this.value = string.toCharArray();
        this.max = this.value.length;
        this.cursor = 0;
    }

    private void skipWhiteSpace() {
        char[] cArray = this.value;
        int n = this.cursor;
        while (n < this.max) {
            char c = cArray[n];
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            ++n;
        }
        this.cursor = n;
    }

    public String getToken(String string) {
        int n;
        int n2;
        this.skipWhiteSpace();
        char[] cArray = this.value;
        int n3 = n2 = this.cursor;
        while (n2 < this.max) {
            n = cArray[n2];
            if (string.indexOf(n) != -1) break;
            ++n2;
        }
        this.cursor = n2;
        n = n2 - n3;
        if (n > 0) {
            this.skipWhiteSpace();
            while (n > 0 && (cArray[n3 + n - 1] == ' ' || cArray[n3 + n - 1] == '\t')) {
                --n;
            }
            return new String(cArray, n3, n);
        }
        return null;
    }

    public String getString(String string) {
        this.skipWhiteSpace();
        char[] cArray = this.value;
        int n = this.cursor;
        if (n < this.max) {
            if (cArray[n] == '\"') {
                char c = '\u0000';
                int n2 = ++n;
                while (n < this.max) {
                    c = cArray[n];
                    if (c == '\"') break;
                    ++n;
                }
                int n3 = n - n2;
                if (c == '\"') {
                    ++n;
                }
                this.cursor = n;
                if (n3 > 0) {
                    this.skipWhiteSpace();
                    return new String(cArray, n2, n3);
                }
            } else {
                int n4;
                int n5 = n;
                while (n < this.max) {
                    n4 = cArray[n];
                    if (n4 == 34) {
                        n += this.skipQuotedString(cArray, n);
                    } else if (string.indexOf(n4) != -1) break;
                    ++n;
                }
                this.cursor = n;
                n4 = n - n5;
                if (n4 > 0) {
                    this.skipWhiteSpace();
                    while (n4 > 0 && (cArray[n5 + n4 - 1] == ' ' || cArray[n5 + n4 - 1] == '\t')) {
                        --n4;
                    }
                    return new String(cArray, n5, n4);
                }
            }
        }
        return null;
    }

    private int skipQuotedString(char[] cArray, int n) {
        char c = '\u0000';
        int n2 = ++n;
        while (n < this.max) {
            c = cArray[n];
            if (c == '\"') break;
            ++n;
        }
        int n3 = n - n2;
        if (c == '\"') {
            ++n;
        }
        this.cursor = n;
        if (n3 > 0) {
            this.skipWhiteSpace();
        }
        return n3;
    }

    public char getChar() {
        int n = this.cursor;
        if (n < this.max) {
            this.cursor = n + 1;
            return this.value[n];
        }
        return '\u0000';
    }

    public boolean hasMoreTokens() {
        return this.cursor < this.max;
    }
}

