/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.osgi.framework.BundleException;

public class SystemBundleData
extends BaseData {
    private static final String OSGI_FRAMEWORK = "osgi.framework";

    public SystemBundleData(BaseAdaptor baseAdaptor) throws BundleException {
        super(0L, baseAdaptor);
        File file = this.getOsgiBase();
        this.createBundleFile(file);
        this.manifest = this.createManifest(file);
        this.setMetaData();
        this.setLastModified(System.currentTimeMillis());
    }

    private File getOsgiBase() {
        String string = FrameworkProperties.getProperty(OSGI_FRAMEWORK);
        if (string != null) {
            return new File(string.substring(5));
        }
        try {
            URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            return new File(uRL.getPath());
        }
        catch (Throwable throwable) {
            string = FrameworkProperties.getProperty("user.dir");
            if (string != null) {
                return new File(string);
            }
            return null;
        }
    }

    private Headers createManifest(File file) throws BundleException {
        InputStream inputStream = null;
        if (file != null && file.exists()) {
            try {
                BundleEntry bundleEntry = this.getBundleFile().getEntry("META-INF/MANIFEST.MF");
                if (bundleEntry != null) {
                    inputStream = bundleEntry.getInputStream();
                }
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = this.getManifestAsResource();
        }
        if (Debug.DEBUG_GENERAL && inputStream == null) {
            Debug.println("Unable to find system bundle manifest META-INF/MANIFEST.MF");
        }
        if (inputStream == null) {
            throw new BundleException(AdaptorMsg.SYSTEMBUNDLE_MISSING_MANIFEST);
        }
        return Headers.parseManifest(inputStream);
    }

    private InputStream getManifestAsResource() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader != null ? classLoader.getResources("META-INF/MANIFEST.MF") : ClassLoader.getSystemResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try {
                    Headers headers = Headers.parseManifest(uRL.openStream());
                    if (!"true".equals(headers.get("Eclipse-SystemBundle"))) continue;
                    return uRL.openStream();
                }
                catch (BundleException bundleException) {}
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void createBundleFile(File file) {
        if (file != null) {
            try {
                this.bundleFile = this.getAdaptor().createBundleFile(file, this);
            }
            catch (IOException iOException) {}
        } else {
            this.bundleFile = new BundleFile(file){

                public File getFile(String string, boolean bl) {
                    return null;
                }

                public BundleEntry getEntry(String string) {
                    return null;
                }

                public Enumeration getEntryPaths(String string) {
                    return null;
                }

                public void close() {
                }

                public void open() {
                }

                public boolean containsDir(String string) {
                    return false;
                }
            };
        }
    }

    private void setMetaData() throws BundleException {
        this.setLocation("System Bundle");
        BaseStorageHook.loadManifest(this, this.manifest);
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, String[] stringArray) {
        return null;
    }

    public File createGenerationDir() {
        return null;
    }

    public String findLibrary(String string) {
        return null;
    }

    public void installNativeCode(String[] stringArray) throws BundleException {
    }

    public File getDataFile(String string) {
        return null;
    }

    public int getStartLevel() {
        return 0;
    }

    public int getStatus() {
        return 0;
    }

    public void save() {
    }
}

