/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.service.resolver.BundleSpecification;

public class GroupingChecker {
    HashMap bundles = new HashMap();
    private boolean checkCycles = false;

    private ResolverExport[] getConstraints(ResolverExport resolverExport) {
        Object[] objectArray = this.getCachedConstraints(resolverExport);
        if (objectArray != null && objectArray[1] != null) {
            return (ResolverExport[])objectArray[1];
        }
        ArrayList arrayList = this.getConstraintsList(resolverExport);
        ResolverExport[] resolverExportArray = arrayList.toArray(new ResolverExport[arrayList.size()]);
        if (!this.checkCycles || resolverExport.getExporter().isResolved()) {
            if (objectArray == null) {
                objectArray = this.createConstraintsCache(resolverExport);
            }
            objectArray[1] = resolverExportArray;
        }
        return resolverExportArray;
    }

    private Object[] getCachedConstraints(ResolverExport resolverExport) {
        HashMap hashMap = (HashMap)this.bundles.get(resolverExport.getExporter());
        return hashMap == null ? null : (Object[])hashMap.get(resolverExport);
    }

    private ArrayList getConstraintsList(ResolverExport resolverExport) {
        ArrayList arrayList = new ArrayList();
        this.getTransitiveConstraints(resolverExport, arrayList);
        return arrayList;
    }

    private void getTransitiveConstraints(ResolverExport resolverExport, ArrayList arrayList) {
        if (resolverExport.isDropped()) {
            return;
        }
        ResolverExport[] resolverExportArray = resolverExport.getRoots();
        int n = 0;
        while (n < resolverExportArray.length) {
            if (resolverExportArray[n] != resolverExport) {
                this.getTransitiveConstraints(resolverExportArray[n], arrayList);
            }
            ++n;
        }
        Object[] objectArray = this.getCachedConstraints(resolverExport);
        ArrayList arrayList2 = (ArrayList)(objectArray != null ? objectArray[0] : null);
        if (arrayList2 == null) {
            return;
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ResolverExport[] resolverExportArray2 = null;
            if (e instanceof ResolverExport) {
                ResolverExport resolverExport2 = (ResolverExport)e;
                resolverExportArray2 = resolverExport2.getRoots();
            } else if (e instanceof ResolverImport) {
                ResolverImport resolverImport = (ResolverImport)e;
                if (resolverImport.getMatchingExport() != null) {
                    resolverExportArray2 = resolverImport.getMatchingExport().getRoots();
                }
            } else if (e instanceof UsesRequiredExport) {
                resolverExportArray2 = ((UsesRequiredExport)e).getRoots();
            }
            if (resolverExportArray2 == null) continue;
            int n2 = 0;
            while (n2 < resolverExportArray2.length) {
                if (!arrayList.contains(resolverExportArray2[n2])) {
                    arrayList.add(resolverExportArray2[n2]);
                    if (resolverExportArray2[n2] != e) {
                        this.getTransitiveConstraints(resolverExportArray2[n2], arrayList);
                    }
                }
                ++n2;
            }
        }
    }

    private Object[] createConstraintsCache(ResolverExport resolverExport) {
        Object[] objectArray;
        HashMap<ResolverExport, Object[]> hashMap = (HashMap<ResolverExport, Object[]>)this.bundles.get(resolverExport.getExporter());
        if (hashMap == null) {
            hashMap = new HashMap<ResolverExport, Object[]>();
            this.bundles.put(resolverExport.getExporter(), hashMap);
        }
        if ((objectArray = (Object[])hashMap.get(resolverExport)) == null) {
            objectArray = new Object[2];
            hashMap.put(resolverExport, objectArray);
        }
        return objectArray;
    }

    private ArrayList createConstraints(ResolverExport resolverExport) {
        Object[] objectArray = this.createConstraintsCache(resolverExport);
        if (objectArray[0] == null) {
            objectArray[0] = new ArrayList();
        }
        return (ArrayList)objectArray[0];
    }

    private void addConstraint(ResolverExport resolverExport, Object object) {
        ArrayList arrayList = this.createConstraints(resolverExport);
        if (!arrayList.contains(object)) {
            arrayList.add(object);
        }
    }

    void removeAllExportConstraints(ResolverBundle resolverBundle) {
        this.bundles.remove(resolverBundle);
    }

    ResolverBundle isConsistent(BundleConstraint bundleConstraint, ResolverBundle resolverBundle) {
        BundleConstraint[] bundleConstraintArray = bundleConstraint.getBundle().getRequires();
        ArrayList arrayList = new ArrayList(bundleConstraintArray.length);
        int n = 0;
        while (n < bundleConstraintArray.length) {
            ResolverBundle resolverBundle2 = bundleConstraintArray[n].getMatchingBundle();
            if (resolverBundle2 != resolverBundle && resolverBundle2 != null) {
                ResolverExport[] resolverExportArray = resolverBundle2.getSelectedExports();
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    if (this.checkReqExpConflict(resolverExportArray[n2], this.getConstraints(resolverExportArray[n2]), resolverBundle, arrayList) != null) {
                        return resolverBundle2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    ResolverExport isConsistent(ResolverImport resolverImport, ResolverExport resolverExport) {
        Object object;
        ResolverExport[] resolverExportArray = this.getConstraints(resolverExport);
        ResolverImport[] resolverImportArray = resolverImport.getBundle().getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            object = this.checkImpExpConflict(resolverImport, resolverImportArray[n].getMatchingExport(), resolverExport, resolverExportArray);
            if (object != null) {
                return object;
            }
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverImport.getBundle().getRequires();
        object = new ArrayList(bundleConstraintArray.length);
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            ResolverExport resolverExport2 = this.checkReqExpConflict(resolverExport, resolverExportArray, bundleConstraintArray[n2].getMatchingBundle(), (ArrayList)object);
            if (resolverExport2 != null) {
                return resolverExport2;
            }
            ++n2;
        }
        return null;
    }

    private ResolverExport checkImpExpConflict(ResolverImport resolverImport, ResolverExport resolverExport, ResolverExport resolverExport2, ResolverExport[] resolverExportArray) {
        if (resolverExport == null) {
            return null;
        }
        if (resolverExport != resolverExport2) {
            ResolverExport[] resolverExportArray2 = this.getConstraints(resolverExport);
            int n = 0;
            while (n < resolverExportArray2.length) {
                if (this.isConflict(resolverExport2, resolverExportArray2[n])) {
                    return resolverExport;
                }
                ++n;
            }
        }
        int n = 0;
        while (n < resolverExportArray.length) {
            ResolverExport[] resolverExportArray3 = resolverImport != null ? resolverImport.getBundle().getExports(resolverExportArray[n].getName()) : new ResolverExport[]{};
            int n2 = 0;
            while (n2 < resolverExportArray3.length) {
                if (!resolverExportArray3[n2].isDropped() && !this.isOnRoot(resolverExportArray3[n2].getRoots(), resolverExportArray[n])) {
                    return resolverExport;
                }
                ++n2;
            }
            if (this.isConflict(resolverExport, resolverExportArray[n])) {
                return resolverExport;
            }
            ++n;
        }
        return null;
    }

    private ResolverExport checkReqExpConflict(ResolverExport resolverExport, ResolverExport[] resolverExportArray, ResolverBundle resolverBundle, ArrayList arrayList) {
        if (resolverBundle == null) {
            return null;
        }
        if (arrayList.contains(resolverBundle)) {
            return null;
        }
        arrayList.add(resolverBundle);
        ResolverExport[] resolverExportArray2 = resolverBundle.getSelectedExports();
        int n = 0;
        while (n < resolverExportArray2.length) {
            int n2 = 0;
            while (n2 < resolverExportArray.length) {
                if (this.isConflict(resolverExportArray2[n], resolverExportArray[n2])) {
                    return resolverExport;
                }
                ++n2;
            }
            ResolverExport[] resolverExportArray3 = this.getConstraints(resolverExportArray2[n]);
            int n3 = 0;
            while (n3 < resolverExportArray3.length) {
                if (this.isConflict(resolverExport, resolverExportArray3[n3])) {
                    return resolverExport;
                }
                ++n3;
            }
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n4 = 0;
        while (n4 < bundleConstraintArray.length) {
            ResolverExport resolverExport2;
            if (((BundleSpecification)bundleConstraintArray[n4].getVersionConstraint()).isExported() && (resolverExport2 = this.checkReqExpConflict(resolverExport, resolverExportArray, bundleConstraintArray[n4].getMatchingBundle(), arrayList)) != null) {
                return resolverExport;
            }
            ++n4;
        }
        return null;
    }

    private boolean isConflict(ResolverExport resolverExport, ResolverExport resolverExport2) {
        return resolverExport2.getExporter().isResolvable() && resolverExport2.getName().equals(resolverExport.getName()) && !this.isOnRoot(resolverExport.getRoots(), resolverExport2);
    }

    private boolean isOnRoot(ResolverExport[] resolverExportArray, ResolverExport resolverExport) {
        int n = 0;
        while (n < resolverExportArray.length) {
            if (resolverExportArray[n].getExporter() == resolverExport.getExporter()) {
                return true;
            }
            ++n;
        }
        return resolverExportArray.length == 1 && !resolverExportArray[0].getExportPackageDescription().isRoot();
    }

    void addInitialGroupingConstraints(ResolverBundle resolverBundle) {
        if (this.bundles.containsKey(resolverBundle)) {
            return;
        }
        ResolverExport[] resolverExportArray = resolverBundle.getExportPackages();
        int n = 0;
        while (n < resolverExportArray.length) {
            this.addInitialGroupingConstraints(resolverExportArray[n], null);
            ++n;
        }
        if (this.bundles.get(resolverBundle) == null) {
            this.bundles.put(resolverBundle, null);
        }
    }

    private void addInitialGroupingConstraints(ResolverExport resolverExport, ResolverExport resolverExport2) {
        String[] stringArray;
        if (resolverExport == resolverExport2) {
            return;
        }
        if (resolverExport2 == null) {
            resolverExport2 = resolverExport;
        }
        if ((stringArray = (String[])resolverExport2.getExportPackageDescription().getDirective("uses")) == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            ResolverExport[] resolverExportArray = resolverExport.getExporter().getExports(stringArray[n]);
            int n2 = 0;
            while (n2 < resolverExportArray.length) {
                if (!this.getConstraintsList(resolverExport).contains(resolverExportArray[n2])) {
                    this.addConstraint(resolverExport, resolverExportArray[n2]);
                    this.addInitialGroupingConstraints(resolverExport, resolverExportArray[n2]);
                }
                ++n2;
            }
            ResolverImport resolverImport = resolverExport.getExporter().getImport(stringArray[n]);
            if (resolverImport != null && !resolverImport.isDynamic()) {
                this.addConstraint(resolverExport, resolverImport);
            }
            if (resolverExportArray.length == 0 && (resolverImport == null || resolverImport.isDynamic())) {
                this.addConstraint(resolverExport, new UsesRequiredExport(resolverExport2, stringArray[n]));
            }
            ++n;
        }
    }

    public void setCheckCycles(boolean bl) {
        this.checkCycles = bl;
    }

    private class UsesRequiredExport {
        private ResolverExport export;
        private String usesName;

        UsesRequiredExport(ResolverExport resolverExport, String string) {
            this.export = resolverExport;
            this.usesName = string;
        }

        public ResolverExport[] getRoots() {
            ArrayList<ResolverExport> arrayList = new ArrayList<ResolverExport>(1);
            BundleConstraint[] bundleConstraintArray = this.export.getExporter().getRequires();
            int n = 0;
            while (n < bundleConstraintArray.length) {
                ResolverExport resolverExport;
                if (bundleConstraintArray[n].getMatchingBundle() != null && (resolverExport = bundleConstraintArray[n].getMatchingBundle().getExport(this.usesName)) != null && !resolverExport.isDropped()) {
                    ResolverExport[] resolverExportArray = resolverExport.getRoots();
                    int n2 = 0;
                    while (n2 < resolverExportArray.length) {
                        if (!arrayList.contains(resolverExport)) {
                            arrayList.add(resolverExportArray[n2]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return arrayList.toArray(new ResolverExport[arrayList.size()]);
        }

        public boolean equals(Object object) {
            if (!(object instanceof UsesRequiredExport)) {
                return false;
            }
            return ((UsesRequiredExport)object).export.getExporter() == this.export.getExporter() && this.usesName.equals(((UsesRequiredExport)object).usesName);
        }
    }
}

