/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GENERICS = "org.eclipse.osgi/resolver/generics";
    private static final String OPTION_GROUPING = "org.eclipse.osgi/resolver/grouping";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GENERICS = false;
    public static boolean DEBUG_GROUPING = false;
    public static boolean DEBUG_CYCLES = false;
    private static String[][] CURRENT_EES;
    private State state;
    private PermissionChecker permissionChecker;
    private MappedList removalPending = new MappedList();
    private boolean initialized = false;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private VersionHashMap resolverGenerics = null;
    private ArrayList unresolvedBundles = null;
    private HashMap bundleMapping = null;
    private GroupingChecker groupingChecker;
    private Comparator selectionPolicy;

    public ResolverImpl(BundleContext bundleContext, boolean bl) {
        this.permissionChecker = new PermissionChecker(bundleContext, bl, this);
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap(this);
        this.resolverBundles = new VersionHashMap(this);
        this.resolverGenerics = new VersionHashMap(this);
        this.unresolvedBundles = new ArrayList();
        this.bundleMapping = new HashMap();
        BundleDescription[] bundleDescriptionArray = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.initResolverBundle(bundleDescriptionArray[n], arrayList, false);
            ++n;
        }
        Object[] objectArray = this.removalPending.getAllValues();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.initResolverBundle((BundleDescription)objectArray[n2], arrayList, true);
            ++n2;
        }
        ResolverBundle[] resolverBundleArray = arrayList.iterator();
        while (resolverBundleArray.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)resolverBundleArray.next();
            BundleDescription[] bundleDescriptionArray2 = ((HostSpecification)resolverBundle.getHost().getVersionConstraint()).getHosts();
            int n3 = 0;
            while (n3 < bundleDescriptionArray2.length) {
                ResolverBundle resolverBundle2 = (ResolverBundle)this.bundleMapping.get(bundleDescriptionArray2[n3]);
                if (resolverBundle2 != null) {
                    resolverBundle2.attachFragment(resolverBundle, false);
                }
                ++n3;
            }
        }
        this.rewireBundles();
        resolverBundleArray = this.bundleMapping.values().toArray(new ResolverBundle[this.bundleMapping.size()]);
        int n4 = 0;
        while (n4 < resolverBundleArray.length) {
            if (resolverBundleArray[n4].isResolved()) {
                this.groupingChecker.addInitialGroupingConstraints(resolverBundleArray[n4]);
            }
            ++n4;
        }
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDescription, ArrayList arrayList, boolean bl) {
        ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
        this.bundleMapping.put(bundleDescription, resolverBundle);
        if (!bl || bundleDescription.isResolved()) {
            this.resolverExports.put(resolverBundle.getExportPackages());
            this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
            this.resolverGenerics.put(resolverBundle.getGenericCapabilities());
        }
        if (bundleDescription.isResolved()) {
            resolverBundle.setState(2);
            if (bundleDescription.getHost() != null) {
                arrayList.add(resolverBundle);
            }
        } else if (!bl) {
            this.unresolvedBundles.add(resolverBundle);
        }
    }

    private void rewireBundles() {
        ArrayList arrayList = new ArrayList(this.bundleMapping.size());
        Iterator iterator = this.bundleMapping.values().iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            if (!resolverBundle.getBundle().isResolved() || resolverBundle.isFragment()) continue;
            this.rewireBundle(resolverBundle, arrayList);
        }
    }

    private void rewireBundle(ResolverBundle resolverBundle, ArrayList arrayList) {
        if (arrayList.contains(resolverBundle)) {
            return;
        }
        arrayList.add(resolverBundle);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            this.rewireRequire(bundleConstraintArray[n], arrayList);
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            this.rewireImport(resolverImportArray[n2], arrayList);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            this.rewireGeneric(genericConstraintArray[n3], arrayList);
            ++n3;
        }
    }

    private void rewireGeneric(GenericConstraint genericConstraint, ArrayList arrayList) {
        if (genericConstraint.getMatchingCapabilities() != null) {
            return;
        }
        GenericDescription[] genericDescriptionArray = ((GenericSpecification)genericConstraint.getVersionConstraint()).getSuppliers();
        if (genericDescriptionArray == null) {
            return;
        }
        Object[] objectArray = this.resolverGenerics.get(genericConstraint.getName());
        int n = 0;
        while (n < objectArray.length) {
            GenericCapability genericCapability = (GenericCapability)objectArray[n];
            int n2 = 0;
            while (n2 < genericDescriptionArray.length) {
                if (genericCapability.getBaseDescription() == genericDescriptionArray[n2]) {
                    genericConstraint.setMatchingCapability(genericCapability);
                }
                ++n2;
            }
            ++n;
        }
        GenericCapability[] genericCapabilityArray = genericConstraint.getMatchingCapabilities();
        if (genericCapabilityArray != null) {
            int n3 = 0;
            while (n3 < genericCapabilityArray.length) {
                this.rewireBundle(genericCapabilityArray[n3].getResolverBundle(), arrayList);
                ++n3;
            }
        }
    }

    private void rewireRequire(BundleConstraint bundleConstraint, ArrayList arrayList) {
        if (bundleConstraint.getMatchingBundle() != null) {
            return;
        }
        ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleConstraint.getVersionConstraint().getSupplier());
        bundleConstraint.setMatchingBundle(resolverBundle);
        if (resolverBundle == null && !bundleConstraint.isOptional()) {
            System.err.println("Could not find matching bundle for " + bundleConstraint.getVersionConstraint());
        }
        if (resolverBundle != null) {
            this.rewireBundle(resolverBundle, arrayList);
        }
    }

    private void rewireImport(ResolverImport resolverImport, ArrayList arrayList) {
        if (resolverImport.isDynamic() || resolverImport.getMatchingExport() != null) {
            return;
        }
        ResolverExport resolverExport = null;
        ExportPackageDescription exportPackageDescription = (ExportPackageDescription)resolverImport.getVersionConstraint().getSupplier();
        ResolverBundle resolverBundle = exportPackageDescription == null ? null : (ResolverBundle)this.bundleMapping.get(exportPackageDescription.getExporter());
        Object[] objectArray = this.resolverExports.get(resolverImport.getName());
        int n = 0;
        while (n < objectArray.length) {
            ResolverExport resolverExport2 = (ResolverExport)objectArray[n];
            if (resolverExport2.getExporter() == resolverBundle && resolverImport.isSatisfiedBy(resolverExport2)) {
                resolverExport = resolverExport2;
                break;
            }
            ++n;
        }
        resolverImport.setMatchingExport(resolverExport);
        if (resolverExport == null && resolverBundle != null) {
            ResolverExport resolverExport3 = new ResolverExport(resolverBundle, exportPackageDescription);
            if (resolverBundle.getExport(resolverImport.getName()) == null) {
                resolverBundle.addExport(resolverExport3);
                this.resolverExports.put(resolverExport3.getName(), resolverExport3);
            }
            resolverImport.setMatchingExport(resolverExport3);
        }
        if (resolverImport.getMatchingExport() == null && !resolverImport.isOptional()) {
            System.err.println("Could not find matching export for " + resolverImport.getVersionConstraint());
        }
        if (resolverImport.getMatchingExport() != null) {
            this.rewireBundle(resolverImport.getMatchingExport().getExporter(), arrayList);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(BundleDescription bundleDescription, Dictionary[] dictionaryArray, ArrayList arrayList) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        if (arrayList.contains(bundleDescription)) {
            return false;
        }
        if (bundleDescription.isSingleton() && (objectArray = this.resolverBundles.get(bundleDescription.getName())).length > 1) {
            n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] != bundleDescription && ((ResolverBundle)objectArray[n3]).getBundle().isSingleton() && ((ResolverBundle)objectArray[n3]).getBundle().isResolved()) {
                    arrayList.add(bundleDescription);
                    return false;
                }
                ++n3;
            }
        }
        int n4 = n3 = (objectArray = bundleDescription.getExecutionEnvironments()).length == 0 ? 1 : 0;
        if (n3 == 0) {
            int n5 = 0;
            while (n5 < objectArray.length && n3 == 0) {
                n2 = 0;
                while (n2 < CURRENT_EES.length && n3 == 0) {
                    n = 0;
                    while (n < CURRENT_EES[n2].length && n3 == 0) {
                        if (CURRENT_EES[n2][n].equals(objectArray[n5])) {
                            ((BundleDescriptionImpl)bundleDescription).setEquinoxEE(n2);
                            n3 = 1;
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n5;
            }
        }
        if (n3 == 0) {
            StringBuffer stringBuffer = new StringBuffer("Bundle-RequiredExecutionEnvironment".length() + 20);
            stringBuffer.append("Bundle-RequiredExecutionEnvironment").append(": ");
            n2 = 0;
            while (n2 < objectArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)objectArray[n2]);
                ++n2;
            }
            this.state.addResolverError(bundleDescription, 16384, stringBuffer.toString(), null);
            return false;
        }
        String string = bundleDescription.getPlatformFilter();
        if (string == null) {
            return true;
        }
        if (dictionaryArray == null) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter(string);
            n = 0;
            while (n < dictionaryArray.length) {
                if (filter.match(dictionaryArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.state.addResolverError(bundleDescription, 8192, string, null);
        return false;
    }

    private void attachFragment(ResolverBundle resolverBundle, ArrayList arrayList) {
        int n;
        Object object;
        Object[] objectArray;
        if (!resolverBundle.isFragment() || !resolverBundle.isResolvable() || arrayList.contains(resolverBundle.getBundle())) {
            return;
        }
        if (resolverBundle.getBundle().isSingleton() && (objectArray = this.resolverBundles.get((object = resolverBundle.getBundle()).getName())).length > 1) {
            n = 0;
            while (n < objectArray.length) {
                BundleDescription bundleDescription = ((ResolverBundle)objectArray[n]).getBundle();
                if (objectArray[n] != resolverBundle && bundleDescription.isSingleton() && !arrayList.contains(bundleDescription)) {
                    boolean bl;
                    if (this.selectionPolicy == null) {
                        bl = bundleDescription.isResolved() || bundleDescription.getVersion().compareTo(resolverBundle.getBundle().getVersion()) > 0;
                    } else {
                        boolean bl2 = bl = this.selectionPolicy.compare(bundleDescription, resolverBundle.getBundle()) < 0;
                    }
                    if (bl) {
                        arrayList.add(resolverBundle.getBundle());
                        return;
                    }
                    arrayList.add(bundleDescription);
                }
                ++n;
            }
        }
        object = resolverBundle.getHost();
        objectArray = this.resolverBundles.get(((ResolverConstraint)object).getVersionConstraint().getName());
        n = 0;
        while (n < objectArray.length) {
            if (((ResolverBundle)objectArray[n]).isResolvable() && ((ResolverConstraint)object).isSatisfiedBy((ResolverBundle)objectArray[n])) {
                this.resolverExports.put(((ResolverBundle)objectArray[n]).attachFragment(resolverBundle, true));
            }
            ++n;
        }
    }

    public synchronized void resolve(BundleDescription[] bundleDescriptionArray, Dictionary[] dictionaryArray) {
        Object[] objectArray;
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (bundleDescriptionArray != null) {
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescriptionArray[n]);
                if (resolverBundle != null) {
                    this.unresolveBundle(resolverBundle, false);
                }
                ++n;
            }
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
        this.resolverGenerics.reorder();
        this.getCurrentEEs(dictionaryArray);
        ArrayList arrayList = new ArrayList();
        boolean bl = dictionaryArray.length == 0 ? false : "true".equals(dictionaryArray[0].get("osgi.resolveOptional"));
        ResolverBundle[] resolverBundleArray = null;
        if (bl) {
            objectArray = this.state.getResolvedBundles();
            resolverBundleArray = new ResolverBundle[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                resolverBundleArray[n] = (ResolverBundle)this.bundleMapping.get(objectArray[n]);
                ++n;
            }
        }
        objectArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.resolveBundles((ResolverBundle[])objectArray, dictionaryArray, arrayList);
        if (this.selectSingletons((ResolverBundle[])objectArray, arrayList)) {
            objectArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.resolveBundles((ResolverBundle[])objectArray, dictionaryArray, arrayList);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            BundleDescription bundleDescription2 = this.state.getBundle(bundleDescription.getSymbolicName(), null);
            this.state.addResolverError(bundleDescription, 8, bundleDescription2.toString(), null);
        }
        if (bl) {
            this.resolveOptionalConstraints(resolverBundleArray);
        }
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private void resolveOptionalConstraints(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (resolverBundleArray[n] != null) {
                this.resolveOptionalConstraints(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle resolverBundle) {
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (bundleConstraintArray[n].isOptional() && bundleConstraintArray[n].getMatchingBundle() == null) {
                arrayList.clear();
                this.resolveRequire(bundleConstraintArray[n], arrayList);
                if (bundleConstraintArray[n].getMatchingBundle() != null) {
                    bl = true;
                }
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].isOptional() && resolverImportArray[n2].getMatchingExport() == null) {
                arrayList.clear();
                this.resolveImport(resolverImportArray[n2], true, arrayList);
                if (resolverImportArray[n2].getMatchingExport() != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            this.state.resolveBundle(resolverBundle.getBundle(), false, null, null, null, null);
            this.stateResolveConstraints(resolverBundle);
            this.stateResolveBundle(resolverBundle);
        }
    }

    private void getCurrentEEs(Dictionary[] dictionaryArray) {
        CURRENT_EES = new String[dictionaryArray.length][];
        int n = 0;
        while (n < dictionaryArray.length) {
            String string = (String)dictionaryArray[n].get("org.osgi.framework.executionenvironment");
            ResolverImpl.CURRENT_EES[n] = ManifestElement.getArrayFromList(string, ",");
            ++n;
        }
    }

    private void resolveBundles(ResolverBundle[] resolverBundleArray, Dictionary[] dictionaryArray, ArrayList arrayList) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.state.removeResolverErrors(resolverBundleArray[n].getBundle());
            resolverBundleArray[n].setResolvable(this.isResolvable(resolverBundleArray[n].getBundle(), dictionaryArray, arrayList));
            resolverBundleArray[n].clearRefs();
            this.groupingChecker.removeAllExportConstraints(resolverBundleArray[n]);
            ++n;
        }
        n = 0;
        while (n < resolverBundleArray.length) {
            this.attachFragment(resolverBundleArray[n], arrayList);
            ++n;
        }
        n = 0;
        while (n < resolverBundleArray.length) {
            this.groupingChecker.addInitialGroupingConstraints(resolverBundleArray[n]);
            ++n;
        }
        ArrayList arrayList2 = new ArrayList(1);
        ArrayList<ResolverBundle> arrayList3 = new ArrayList<ResolverBundle>(resolverBundleArray.length);
        int n2 = 0;
        while (n2 < resolverBundleArray.length) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + resolverBundleArray[n2] + " **");
            }
            arrayList2.clear();
            this.resolveBundle(resolverBundleArray[n2], arrayList2);
            this.checkCycle(arrayList2);
            if (resolverBundleArray[n2].isResolvable()) {
                arrayList3.add(resolverBundleArray[n2]);
            }
            ++n2;
        }
        if (this.unresolvedBundles.size() > 0) {
            ResolverBundle[] resolverBundleArray2 = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            int n3 = 0;
            while (n3 < resolverBundleArray2.length) {
                this.resolveFragment(resolverBundleArray2[n3]);
                ++n3;
            }
        }
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles(resolverBundleArray);
    }

    private void checkCycle(ArrayList arrayList) {
        ResolverBundle resolverBundle;
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            ResolverBundle resolverBundle2 = (ResolverBundle)arrayList.get(n2);
            this.groupingChecker.removeAllExportConstraints(resolverBundle2);
            this.groupingChecker.addInitialGroupingConstraints(resolverBundle2);
            if (!resolverBundle2.isResolvable()) {
                arrayList.remove(n2);
            }
            --n2;
        }
        n2 = arrayList.size() == n && this.isCycleConsistent(arrayList) ? 0 : 1;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            resolverBundle = (ResolverBundle)arrayList.get(0);
            ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
            int n4 = 0;
            while (n4 < resolverImportArray.length) {
                if (resolverImportArray[n4].getMatchingExport() != null && resolverImportArray[n4].getMatchingExport().isDropped()) {
                    resolverImportArray[n4].addUnresolvableWiring(resolverImportArray[n4].getMatchingExport().getExporter());
                    n2 = 1;
                }
                ++n4;
            }
            ++n3;
        }
        if (n2 != 0) {
            n3 = 0;
            while (n3 < arrayList.size()) {
                resolverBundle = (ResolverBundle)arrayList.get(n3);
                this.groupingChecker.removeAllExportConstraints(resolverBundle);
                this.groupingChecker.addInitialGroupingConstraints(resolverBundle);
                resolverBundle.clearWires(false);
                resolverBundle.clearRefs();
                ++n3;
            }
            this.groupingChecker.setCheckCycles(true);
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            int n5 = 0;
            while (n5 < arrayList.size()) {
                this.resolveBundle((ResolverBundle)arrayList.get(n5), arrayList2);
                ++n5;
            }
            this.groupingChecker.setCheckCycles(false);
            this.checkCycle(arrayList2);
        } else {
            n3 = 0;
            while (n3 < arrayList.size()) {
                if (DEBUG || DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + arrayList.get(n3) + " to RESOLVED");
                }
                this.setBundleResolved((ResolverBundle)arrayList.get(n3));
                ++n3;
            }
        }
    }

    private boolean isCycleConsistent(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
            int n = 0;
            while (n < bundleConstraintArray.length) {
                if (bundleConstraintArray[n].getMatchingBundle() != null && this.groupingChecker.isConsistent(bundleConstraintArray[n], bundleConstraintArray[n].getMatchingBundle()) != null) {
                    return false;
                }
                ++n;
            }
            ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
            int n2 = 0;
            while (n2 < resolverImportArray.length) {
                if (resolverImportArray[n2].getMatchingExport() != null && this.groupingChecker.isConsistent(resolverImportArray[n2], resolverImportArray[n2].getMatchingExport()) != null) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean selectSingletons(ResolverBundle[] resolverBundleArray, ArrayList arrayList) {
        boolean bl = false;
        int n = 0;
        while (n < resolverBundleArray.length) {
            Object[] objectArray;
            BundleDescription bundleDescription = resolverBundleArray[n].getBundle();
            if (bundleDescription.isSingleton() && bundleDescription.isResolved() && !arrayList.contains(bundleDescription) && (objectArray = this.resolverBundles.get(bundleDescription.getName())).length > 1) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    BundleDescription bundleDescription2 = ((VersionSupplier)objectArray[n2]).getBundle();
                    ResolverBundle resolverBundle = (ResolverBundle)objectArray[n2];
                    if (objectArray[n2] != resolverBundleArray[n] && bundleDescription2.isSingleton() && bundleDescription2.isResolved() && !arrayList.contains(bundleDescription2)) {
                        boolean bl2;
                        bl = true;
                        boolean bl3 = this.selectionPolicy != null ? this.selectionPolicy.compare(bundleDescription2, bundleDescription) < 0 : (bl2 = bundleDescription2.getVersion().compareTo(bundleDescription.getVersion()) > 0);
                        if (bl2 && resolverBundle.getRefs() >= resolverBundleArray[n].getRefs()) {
                            if (arrayList.contains(resolverBundleArray[n].getBundle())) break;
                            arrayList.add(resolverBundleArray[n].getBundle());
                            break;
                        }
                        if (!arrayList.contains(bundleDescription2)) {
                            arrayList.add(bundleDescription2);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(iterator.next()), false);
        }
        return bl;
    }

    private void resolveFragment(ResolverBundle resolverBundle) {
        if (!resolverBundle.isFragment()) {
            return;
        }
        if (resolverBundle.getHost().foundMatchingBundles()) {
            this.stateResolveFragConstraints(resolverBundle);
            this.setBundleResolved(resolverBundle);
        } else {
            this.state.addResolverError(resolverBundle.getBundle(), 4, resolverBundle.getHost().getVersionConstraint().toString(), resolverBundle.getHost().getVersionConstraint());
        }
    }

    private boolean resolveBundle(ResolverBundle resolverBundle, ArrayList arrayList) {
        int n;
        ResolverConstraint[] resolverConstraintArray;
        boolean bl;
        if (resolverBundle.isFragment()) {
            return false;
        }
        if (!resolverBundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + resolverBundle + " is unresolvable");
            }
            return false;
        }
        if (resolverBundle.getState() == 2) {
            if (DEBUG) {
                ResolverImpl.log("  - " + resolverBundle + " already resolved");
            }
            return true;
        }
        if (resolverBundle.getState() == 0) {
            resolverBundle.clearWires(true);
            this.setBundleResolving(resolverBundle);
        }
        if (!(bl = false)) {
            resolverConstraintArray = resolverBundle.getGenericRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveGenericReq((GenericConstraint)resolverConstraintArray[n], arrayList)) {
                    if (DEBUG || DEBUG_GENERICS) {
                        ResolverImpl.log("** GENERICS " + resolverConstraintArray[n].getVersionConstraint().getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 32768, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), null));
                    } else {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveRequire((BundleConstraint)resolverConstraintArray[n], arrayList)) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log("** REQUIRE " + resolverConstraintArray[n].getVersionConstraint().getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 2, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), resolverConstraintArray[n]));
                    } else {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getImportPackages();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!((ResolverImport)resolverConstraintArray[n]).isDynamic() && !this.resolveImport((ResolverImport)resolverConstraintArray[n], true, arrayList)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log("** IMPORT " + ((ResolverImport)resolverConstraintArray[n]).getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 1, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getBundleDescription()), resolverConstraintArray[n]));
                    } else {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (bl) {
            this.setBundleUnresolved(resolverBundle, false);
            if (DEBUG) {
                ResolverImpl.log(resolverBundle + " NOT RESOLVED");
            }
        } else if (!arrayList.contains(resolverBundle)) {
            this.setBundleResolved(resolverBundle);
            if (DEBUG) {
                ResolverImpl.log(resolverBundle + " RESOLVED");
            }
        }
        if (resolverBundle.getState() == 0) {
            resolverBundle.setResolvable(false);
        }
        this.stateResolveConstraints(resolverBundle);
        return resolverBundle.getState() != 0;
    }

    private boolean resolveGenericReq(GenericConstraint genericConstraint, ArrayList arrayList) {
        GenericCapability[] genericCapabilityArray;
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + genericConstraint.getBundle() + ", " + genericConstraint.getVersionConstraint());
        }
        if ((genericCapabilityArray = genericConstraint.getMatchingCapabilities()) != null) {
            int n = 0;
            while (n < genericCapabilityArray.length) {
                if (genericCapabilityArray[n].getResolverBundle().getState() == 1 && !arrayList.contains(genericConstraint.getBundle())) {
                    arrayList.add(genericConstraint.getBundle());
                }
                ++n;
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] objectArray = this.resolverGenerics.get(genericConstraint.getVersionConstraint().getName());
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            GenericCapability genericCapability = (GenericCapability)objectArray[n];
            if (DEBUG_GENERICS) {
                ResolverImpl.log("CHECKING GENERICS: " + genericCapability.getBaseDescription());
            }
            if (genericConstraint.isSatisfiedBy(genericCapability)) {
                genericCapability.getResolverBundle().addRef(genericConstraint.getBundle());
                if (!bl || (((GenericSpecification)genericConstraint.getVersionConstraint()).getResolution() & 2) != 0) {
                    genericConstraint.setMatchingCapability(genericCapability);
                    if (genericConstraint.getBundle() == genericCapability.getResolverBundle()) {
                        bl = true;
                    } else {
                        ResolverBundle[] resolverBundleArray;
                        if (genericCapability.isFromFragment()) {
                            resolverBundleArray = genericCapability.getResolverBundle().getHost().getMatchingBundles();
                        } else {
                            ResolverBundle[] resolverBundleArray2 = new ResolverBundle[1];
                            resolverBundleArray = resolverBundleArray2;
                            resolverBundleArray2[0] = genericCapability.getResolverBundle();
                        }
                        ResolverBundle[] resolverBundleArray3 = resolverBundleArray;
                        boolean bl2 = false;
                        int n2 = 0;
                        while (resolverBundleArray3 != null && n2 < resolverBundleArray3.length) {
                            if (resolverBundleArray3[n2].getState() == 2 || this.resolveBundle(resolverBundleArray3[n2], arrayList)) {
                                bl2 |= !genericCapability.isFromFragment() ? true : genericCapability.getResolverBundle().getHost().getMatchingBundles() != null;
                                if (resolverBundleArray3[n2].getState() == 1 && !arrayList.contains(resolverBundleArray3[n2])) {
                                    arrayList.add(resolverBundleArray3[n2]);
                                }
                            }
                            ++n2;
                        }
                        if (!bl2) {
                            genericConstraint.removeMatchingCapability(genericCapability);
                        } else {
                            if (DEBUG_GENERICS) {
                                ResolverImpl.log("Found match: " + genericCapability.getBaseDescription() + ". Wiring");
                            }
                            bl = true;
                        }
                    }
                }
            }
            ++n;
        }
        return bl ? true : (((GenericSpecification)genericConstraint.getVersionConstraint()).getResolution() & 1) != 0;
    }

    private boolean resolveRequire(BundleConstraint bundleConstraint, ArrayList arrayList) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + bundleConstraint.getBundle() + ", " + bundleConstraint.getVersionConstraint());
        }
        if (bundleConstraint.getMatchingBundle() != null) {
            if (bundleConstraint.getMatchingBundle().getState() == 1 && !arrayList.contains(bundleConstraint.getBundle())) {
                arrayList.add(bundleConstraint.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("require-bundle cycle: " + bundleConstraint.getBundle() + " -> " + bundleConstraint.getMatchingBundle());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] objectArray = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle = (ResolverBundle)objectArray[n];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + resolverBundle.getBundle());
            }
            if (bundleConstraint.isSatisfiedBy(resolverBundle)) {
                resolverBundle.addRef(bundleConstraint.getBundle());
                if (!bl) {
                    bundleConstraint.setMatchingBundle(resolverBundle);
                    if (bundleConstraint.getBundle() == resolverBundle) {
                        bl = true;
                    } else if (resolverBundle.getState() != 2 && !this.resolveBundle(resolverBundle, arrayList)) {
                        bundleConstraint.setMatchingBundle(null);
                    } else {
                        if (resolverBundle.getState() == 1 && !arrayList.contains(bundleConstraint.getBundle())) {
                            arrayList.add(bundleConstraint.getBundle());
                            if (DEBUG_CYCLES) {
                                ResolverImpl.log("require-bundle cycle: " + bundleConstraint.getBundle() + " -> " + bundleConstraint.getMatchingBundle());
                            }
                        }
                        if (DEBUG_REQUIRES) {
                            ResolverImpl.log("Found match: " + resolverBundle.getBundle() + ". Wiring");
                        }
                        bl = this.checkRequiresConstraints(bundleConstraint, bundleConstraint.getMatchingBundle());
                    }
                }
            }
            ++n;
        }
        return bl || bundleConstraint.isOptional();
    }

    private boolean checkRequiresConstraints(BundleConstraint bundleConstraint, ResolverBundle resolverBundle) {
        if (this.groupingChecker.isConsistent(bundleConstraint, resolverBundle) != null) {
            bundleConstraint.setMatchingBundle(null);
            this.state.addResolverError(bundleConstraint.getBundleDescription(), 64, resolverBundle.getBundle().toString(), bundleConstraint.getVersionConstraint());
            return bundleConstraint.isOptional();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean resolveImport(ResolverImport var1_1, boolean var2_2, ArrayList var3_3) {
        if (ResolverImpl.DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + var1_1.getBundle() + ", " + var1_1.getName());
        }
        if (var1_1.getMatchingExport() != null) {
            if (var1_1.getMatchingExport().getExporter().getState() == 1 && !var3_3.contains(var1_1.getBundle())) {
                var3_3.add(var1_1.getBundle());
                if (ResolverImpl.DEBUG_CYCLES) {
                    ResolverImpl.log("import-package cycle: " + var1_1.getBundle() + " -> " + var1_1.getMatchingExport() + " from " + var1_1.getMatchingExport().getBundle());
                }
            }
            if (ResolverImpl.DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        var4_4 = false;
        var5_5 = this.resolverExports.get(var1_1.getName());
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            block25: {
                var7_7 = (ResolverExport)var5_5[var6_6];
                if (ResolverImpl.DEBUG_IMPORTS) {
                    ResolverImpl.log("CHECKING: " + var7_7.getExporter().getBundle() + ", " + var7_7.getName());
                }
                if (!var1_1.isSatisfiedBy(var7_7) || !var1_1.isNotAnUnresolvableWiring(var7_7)) break block25;
                var8_8 = var7_7.getExporter().getState();
                if (var1_1.isDynamic() && var8_8 != 2 || var1_1.getBundle() == var7_7.getExporter() && !var7_7.getExportPackageDescription().isRoot()) break block25;
                var7_7.getExporter().addRef(var1_1.getBundle());
                if (var4_4) break block25;
                var1_1.setMatchingExport(var7_7);
                if (var1_1.getBundle() == var7_7.getExporter()) ** GOTO lbl-1000
                var9_9 = var1_1.getBundle().getExports(var1_1.getName());
                var10_10 = 0;
                while (var10_10 < var9_9.length) {
                    if (!var9_9[var10_10].getExportPackageDescription().isRoot() || var7_7.getExportPackageDescription().isRoot()) {
                        if (var9_9[var10_10].getExportPackageDescription().isRoot()) {
                            this.resolverExports.remove(var9_9[var10_10]);
                        }
                        ++var10_10;
                        continue;
                    }
                    break block25;
                }
                if (var8_8 != 2 && !this.resolveBundle(var7_7.getExporter(), var3_3) || var7_7.isDropped()) {
                    if (var1_1.getMatchingExport() != null && var1_1.getMatchingExport() != var7_7) {
                        return true;
                    }
                    var10_10 = 0;
                    while (var10_10 < var9_9.length) {
                        this.resolverExports.put(var9_9[var10_10].getName(), var9_9[var10_10]);
                        ++var10_10;
                    }
                    var1_1.setMatchingExport(null);
                } else lbl-1000:
                // 2 sources

                {
                    if (!var1_1.getBundle().isResolvable()) {
                        return false;
                    }
                    if (this.checkImportConstraints(var1_1, var1_1.getMatchingExport(), var3_3) && var1_1.getMatchingExport() != null) {
                        if (var7_7 != var1_1.getMatchingExport()) {
                            var7_7 = var1_1.getMatchingExport();
                        }
                        if (var1_1.getBundle() != var7_7.getExporter() && var7_7.getExporter().getState() == 1 && !var3_3.contains(var1_1.getBundle())) {
                            var3_3.add(var1_1.getBundle());
                            if (ResolverImpl.DEBUG_CYCLES) {
                                ResolverImpl.log("import-package cycle: " + var1_1.getBundle() + " -> " + var1_1.getMatchingExport() + " from " + var1_1.getMatchingExport().getBundle());
                            }
                        }
                        if (ResolverImpl.DEBUG_IMPORTS) {
                            ResolverImpl.log("Found match: " + var7_7.getExporter() + ". Wiring " + var1_1.getBundle() + ":" + var1_1.getName());
                        }
                        var4_4 = true;
                    } else if (!var1_1.getBundle().isResolvable()) {
                        return false;
                    }
                    if (!var4_4 && var1_1.getMatchingExport() != null && var1_1.getMatchingExport() != var7_7) {
                        return true;
                    }
                }
            }
            ++var6_6;
        }
        if (var4_4) {
            return true;
        }
        if (var2_2 && this.resolveImportReprovide(var1_1, var3_3)) {
            return true;
        }
        return var1_1.isOptional() != false;
    }

    private boolean resolveImportReprovide(ResolverImport resolverImport, ArrayList arrayList) {
        String string = ((ImportPackageSpecification)resolverImport.getVersionConstraint()).getBundleSymbolicName();
        if (string == null) {
            return false;
        }
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Checking reprovides: " + resolverImport.getName());
        }
        Object[] objectArray = this.resolverBundles.get(string);
        int n = 0;
        while (n < objectArray.length) {
            if (this.resolveBundle((ResolverBundle)objectArray[n], arrayList) && this.resolveImportReprovide0(resolverImport, (ResolverBundle)objectArray[n], (ResolverBundle)objectArray[n], arrayList, new ArrayList(5))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean resolveImportReprovide0(ResolverImport resolverImport, ResolverBundle resolverBundle, ResolverBundle resolverBundle2, ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.contains(resolverBundle2)) {
            return false;
        }
        arrayList2.add(resolverBundle2);
        BundleConstraint[] bundleConstraintArray = resolverBundle2.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (((BundleSpecification)bundleConstraintArray[n].getVersionConstraint()).isExported() && bundleConstraintArray[n].getMatchingBundle() != null) {
                ResolverExport[] resolverExportArray = bundleConstraintArray[n].getMatchingBundle().getExports(resolverImport.getName());
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    Map map = resolverExportArray[n2].getExportPackageDescription().getDirectives();
                    map.remove("uses");
                    ExportPackageDescription exportPackageDescription = this.state.getFactory().createExportPackageDescription(resolverExportArray[n2].getName(), resolverExportArray[n2].getVersion(), map, resolverExportArray[n2].getExportPackageDescription().getAttributes(), false, resolverBundle.getBundle());
                    if (resolverImport.getVersionConstraint().isSatisfiedBy(exportPackageDescription)) {
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log(" - Creating re-export for reprovide: " + resolverBundle + ":" + exportPackageDescription.getName());
                        }
                        ResolverExport resolverExport = new ResolverExport(resolverBundle, exportPackageDescription);
                        resolverBundle.addExport(resolverExport);
                        this.resolverExports.put(resolverExport.getName(), resolverExport);
                        if (this.resolveImport(resolverImport, false, arrayList)) {
                            return true;
                        }
                    }
                    ++n2;
                }
                if (this.resolveImportReprovide0(resolverImport, resolverBundle, bundleConstraintArray[n].getMatchingBundle(), arrayList, arrayList2)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean checkImportConstraints(ResolverImport resolverImport, ResolverExport resolverExport, ArrayList arrayList) {
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  Checking grouping for " + resolverImport.getBundle() + ":" + resolverImport.getName() + " -> " + resolverExport.getExporter() + ":" + resolverExport.getName());
        }
        ResolverBundle resolverBundle = resolverImport.getBundle();
        ResolverExport resolverExport2 = this.groupingChecker.isConsistent(resolverImport, resolverExport);
        if (resolverExport2 == null) {
            return true;
        }
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  * grouping clash with " + resolverExport2.getExporter() + ":" + resolverExport2.getName());
        }
        resolverImport.addUnresolvableWiring(resolverExport.getExporter());
        resolverImport.setMatchingExport(null);
        if (this.resolveImport(resolverImport, false, arrayList)) {
            return true;
        }
        if (resolverImport.isDynamic()) {
            return false;
        }
        resolverImport.clearUnresolvableWirings();
        resolverImport.setMatchingExport(resolverExport);
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].getMatchingExport() != null && resolverImportArray[n].getMatchingExport().getName().equals(resolverExport2.getName())) {
                resolverImportArray[n].addUnresolvableWiring(resolverImportArray[n].getMatchingExport().getExporter());
                resolverImportArray[n].setMatchingExport(null);
                VersionSupplier[] versionSupplierArray = resolverBundle.getExports(resolverImportArray[n].getName());
                this.resolverExports.put(versionSupplierArray);
            }
            ++n;
        }
        if (this.resolveBundle(resolverBundle, arrayList)) {
            return true;
        }
        this.state.addResolverError(resolverImport.getVersionConstraint().getBundle(), 32, resolverImport.getVersionConstraint().toString(), resolverImport.getVersionConstraint());
        return false;
    }

    private void setBundleUnresolved(ResolverBundle resolverBundle, boolean bl) {
        if (resolverBundle.getState() == 0) {
            return;
        }
        if (resolverBundle.getBundle().isResolved()) {
            this.resolverExports.remove(resolverBundle.getExportPackages());
            resolverBundle.initialize(false);
            if (!bl) {
                this.resolverExports.put(resolverBundle.getExportPackages());
            }
        }
        if (!bl) {
            this.unresolvedBundles.add(resolverBundle);
        }
        resolverBundle.detachAllFragments();
        resolverBundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 2) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 1) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(1);
    }

    private void stateResolveBundles(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (resolverBundleArray[n].isResolved() && !resolverBundleArray[n].getBundle().isResolved()) {
                this.stateResolveBundle(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void stateResolveConstraints(ResolverBundle resolverBundle) {
        GenericCapability[] genericCapabilityArray;
        Object object;
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            ResolverExport resolverExport = resolverImportArray[n].getMatchingExport();
            object = resolverExport == null ? null : resolverExport.getExportPackageDescription();
            this.state.resolveConstraint(resolverImportArray[n].getVersionConstraint(), (BaseDescription)object);
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            object = bundleConstraintArray[n2].getMatchingBundle();
            genericCapabilityArray = object == null ? null : ((ResolverBundle)object).getBundle();
            this.state.resolveConstraint(bundleConstraintArray[n2].getVersionConstraint(), (BaseDescription)genericCapabilityArray);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            genericCapabilityArray = genericConstraintArray[n3].getMatchingCapabilities();
            if (genericCapabilityArray == null) {
                this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), null);
            } else {
                int n4 = 0;
                while (n4 < genericCapabilityArray.length) {
                    this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), genericCapabilityArray[n4].getBaseDescription());
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private void stateResolveFragConstraints(ResolverBundle resolverBundle) {
        Object object;
        Object object2;
        ResolverBundle resolverBundle2 = resolverBundle.getHost().getMatchingBundle();
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundle().getImportPackages();
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            ResolverImport resolverImport = resolverBundle2.getImport(importPackageSpecificationArray[n].getName());
            object2 = resolverImport == null ? null : resolverImport.getMatchingExport();
            object = object2 == null ? null : ((ResolverExport)object2).getExportPackageDescription();
            this.state.resolveConstraint(importPackageSpecificationArray[n], (BaseDescription)object);
            ++n;
        }
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundle().getRequiredBundles();
        int n2 = 0;
        while (n2 < bundleSpecificationArray.length) {
            object2 = resolverBundle2.getRequire(bundleSpecificationArray[n2].getName());
            object = object2 == null ? null : ((BundleConstraint)object2).getMatchingBundle();
            BundleDescription bundleDescription = object == null ? null : ((ResolverBundle)object).getBundle();
            this.state.resolveConstraint(bundleSpecificationArray[n2], bundleDescription);
            ++n2;
        }
    }

    private void stateResolveBundle(ResolverBundle resolverBundle) {
        ResolverBundle[] resolverBundleArray;
        ResolverExport[] resolverExportArray = resolverBundle.getSelectedExports();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(resolverExportArray.length);
        int n = 0;
        while (n < resolverExportArray.length) {
            arrayList.add(resolverExportArray[n].getExportPackageDescription());
            ++n;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        ArrayList<ExportPackageDescription> arrayList2 = new ArrayList<ExportPackageDescription>(resolverImportArray.length);
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].getMatchingExport() != null) {
                arrayList2.add(resolverImportArray[n2].getMatchingExport().getExportPackageDescription());
            }
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = arrayList2.toArray(new ExportPackageDescription[arrayList2.size()]);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList<BundleDescription> arrayList3 = new ArrayList<BundleDescription>(bundleConstraintArray.length);
        int n3 = 0;
        while (n3 < bundleConstraintArray.length) {
            if (bundleConstraintArray[n3].getMatchingBundle() != null) {
                arrayList3.add(bundleConstraintArray[n3].getMatchingBundle().getBundle());
            }
            ++n3;
        }
        BundleDescription[] bundleDescriptionArray = arrayList3.toArray(new BundleDescription[arrayList3.size()]);
        BundleDescription[] bundleDescriptionArray2 = null;
        if (resolverBundle.isFragment() && (resolverBundleArray = resolverBundle.getHost().getMatchingBundles()) != null && resolverBundleArray.length > 0) {
            bundleDescriptionArray2 = new BundleDescription[resolverBundleArray.length];
            int n4 = 0;
            while (n4 < resolverBundleArray.length) {
                bundleDescriptionArray2[n4] = resolverBundleArray[n4].getBundle();
                if (resolverBundle.isNewFragmentExports()) {
                    ResolverExport[] resolverExportArray2 = resolverBundleArray[n4].getSelectedExports();
                    ExportPackageDescription[] exportPackageDescriptionArray3 = new ExportPackageDescription[resolverExportArray2.length];
                    int n5 = 0;
                    while (n5 < resolverExportArray2.length) {
                        exportPackageDescriptionArray3[n5] = resolverExportArray2[n5].getExportPackageDescription();
                        ++n5;
                    }
                    this.state.resolveBundle(bundleDescriptionArray2[n4], true, null, exportPackageDescriptionArray3, bundleDescriptionArray2[n4].getResolvedRequires(), bundleDescriptionArray2[n4].getResolvedImports());
                }
                ++n4;
            }
        }
        this.state.resolveBundle(resolverBundle.getBundle(), true, bundleDescriptionArray2, exportPackageDescriptionArray, bundleDescriptionArray, exportPackageDescriptionArray2);
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription bundleDescription, String string) {
        Object object;
        ResolverBundle resolverBundle;
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescription)).getExport(string) != null) {
            return null;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        boolean bl = false;
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].isDynamic()) {
                object = resolverImportArray[n].getName();
                if (((String)object).equals("*") || ((String)object).endsWith(".*") && string.startsWith(((String)object).substring(0, ((String)object).length() - 2))) {
                    resolverImportArray[n].setName(string);
                }
                if (string.equals(resolverImportArray[n].getName())) {
                    bl = true;
                    if (this.resolveImport(resolverImportArray[n], true, new ArrayList())) {
                        resolverImportArray[n].setName(null);
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("Resolved dynamic import: " + resolverBundle + ":" + resolverImportArray[n].getName() + " -> " + resolverImportArray[n].getMatchingExport().getExporter() + ":" + string);
                        }
                        ExportPackageDescription exportPackageDescription = resolverImportArray[n].getMatchingExport().getExportPackageDescription();
                        if (((String)object).endsWith("*")) {
                            resolverImportArray[n].setMatchingExport(null);
                        }
                        return exportPackageDescription;
                    }
                }
                resolverImportArray[n].setName(null);
            }
            ++n;
        }
        if (!bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put("resolution", "dynamic");
            object = this.state.getFactory().createImportPackageSpecification(string, null, null, null, hashMap, null, bundleDescription);
            ResolverImport resolverImport = new ResolverImport(resolverBundle, (ImportPackageSpecification)object);
            if (this.resolveImport(resolverImport, true, new ArrayList())) {
                return resolverImport.getMatchingExport().getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + string);
        }
        return null;
    }

    public void bundleAdded(BundleDescription bundleDescription) {
        if (!this.initialized) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.unresolvedBundles.size()) {
            ResolverBundle resolverBundle = (ResolverBundle)this.unresolvedBundles.get(n);
            if (resolverBundle.getBundle() == bundleDescription) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
            this.bundleMapping.put(bundleDescription, resolverBundle);
            this.unresolvedBundles.add(resolverBundle);
            this.resolverExports.put(resolverBundle.getExportPackages());
            this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
            this.resolverGenerics.put(resolverBundle.getGenericCapabilities());
        }
    }

    public void bundleRemoved(BundleDescription bundleDescription, boolean bl) {
        if (bl) {
            this.removalPending.put(new Long(bundleDescription.getBundleId()), bundleDescription);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescription);
        if (resolverBundle == null) {
            return;
        }
        if (!bl) {
            this.bundleMapping.remove(bundleDescription);
            this.groupingChecker.removeAllExportConstraints(resolverBundle);
        }
        if (!bl || !bundleDescription.isResolved()) {
            this.resolverExports.remove(resolverBundle.getExportPackages());
            this.resolverBundles.remove(resolverBundle);
            this.resolverGenerics.remove(resolverBundle.getGenericCapabilities());
        }
        this.unresolvedBundles.remove(resolverBundle);
    }

    private void unresolveBundle(ResolverBundle resolverBundle, boolean bl) {
        if (resolverBundle == null) {
            return;
        }
        Object[] objectArray = this.removalPending.remove(new Long(resolverBundle.getBundle().getBundleId()));
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)this.bundleMapping.get(objectArray[n]);
            this.unresolveBundle(resolverBundle2, true);
            this.state.removeBundleComplete((BundleDescription)objectArray[n]);
            this.resolverExports.remove(resolverBundle2.getExportPackages());
            this.resolverBundles.remove(resolverBundle2);
            this.resolverGenerics.remove(resolverBundle2.getGenericCapabilities());
            this.bundleMapping.remove(objectArray[n]);
            this.groupingChecker.removeAllExportConstraints(resolverBundle2);
            if (objectArray[n] == resolverBundle.getBundle()) {
                bl = true;
            }
            ++n;
        }
        if (!resolverBundle.getBundle().isResolved()) {
            return;
        }
        this.setBundleUnresolved(resolverBundle, bl);
        BundleDescription[] bundleDescriptionArray = resolverBundle.getBundle().getDependents();
        this.state.resolveBundle(resolverBundle.getBundle(), false, null, null, null, null);
        int n2 = 0;
        while (n2 < bundleDescriptionArray.length) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(bundleDescriptionArray[n2]), false);
            ++n2;
        }
    }

    public void bundleUpdated(BundleDescription bundleDescription, BundleDescription bundleDescription2, boolean bl) {
        this.bundleRemoved(bundleDescription2, bl);
        this.bundleAdded(bundleDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.resolverGenerics = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        Object[] objectArray = this.removalPending.getAllValues();
        int n = 0;
        while (n < objectArray.length) {
            this.state.removeBundleComplete((BundleDescription)objectArray[n]);
            ++n;
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        this.flush();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = frameworkDebugOptions.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = frameworkDebugOptions.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = frameworkDebugOptions.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GENERICS = frameworkDebugOptions.getBooleanOption(OPTION_GENERICS, false);
        DEBUG_GROUPING = frameworkDebugOptions.getBooleanOption(OPTION_GROUPING, false);
        DEBUG_CYCLES = frameworkDebugOptions.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        ResolverImpl.log("****** Result Wirings ******");
        Object[] objectArray = this.resolverBundles.getAllValues();
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle = (ResolverBundle)objectArray[n];
            if (!resolverBundle.getBundle().isResolved()) {
                int n2;
                Object[] objectArray2;
                ResolverImpl.log("    * WIRING for " + resolverBundle);
                BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
                if (bundleConstraintArray.length == 0) {
                    ResolverImpl.log("        (r) no requires");
                } else {
                    int n3 = 0;
                    while (n3 < bundleConstraintArray.length) {
                        if (bundleConstraintArray[n3].getMatchingBundle() == null) {
                            ResolverImpl.log("        (r) " + resolverBundle.getBundle() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (r) " + resolverBundle.getBundle() + " -> " + bundleConstraintArray[n3].getMatchingBundle());
                        }
                        ++n3;
                    }
                }
                BundleConstraint bundleConstraint = resolverBundle.getHost();
                if (bundleConstraint != null && (objectArray2 = bundleConstraint.getMatchingBundles()) != null) {
                    n2 = 0;
                    while (n2 < objectArray2.length) {
                        ResolverImpl.log("        (h) " + resolverBundle.getBundle() + " -> " + ((ResolverBundle)objectArray2[n2]).getBundle());
                        ++n2;
                    }
                }
                if ((objectArray2 = resolverBundle.getImportPackages()).length == 0) {
                    ResolverImpl.log("        (w) no imports");
                } else {
                    n2 = 0;
                    while (n2 < objectArray2.length) {
                        if (((ResolverImport)objectArray2[n2]).isDynamic() && ((ResolverImport)objectArray2[n2]).getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> DYNAMIC");
                        } else if (((ResolverImport)objectArray2[n2]).isOptional() && ((ResolverImport)objectArray2[n2]).getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> OPTIONAL (could not be wired)");
                        } else if (((ResolverImport)objectArray2[n2]).getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> " + ((ResolverImport)objectArray2[n2]).getMatchingExport().getExporter() + ":" + ((ResolverImport)objectArray2[n2]).getMatchingExport().getName());
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    static void log(String string) {
        Debug.println(string);
    }

    VersionHashMap getResolverExports() {
        return this.resolverExports;
    }

    public void setSelectionPolicy(Comparator comparator) {
        this.selectionPolicy = comparator;
    }

    public Comparator getSelectionPolicy() {
        return this.selectionPolicy;
    }
}

