/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.verifier.BERProcessor;
import org.eclipse.osgi.internal.verifier.KeyStores;

public class PKCS7Processor
implements CertificateChain {
    private static final int[] SIGNEDDATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static final int[] MD5_OID = new int[]{1, 2, 840, 113549, 2, 5};
    private static final int[] MD2_OID = new int[]{1, 2, 840, 113549, 2, 2};
    private static final int[] SHA1_OID = new int[]{1, 3, 14, 3, 2, 26};
    private static final int[] DSA_OID = new int[]{1, 2, 840, 10040, 4, 1};
    private static final int[] RSA_OID = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static CertificateFactory certFact;
    private static KeyStores keyStores;
    private String certChain;
    private Certificate[] certificates;
    private boolean trusted;

    static {
        keyStores = new KeyStores();
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
    }

    String oid2String(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    String findEncryption(int[] nArray) throws NoSuchAlgorithmException {
        if (Arrays.equals(DSA_OID, nArray)) {
            return "DSA";
        }
        if (Arrays.equals(RSA_OID, nArray)) {
            return "RSA";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(nArray));
    }

    String findDigest(int[] nArray) throws NoSuchAlgorithmException {
        if (Arrays.equals(SHA1_OID, nArray)) {
            return "SHA1";
        }
        if (Arrays.equals(MD5_OID, nArray)) {
            return "MD5";
        }
        if (Arrays.equals(MD2_OID, nArray)) {
            return "MD2";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(nArray));
    }

    public PKCS7Processor(String string, boolean bl, byte[][] byArray) throws CertificateException {
        this.certChain = string;
        this.trusted = bl;
        this.certificates = new Certificate[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.certificates[n] = certFact.generateCertificate(new ByteArrayInputStream(byArray[n]));
            ++n;
        }
    }

    public PKCS7Processor(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws IOException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        boolean bl;
        X509Certificate x509Certificate;
        StringBuffer stringBuffer;
        ArrayList<Object> arrayList;
        block12: {
            X500Principal x500Principal;
            Object object;
            Collection<? extends Certificate> collection = certFact.generateCertificates(new ByteArrayInputStream(byArray, n, n2));
            BERProcessor bERProcessor = new BERProcessor(byArray, n, n2);
            bERProcessor = bERProcessor.stepInto();
            if (!Arrays.equals(bERProcessor.getObjId(), SIGNEDDATA_OID)) {
                throw new IOException("Not a valid PKCS#7 file");
            }
            bERProcessor.stepOver();
            bERProcessor = bERProcessor.stepInto();
            bERProcessor = bERProcessor.stepInto();
            bERProcessor.stepOver();
            bERProcessor.stepOver();
            bERProcessor.stepOver();
            bERProcessor.stepOver();
            if (bERProcessor.classOfTag == 0 && bERProcessor.tag == 1) {
                bERProcessor.stepOver();
            }
            bERProcessor = bERProcessor.stepInto();
            bERProcessor = bERProcessor.stepInto();
            bERProcessor.stepOver();
            BERProcessor bERProcessor2 = bERProcessor.stepInto();
            X500Principal x500Principal2 = new X500Principal(new ByteArrayInputStream(bERProcessor2.buffer, bERProcessor2.offset, bERProcessor2.endOffset - bERProcessor2.offset));
            bERProcessor2.stepOver();
            BigInteger bigInteger = bERProcessor2.getIntValue();
            Object object2 = null;
            Iterator<? extends Certificate> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (X509Certificate)iterator.next();
                if (!((X509Certificate)object).getIssuerX500Principal().equals(x500Principal2) || !((X509Certificate)object).getSerialNumber().equals(bigInteger)) continue;
                object2 = object;
                break;
            }
            if (object2 == null) {
                throw new CertificateException("Signer certificate not in pkcs7block");
            }
            bERProcessor.stepOver();
            object = bERProcessor.stepInto();
            String string = this.findDigest(((BERProcessor)object).getObjId());
            bERProcessor.stepOver();
            if (bERProcessor.classOfTag == 2) {
                bERProcessor.stepOver();
            }
            BERProcessor bERProcessor3 = bERProcessor.stepInto();
            String string2 = this.findEncryption(bERProcessor3.getObjId());
            bERProcessor.stepOver();
            byte[] byArray3 = bERProcessor.getBytes();
            Signature signature = Signature.getInstance(String.valueOf(string) + "with" + string2);
            signature.initVerify(((Certificate)object2).getPublicKey());
            signature.update(byArray2, n3, n4);
            if (!signature.verify(byArray3)) {
                throw new SignatureException("Signature doesn't verify");
            }
            arrayList = new ArrayList<Object>(1);
            arrayList.add(object2);
            stringBuffer = new StringBuffer();
            x509Certificate = (X509Certificate)object2;
            X509Certificate x509Certificate2 = null;
            bl = true;
            do {
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateException certificateException) {
                    bl = false;
                }
                if (x509Certificate2 != null) {
                    x509Certificate2.verify(x509Certificate.getPublicKey());
                    arrayList.add(x509Certificate);
                }
                x509Certificate2 = x509Certificate;
                x500Principal = x509Certificate.getSubjectX500Principal();
                X500Principal x500Principal3 = x509Certificate.getIssuerX500Principal();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(x500Principal);
                if (x500Principal.equals(x500Principal3)) break block12;
                x509Certificate = null;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    X509Certificate x509Certificate3 = (X509Certificate)iterator.next();
                    if (!x509Certificate3.getSubjectX500Principal().equals(x500Principal3)) continue;
                    x509Certificate = x509Certificate3;
                }
            } while (x509Certificate != null);
            throw new CertificateException(x500Principal + " missing from chain");
        }
        this.certificates = arrayList.toArray(new Certificate[arrayList.size()]);
        this.trusted = bl && keyStores.isTrusted(x509Certificate);
        this.certChain = stringBuffer.toString();
    }

    public Certificate getSigner() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0];
    }

    public Certificate getRoot() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[this.certificates.length - 1];
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public String getChain() {
        return this.certChain;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertificateChain)) {
            return false;
        }
        if (this.certificates == null) {
            return false;
        }
        CertificateChain certificateChain = (CertificateChain)object;
        if (this.trusted != certificateChain.isTrusted() || (this.certChain == null ? certificateChain.getChain() != null : !this.certChain.equals(certificateChain.getChain()))) {
            return false;
        }
        Certificate[] certificateArray = certificateChain.getCertificates();
        if (certificateArray == null || this.certificates.length != certificateArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.certificates.length) {
            if (!this.certificates[n].equals(certificateArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

