/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    static boolean eventsRegistered = false;
    TableColumn[] columns = new TableColumn[0];
    TableItem[] items = new TableItem[0];
    boolean isList = false;
    boolean visible_or_not;
    int border_height = 1;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Table.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point minsize = this.minimumSize();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        int itemHeights = 0;
        int remainingPixels = 0;
        itemHeights = this.visible_or_not ? size.y - this.getHeaderHeight() - 2 * this.border_height : size.y - 2 * this.border_height;
        remainingPixels = itemHeights % this.getItemHeight();
        if (remainingPixels != 0 && itemHeights / this.getItemHeight() < this.getItemCount()) {
            size.y += this.getItemHeight() - remainingPixels;
        }
        int scrollbarWidth = "Windows CE".equalsIgnoreCase(System.getProperty("os.name")) ? 13 : 17;
        boolean needscrolly = false;
        if (size.x < minsize.x) {
            needscrolly = true;
        }
        if (size.y < minsize.y) {
            size.x += scrollbarWidth;
        }
        if (needscrolly) {
            size.y += scrollbarWidth;
        }
        return new Point(size.x, size.y);
    }

    static int checkStyle(int style) {
        if (com.ibm.ugl.eswt.expanded.OS.Table_IncludeScrollbars()) {
            style |= 0x300;
        }
        style = Table.checkBits(style, 4, 2, 65536, 0, 0, 0);
        return style;
    }

    void addItem(TableItem item, int index) {
        int numItems;
        if (this.internal_getColumnCount() == 0) {
            new TableColumn(this, 16384);
            this.isList = true;
        }
        if ((numItems = this.getItemCount()) == this.items.length) {
            TableItem[] newItems = new TableItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if (this.items[index] != null) {
            System.arraycopy(this.items, index, this.items, index + 1, this.getItemCount() - index);
        }
        this.items[index] = item;
        if (this.isList()) {
            this.columns[0].pack();
        }
    }

    void checkColumnIndex(int index) {
        if (this.isList()) {
            Table.error(6);
        }
        int count = this.internal_getColumnCount();
        if (index < 0 || index > count - 1) {
            Table.error(6);
        }
    }

    void checkItemIndex(int index) {
        int count = this.getItemCount();
        if (index < 0 || index > count - 1) {
            Table.error(6);
        }
    }

    void addColumn(TableColumn column, int index) {
        int numColumns;
        if (this.isList()) {
            this.columns = new TableColumn[4];
            this.columns[0] = column;
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                TableItem item = this.items[i];
                item.setText(1, item.getText(0));
                item.setImage(1, item.getImage(0));
                item.setFont(1, item.getFont(0));
                item.setBackground(1, item.getBackground(0));
                item.setForeground(1, item.getForeground(0));
            }
        }
        if ((numColumns = this.internal_getColumnCount()) == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        int itemCount = this.getItemCount();
        int columnCount = numColumns + 1;
        for (int i = 0; i < itemCount; ++i) {
            int[] cellFgRGBs;
            int[] cellBgRGBs;
            Image[] images;
            TableItem item = this.items[i];
            String[] strings = item.texts;
            if (strings != null) {
                String[] temp = new String[columnCount];
                System.arraycopy(strings, 0, temp, 0, index);
                System.arraycopy(strings, index, temp, index + 1, columnCount - index - 1);
                item.texts = temp;
            }
            if ((images = item.images) != null) {
                Image[] temp = new Image[columnCount];
                System.arraycopy(images, 0, temp, 0, index);
                System.arraycopy(images, index, temp, index + 1, columnCount - index - 1);
                item.images = temp;
            }
            if ((cellBgRGBs = item.cellBgRGBs) != null) {
                int[] temp = new int[columnCount];
                System.arraycopy(cellBgRGBs, 0, temp, 0, index);
                System.arraycopy(cellBgRGBs, index, temp, index + 1, columnCount - index - 1);
                temp[index] = -1;
                item.cellBgRGBs = temp;
            }
            if ((cellFgRGBs = item.cellFgRGBs) == null) continue;
            int[] temp = new int[columnCount];
            System.arraycopy(cellFgRGBs, 0, temp, 0, index);
            System.arraycopy(cellFgRGBs, index, temp, index + 1, columnCount - index - 1);
            temp[index] = -1;
            item.cellFgRGBs = temp;
        }
        if (this.columns[index] != null) {
            System.arraycopy(this.columns, index, this.columns, index + 1, this.getColumnCount() - index);
        }
        this.columns[index] = column;
        if (this.isList) {
            TableColumn removeCol = this.columns[0];
            removeCol.dispose();
            this.isList = false;
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            Table.error(5);
        }
        int itemCount = this.getItemCount();
        int length = indices.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        for (int i = length - 1; i >= 0; --i) {
            int index = indices[i];
            if (index < 0 || index >= itemCount) continue;
            TableItem item = this.getItem(indices[i]);
            item.setSelected(false);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        int itemCount = this.getItemCount();
        if (index < 0 || index >= itemCount) {
            return;
        }
        TableItem item = this.getItem(index);
        item.setSelected(false);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if (start == 0 && end == count - 1) {
            this.deselectAll();
        } else {
            for (int i = start; i <= end; ++i) {
                TableItem item = this.getItem(i);
                item.setSelected(false);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Table_SetAllSelected(this.internal_handle, false);
    }

    void destroyColumn(TableColumn column) {
        int columnCount = this.internal_getColumnCount();
        int index = this.indexOf(column);
        com.ibm.ugl.eswt.expanded.OS.TableColumn_Delete(column.internal_handle);
        TableColumn[] newColumns = new TableColumn[columnCount];
        System.arraycopy(this.columns, 0, newColumns, 0, index);
        System.arraycopy(this.columns, index + 1, newColumns, index, columnCount - index - 1);
        this.columns = newColumns;
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Object[] temp;
            Image[] images;
            TableItem item = this.items[i];
            if (item == null) continue;
            String[] strings = item.texts;
            if (strings != null) {
                if (columnCount == 0) {
                    item.texts = null;
                } else {
                    if (index == 0) {
                        item.text = strings[1];
                    }
                    String[] temp2 = new String[columnCount];
                    System.arraycopy(strings, 0, temp2, 0, index);
                    System.arraycopy(strings, index + 1, temp2, index, columnCount - index - 1);
                    item.texts = temp2;
                }
            }
            if ((images = item.images) != null) {
                if (columnCount == 0) {
                    item.images = null;
                } else {
                    if (index == 0) {
                        item.image = images[1];
                    }
                    Image[] temp3 = new Image[columnCount];
                    System.arraycopy(images, 0, temp3, 0, index);
                    System.arraycopy(images, index + 1, temp3, index, columnCount - index - 1);
                    item.images = temp3;
                }
            }
            if (item.cellBgRGBs != null) {
                if (columnCount == 0) {
                    item.cellBgRGBs = null;
                } else {
                    int[] cellBackground = item.cellBgRGBs;
                    temp = new int[columnCount];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index + 1, temp, index, columnCount - index - 1);
                    item.cellBgRGBs = temp;
                }
            }
            if (item.cellFgRGBs != null) {
                if (columnCount == 0) {
                    item.cellFgRGBs = null;
                } else {
                    int[] cellForeground = item.cellFgRGBs;
                    temp = new int[columnCount];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index + 1, temp, index, columnCount - index - 1);
                    item.cellFgRGBs = temp;
                }
            }
            if (item.cellFonts == null) continue;
            if (columnCount == 0) {
                item.cellFonts = null;
                continue;
            }
            Font[] cellFont = item.cellFonts;
            temp = new Font[columnCount];
            System.arraycopy(cellFont, 0, temp, 0, index);
            System.arraycopy(cellFont, index + 1, temp, index, columnCount - index - 1);
            item.cellFonts = (Font[])temp;
        }
    }

    void destroyItem(TableItem item) {
        int count = this.getItemCount();
        int index = this.indexOf(item);
        if (index == count) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.TableItem_Delete(this.internal_handle, index);
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        this.checkColumnIndex(index);
        return this.columns[index];
    }

    public int getColumnCount() {
        if (this.isList()) {
            return 0;
        }
        return this.internal_getColumnCount();
    }

    protected int internal_getColumnCount() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != null) continue;
            return i;
        }
        return this.columns.length;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        int size = this.getColumnCount();
        if (size == 0) {
            return new TableColumn[0];
        }
        TableColumn[] cols = new TableColumn[size];
        System.arraycopy(this.columns, 0, cols, 0, size);
        return cols;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Table_GetGridLineWidth(this.internal_handle);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.visible_or_not) {
            return 0;
        }
        return com.ibm.ugl.eswt.expanded.OS.Table_GetHeaderHeight(this.internal_handle) != 0 ? com.ibm.ugl.eswt.expanded.OS.Table_GetHeaderHeight(this.internal_handle) : this.getItemHeight() + 5;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Table_GetHeaderVisible(this.internal_handle);
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        this.checkItemIndex(index);
        return this.items[index];
    }

    public TableItem getItem(Point point) {
        int index;
        this.checkWidget();
        if (point == null) {
            Table.error(4);
        }
        if ((index = com.ibm.ugl.eswt.expanded.OS.Table_GetItemAt(this.internal_handle, point.x, point.y)) == -1) {
            return null;
        }
        return this.items[index];
    }

    public int getItemCount() {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] == null) continue;
            return i + 1;
        }
        return 0;
    }

    public int getItemHeight() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Table_GetItemHeight(this.internal_handle);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int size = this.getItemCount();
        if (size == 0) {
            return new TableItem[0];
        }
        TableItem[] newItems = new TableItem[size];
        System.arraycopy(this.items, 0, newItems, 0, size);
        return newItems;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Table_GetLinesVisible(this.internal_handle);
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int[] indices = com.ibm.ugl.eswt.expanded.OS.Table_GetSelectionIndices(this.internal_handle);
        TableItem[] tableItems = new TableItem[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            tableItems[i] = this.getItem(indices[i]);
        }
        return tableItems;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionIndices().length;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] indices = com.ibm.ugl.eswt.expanded.OS.Table_GetSelectionIndices(this.internal_handle);
        if (indices.length == 0) {
            return -1;
        }
        return indices[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] indices = com.ibm.ugl.eswt.expanded.OS.Table_GetSelectionIndices(this.internal_handle);
        return indices;
    }

    public int getTopIndex() {
        this.checkWidget();
        return com.ibm.ugl.eswt.expanded.OS.Table_GetTopItemIndex(this.internal_handle);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            Table.error(4);
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (column != this.columns[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            Table.error(4);
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (item != this.items[i]) continue;
            return i;
        }
        return -1;
    }

    protected void internal_createHandle(int index) {
        if (!eventsRegistered) {
            Display d = this.getDisplay();
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(d.internal_handle, 18, "org/eclipse/swt/widgets/Table", "tableCallback");
            eventsRegistered = true;
        }
        this.internal_handle = com.ibm.ugl.eswt.expanded.OS.Table_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
        this.columns = new TableColumn[4];
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 4) != 0) {
            nativeStyle |= 0x400000;
        }
        if ((this.internal_style & 2) != 0) {
            nativeStyle |= 0x800000;
        }
        if ((this.internal_style & 0x20) != 0) {
            nativeStyle |= 0x20;
        }
        if ((this.internal_style & 0x10000) != 0) {
            nativeStyle |= 0x10000;
        }
        return nativeStyle;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index > count - 1) {
            return false;
        }
        return this.getItem(index).isSelected();
    }

    boolean isList() {
        return this.isList;
    }

    Point minimumSize() {
        int width = 0;
        int height = 0;
        int[] pointArray = OS.Control_GetMinimumSize(this.internal_handle);
        width = pointArray[0];
        height = pointArray[1];
        return new Point(width, height);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            Table.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end > count - 1) {
            Table.error(6);
        }
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index == last) continue;
            this.items[index].dispose();
            last = index;
        }
    }

    void releaseWidget() {
        int i;
        super.releaseWidget();
        for (i = 0; i < this.getItemCount(); ++i) {
            TableItem item = this.items[i];
            if (item.isDisposed()) continue;
            item.remove();
        }
        this.items = new TableItem[0];
        for (i = 0; i < this.internal_getColumnCount(); ++i) {
            TableColumn column = this.columns[i];
            if (column.isDisposed()) continue;
            column.remove();
        }
        this.columns = new TableColumn[0];
        this.isList = false;
    }

    public void remove(int index) {
        this.checkWidget();
        this.checkItemIndex(index);
        this.items[index].dispose();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (0 > start || start > end || end >= count) {
            Table.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.removeAll();
        } else {
            for (int index = end; index >= start; --index) {
                TableItem item = this.items[index];
                com.ibm.ugl.eswt.expanded.OS.TableItem_Delete(this.internal_handle, index);
                if (item == null || item.isDisposed()) continue;
                item.remove();
            }
            System.arraycopy(this.items, end + 1, this.items, start, count - end - 1);
            for (int i = 1; i <= end - start + 1; ++i) {
                this.items[count - i] = null;
            }
        }
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.getItemCount();
        com.ibm.ugl.eswt.expanded.OS.Table_DeleteAllItems(this.internal_handle);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.items[i];
            if (item == null || item.isDisposed()) continue;
            item.remove();
        }
        this.items = new TableItem[4];
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Table.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        boolean singleSelect;
        this.checkWidget();
        if (indices == null) {
            Table.error(4);
        }
        int itemCount = this.getItemCount();
        int length = indices.length;
        boolean bl = singleSelect = (this.getStyle() & 4) != 0;
        if (length == 0 || singleSelect && length > 1) {
            return;
        }
        if (singleSelect) {
            this.deselectAll();
        }
        for (int i = length - 1; i >= 0; --i) {
            int index = indices[i];
            if (index < 0 || index >= itemCount) continue;
            TableItem item = this.getItem(index);
            item.setSelected(true);
        }
    }

    public void select(int index) {
        boolean singleSelect;
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            return;
        }
        boolean bl = singleSelect = (this.getStyle() & 4) != 0;
        if (singleSelect) {
            this.deselectAll();
        }
        TableItem item = this.getItem(index);
        item.setSelected(true);
        this.setFocus();
    }

    public void select(int start, int end) {
        boolean singleSelect;
        this.checkWidget();
        boolean bl = singleSelect = (this.getStyle() & 4) != 0;
        if (end < 0 || start > end || singleSelect && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if (start == 0 && end == count - 1) {
            this.selectAll();
        } else {
            if (singleSelect) {
                this.deselectAll();
            }
            for (int i = start; i <= end; ++i) {
                TableItem item = this.getItem(i);
                item.setSelected(true);
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Table_SetAllSelected(this.internal_handle, true);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        this.visible_or_not = show;
        com.ibm.ugl.eswt.expanded.OS.Table_SetColumnHeadersVisible(this.internal_handle, show);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Table_SetLinesVisible(this.internal_handle, show);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            Table.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        int focusIndex = indices[0];
        if (focusIndex == -1) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Table_SetFocusIndex(this.internal_handle, focusIndex);
        com.ibm.ugl.eswt.expanded.OS.Table_ShowItemIndex(this.internal_handle, focusIndex);
    }

    public void setSelection(TableItem[] selItems) {
        this.checkWidget();
        if (selItems == null) {
            Table.error(4);
        }
        this.deselectAll();
        int length = selItems.length;
        if (length == 0 || (this.getStyle() & 4) != 0 && length > 1) {
            return;
        }
        int focusIndex = -1;
        for (int i = length - 1; i >= 0; --i) {
            int index = this.indexOf(selItems[i]);
            if (index == -1) continue;
            focusIndex = index;
            this.select(focusIndex);
        }
        if (focusIndex == -1) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Table_SetFocusIndex(this.internal_handle, focusIndex);
        com.ibm.ugl.eswt.expanded.OS.Table_ShowItemIndex(this.internal_handle, focusIndex);
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            return;
        }
        this.deselectAll();
        this.select(index);
        if (index == -1) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Table_SetFocusIndex(this.internal_handle, index);
        com.ibm.ugl.eswt.expanded.OS.Table_ShowItemIndex(this.internal_handle, index);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.getStyle() & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.select(start, end);
        com.ibm.ugl.eswt.expanded.OS.Table_SetFocusIndex(this.internal_handle, start);
        com.ibm.ugl.eswt.expanded.OS.Table_ShowItemIndex(this.internal_handle, start);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        com.ibm.ugl.eswt.expanded.OS.Table_SetTopItemIndex(this.internal_handle, index);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            Table.error(4);
        }
        if (column.isDisposed()) {
            Table.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
        int count = this.getColumnCount();
        if (count <= 1) {
            return;
        }
        if (index < 0 || index >= count) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.Table_ShowColumnIndex(this.internal_handle, index);
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            Table.error(4);
        }
        if (item.isDisposed()) {
            Table.error(5);
        }
        int index = this.indexOf(item);
        com.ibm.ugl.eswt.expanded.OS.Table_ShowItemIndex(this.internal_handle, index);
    }

    public void showSelection() {
        int index = this.getSelectionIndex();
        if (index != -1) {
            this.showItem(this.getItem(index));
        }
    }

    void sort(int[] items) {
        int length = items.length;
        for (int gap = length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < length; ++i) {
                for (int j = i - gap; j >= 0; j -= gap) {
                    if (items[j] > items[j + gap]) continue;
                    int swap = items[j];
                    items[j] = items[j + gap];
                    items[j + gap] = swap;
                }
            }
        }
    }

    private void tableCallback(int itemIndex, int detail, int type) {
        Event event = new Event();
        event.item = itemIndex != -1 ? this.items[itemIndex] : null;
        switch (type) {
            case 1: {
                if (detail != 0) {
                    event.detail = 32;
                }
                this.postEvent(13, event);
                break;
            }
            case 2: {
                this.postEvent(14, event);
            }
        }
    }
}

