/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int internal_handle;
    protected int internal_style;
    EventTable eventTable;
    Object data;
    String[] keys;
    Object[] values;
    Display display;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.internal_style = style;
        this.display = parent.getDisplay();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Widget.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOrientation(Widget parent) {
        this.internal_style &= 0xF7FFFFFF;
        if ((this.internal_style & 0x6000000) == 0 && parent != null) {
            if ((parent.internal_style & 0x2000000) != 0) {
                this.internal_style |= 0x2000000;
            }
            if ((parent.internal_style & 0x4000000) != 0) {
                this.internal_style |= 0x4000000;
            }
        }
        this.internal_style = Widget.checkBits(this.internal_style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            Widget.error(4);
        }
        if (!parent.isValidThread()) {
            Widget.error(22);
        }
        if (parent.isDisposed()) {
            Widget.error(5);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Widget.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            Widget.error(24);
        }
        if (!this.isValidThread()) {
            Widget.error(22);
        }
        if (this.isDisposed()) {
            Widget.error(24);
        }
    }

    protected void internal_createHandle(int index) {
    }

    void createWidget(int index) {
        this.internal_createHandle(index);
        if (this.hasNativeEvents()) {
            OS.Widget_SetData(this.internal_handle, this);
        }
        this.register();
    }

    void deregister() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            Widget.error(22);
        }
        this.releaseChild();
        this.releaseWidget();
        this.releaseHandle();
    }

    static void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        Display display = this.getDisplay();
        return display.filters(eventType);
    }

    public Object getData() {
        this.checkWidget();
        return this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            Widget.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            Widget.error(24);
        }
        return display;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.internal_style;
    }

    boolean hasNativeEvents() {
        return true;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    protected boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (this.eventTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.widget = this;
        this.eventTable.sendEvent(event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
    }

    void releaseChild() {
    }

    void releaseHandle() {
        OS.Widget_Dispose(this.internal_handle);
        this.internal_handle = 0;
        this.display = null;
    }

    void releaseResources() {
        this.releaseWidget();
        this.releaseHandle();
    }

    void releaseWidget() {
        if (this.hasNativeEvents()) {
            OS.Widget_SetData(this.internal_handle, null);
        }
        this.internal_sendEvent(12);
        this.deregister();
        this.eventTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    private void scrollbarCallback(int index, int action) {
        Event event = new Event();
        switch (action) {
            case 0: {
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 5: {
                event.detail = 0x1000007;
                break;
            }
            case 6: {
                event.detail = 0x1000008;
                break;
            }
            case 4: {
                event.detail = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.sendEvent(13, event);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    protected void internal_sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        Display display = this.getDisplay();
        if (this.eventTable == null && !display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = display;
        event.widget = this;
        if (event.time == 0) {
            event.time = display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            display.postEvent(event);
        }
    }

    public void setData(Object data) {
        this.checkWidget();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            Widget.error(4);
        }
        if (value == null) {
            int index;
            if (this.keys == null) {
                return;
            }
            for (index = 0; index < this.keys.length && !this.keys[index].equals(key); ++index) {
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            this.values[i] = value;
            return;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    boolean setInputState(Event event, int type, int mask) {
        if ((mask & 1) != 0) {
            event.stateMask |= SWT.MOD3;
        }
        if ((mask & 2) != 0) {
            event.stateMask |= SWT.MOD2;
        }
        if ((mask & 4) != 0) {
            event.stateMask |= SWT.MOD1;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button != 3) break;
                event.stateMask &= 0xFFDFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button != 3) break;
                event.stateMask |= 0x200000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == SWT.MOD3) {
                    event.stateMask &= ~SWT.MOD3;
                }
                if (event.keyCode == SWT.MOD2) {
                    event.stateMask &= ~SWT.MOD2;
                }
                if (event.keyCode != SWT.MOD1) break;
                event.stateMask &= ~SWT.MOD1;
                break;
            }
            case 2: {
                if (event.keyCode == SWT.MOD3) {
                    event.stateMask |= SWT.MOD3;
                }
                if (event.keyCode == SWT.MOD2) {
                    event.stateMask |= SWT.MOD2;
                }
                if (event.keyCode != SWT.MOD1) break;
                event.stateMask |= SWT.MOD1;
            }
        }
        return true;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }
}

