/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.contexts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.common.HandleObjectManager;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextEvent;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextListener;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.internal.commands.util.Util;

public final class ContextManager
extends HandleObjectManager
implements IContextListener {
    public static boolean DEBUG = false;
    private Set activeContextIds = new HashSet();

    public final void addActiveContext(String string) {
        if (this.activeContextIds.contains(string)) {
            return;
        }
        HashSet hashSet = new HashSet(this.activeContextIds);
        this.activeContextIds.add(string);
        if (DEBUG) {
            Tracing.printTrace("CONTEXTS", this.activeContextIds.toString());
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, hashSet));
    }

    public final void addContextManagerListener(IContextManagerListener iContextManagerListener) {
        this.addListenerObject(iContextManagerListener);
    }

    public final void contextChanged(ContextEvent contextEvent) {
        if (contextEvent.isDefinedChanged()) {
            Context context = contextEvent.getContext();
            String string = context.getId();
            boolean bl = context.isDefined();
            if (bl) {
                this.definedHandleObjects.add(context);
            } else {
                this.definedHandleObjects.remove(context);
            }
            if (this.isListenerAttached()) {
                this.fireContextManagerChanged(new ContextManagerEvent(this, string, bl, false, null));
            }
        }
    }

    private final void fireContextManagerChanged(ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IContextManagerListener iContextManagerListener = (IContextManagerListener)objectArray[n];
            iContextManagerListener.contextManagerChanged(contextManagerEvent);
            ++n;
        }
    }

    public final Set getActiveContextIds() {
        return Collections.unmodifiableSet(this.activeContextIds);
    }

    public final Context getContext(String string) {
        this.checkId(string);
        Context context = (Context)this.handleObjectsById.get(string);
        if (context == null) {
            context = new Context(string);
            this.handleObjectsById.put(string, context);
            context.addContextListener(this);
        }
        return context;
    }

    public final Set getDefinedContextIds() {
        return this.getDefinedHandleObjectIds();
    }

    public final Context[] getDefinedContexts() {
        return this.definedHandleObjects.toArray(new Context[this.definedHandleObjects.size()]);
    }

    public final void removeActiveContext(String string) {
        if (!this.activeContextIds.contains(string)) {
            return;
        }
        HashSet hashSet = new HashSet(this.activeContextIds);
        this.activeContextIds.remove(string);
        if (DEBUG) {
            Tracing.printTrace("CONTEXTS", this.activeContextIds.toString());
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, hashSet));
    }

    public final void removeContextManagerListener(IContextManagerListener iContextManagerListener) {
        this.removeListenerObject(iContextManagerListener);
    }

    public final void setActiveContextIds(Set set) {
        if (Util.equals(this.activeContextIds, set)) {
            return;
        }
        Set set2 = this.activeContextIds;
        if (set != null) {
            this.activeContextIds = new HashSet();
            this.activeContextIds.addAll(set);
        } else {
            this.activeContextIds = null;
        }
        if (DEBUG) {
            Tracing.printTrace("CONTEXTS", set == null ? "none" : set.toString());
        }
        this.fireContextManagerChanged(new ContextManagerEvent(this, null, false, true, set2));
    }
}

