/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Map;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.service.resolver.PlatformAdmin;

public class EquinoxRegistryStrategy
extends RegistryStrategyOSGI {
    public static final String PLUGIN_NAME = "org.eclipse.equinox.registry";
    public static final String OPTION_DEBUG = "org.eclipse.equinox.registry/debug";
    public static final String OPTION_DEBUG_EVENTS = "org.eclipse.equinox.registry/debug/events";
    private static boolean DEBUG_ECLIPSE_REGISTRY = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug", false);
    private static boolean DEBUG_ECLIPSE_EVENTS = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug/events", false);

    public EquinoxRegistryStrategy(File[] fileArray, boolean[] blArray, Object object) {
        super(fileArray, blArray, object);
    }

    public boolean debug() {
        return DEBUG_ECLIPSE_REGISTRY;
    }

    public boolean debugRegistryEvents() {
        return DEBUG_ECLIPSE_EVENTS;
    }

    public final void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    public long getContainerTimestamp() {
        PlatformAdmin platformAdmin = OSGIUtils.getDefault().getPlatformAdmin();
        return platformAdmin == null ? -1L : platformAdmin.getState(false).getTimeStamp();
    }

    public final void scheduleChangeEvent(Object[] objectArray, Map map, Object object) {
        new ExtensionEventDispatcherJob(objectArray, map, object).schedule();
    }

    private static final class ExtensionEventDispatcherJob
    extends Job {
        private static final ISchedulingRule EXTENSION_EVENT_RULE = new ISchedulingRule(){

            public boolean contains(ISchedulingRule iSchedulingRule) {
                return iSchedulingRule == this;
            }

            public boolean isConflicting(ISchedulingRule iSchedulingRule) {
                return iSchedulingRule == this;
            }
        };
        private Map deltas;
        private Object[] listenerInfos;
        private Object registry;

        public ExtensionEventDispatcherJob(Object[] objectArray, Map map, Object object) {
            super("Registry event dispatcher");
            this.setSystem(true);
            this.listenerInfos = objectArray;
            this.deltas = map;
            this.registry = object;
            this.setRule(EXTENSION_EVENT_RULE);
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            return RegistryStrategy.processChangeEvent(this.listenerInfos, this.deltas, this.registry);
        }
    }
}

