/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.spi;

import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistrySupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.osgi.util.NLS;

public class RegistryStrategy {
    private SAXParserFactory theXMLParserFactory = null;
    private final File[] storageDirs;
    private final boolean[] cacheReadOnly;

    public RegistryStrategy(File[] fileArray, boolean[] blArray) {
        this.storageDirs = fileArray;
        this.cacheReadOnly = blArray;
    }

    public final int getLocationsLength() {
        if (this.storageDirs == null) {
            return 0;
        }
        return this.storageDirs.length;
    }

    public final File getStorage(int n) {
        if (this.storageDirs != null) {
            return this.storageDirs[n];
        }
        return null;
    }

    public final boolean isCacheReadOnly(int n) {
        if (this.cacheReadOnly != null) {
            return this.cacheReadOnly[n];
        }
        return true;
    }

    public void log(IStatus iStatus) {
        RegistrySupport.log(iStatus, null);
    }

    public String translate(String string, ResourceBundle resourceBundle) {
        return RegistrySupport.translate(string, resourceBundle);
    }

    public void onStart(IExtensionRegistry iExtensionRegistry) {
    }

    public void onStop(IExtensionRegistry iExtensionRegistry) {
    }

    public Object createExecutableExtension(RegistryContributor registryContributor, String string, String string2) throws CoreException {
        Object var4_4 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = NLS.bind((String)RegistryMessages.exExt_findClassError, (Object)registryContributor.getActualName(), (Object)string);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, string3, (Throwable)classNotFoundException));
        }
        try {
            var4_4 = clazz.newInstance();
        }
        catch (Exception exception) {
            String string4 = NLS.bind((String)RegistryMessages.exExt_instantiateClassError, (Object)registryContributor.getActualName(), (Object)string);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, string4, (Throwable)exception));
        }
        return var4_4;
    }

    public void scheduleChangeEvent(Object[] objectArray, Map map, Object object) {
        ((ExtensionRegistry)object).scheduleChangeEvent(objectArray, map);
    }

    public static final IStatus processChangeEvent(Object[] objectArray, Map map, Object object) {
        if (object instanceof ExtensionRegistry) {
            return ((ExtensionRegistry)object).processChangeEvent(objectArray, map);
        }
        return null;
    }

    public boolean debug() {
        return false;
    }

    public boolean debugRegistryEvents() {
        return false;
    }

    public boolean cacheUse() {
        return true;
    }

    public boolean cacheLazyLoading() {
        return true;
    }

    public long getContainerTimestamp() {
        return 0L;
    }

    public long getContributionsTimestamp() {
        return 0L;
    }

    public SAXParserFactory getXMLParser() {
        if (this.theXMLParserFactory == null) {
            this.theXMLParserFactory = SAXParserFactory.newInstance();
        }
        return this.theXMLParserFactory;
    }
}

