/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class Perspective {
    private PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected LayoutPart editorArea;
    private PartPlaceholder editorHolder;
    private ViewFactory viewFactory;
    private ArrayList visibleActionSets;
    private ArrayList alwaysOnActionSets;
    private ArrayList alwaysOffActionSets;
    private ArrayList newWizardShortcuts;
    private ArrayList showViewShortcuts;
    private ArrayList perspectiveShortcuts;
    private ArrayList fastViews;
    private Map mapIDtoViewLayoutRec;
    private boolean fixed;
    private ArrayList showInPartIds;
    private HashMap showInTimes = new HashMap();
    private IViewReference activeFastView;
    private IMemento memento;
    protected PerspectiveHelper presentation;
    private static final String VERSION_STRING = "0.016";
    private static final int FASTVIEW_HIDE_STEPS = 5;
    private IWorkbenchPartReference oldPartRef = null;
    private boolean shouldHideEditorsOnActivate = false;

    public Perspective(PerspectiveDescriptor perspectiveDescriptor, WorkbenchPage workbenchPage) throws WorkbenchException {
        this(workbenchPage);
        this.descriptor = perspectiveDescriptor;
        if (perspectiveDescriptor != null) {
            this.createPresentation(perspectiveDescriptor);
        }
    }

    protected Perspective(WorkbenchPage workbenchPage) throws WorkbenchException {
        this.page = workbenchPage;
        this.viewFactory = workbenchPage.getViewFactory();
        this.visibleActionSets = new ArrayList(2);
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.fastViews = new ArrayList(2);
        this.mapIDtoViewLayoutRec = new HashMap();
    }

    public void addFastView(IViewReference iViewReference) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        if (!this.isFastView(iViewReference)) {
            if (this.presentation.hasPlaceholder(iViewReference.getId(), iViewReference.getSecondaryId()) || viewPane.getContainer() != null) {
                this.presentation.removePart(viewPane);
            }
            this.fastViews.add(iViewReference);
            viewPane.setFast(true);
            Control control = viewPane.getControl();
            if (control != null) {
                control.setEnabled(false);
            }
        }
    }

    public boolean bringToTop(IViewReference iViewReference) {
        return this.presentation.bringPartToTop(this.getPane(iViewReference));
    }

    public boolean containsView(IViewPart iViewPart) {
        IViewSite iViewSite = iViewPart.getViewSite();
        IViewReference iViewReference = this.findView(iViewSite.getId(), iViewSite.getSecondaryId());
        if (iViewReference == null) {
            return false;
        }
        return iViewPart == iViewReference.getPart(false);
    }

    private void createInitialActionSets(List list) {
    }

    private void createPresentation(PerspectiveDescriptor perspectiveDescriptor) throws WorkbenchException {
        if (perspectiveDescriptor.hasCustomDefinition()) {
            this.loadCustomPersp(perspectiveDescriptor);
        } else {
            this.loadPredefinedPersp(perspectiveDescriptor);
        }
    }

    public void dispose() {
        if (this.presentation == null) {
            return;
        }
        this.presentation.deactivate();
        IViewReference[] iViewReferenceArray = this.getViewReferences();
        int n = 0;
        int n2 = iViewReferenceArray.length;
        while (n < n2) {
            this.getViewFactory().releaseView(iViewReferenceArray[n]);
            ++n;
        }
        this.mapIDtoViewLayoutRec.clear();
    }

    public IViewReference findView(String string) {
        return this.findView(string, null);
    }

    public IViewReference findView(String string, String string2) {
        IViewReference[] iViewReferenceArray = this.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewReference iViewReference = iViewReferenceArray[n];
            if (string.equals(iViewReference.getId()) && (string2 == null ? iViewReference.getSecondaryId() == null : string2.equals(iViewReference.getSecondaryId()))) {
                return iViewReference;
            }
            ++n;
        }
        return null;
    }

    private Composite getClientComposite() {
        return this.page.getClientComposite();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    Rectangle getFastViewBounds(IViewReference iViewReference) {
        Rectangle rectangle = this.page.getClientComposite().getBounds();
        float f = this.getFastViewWidthRatio(iViewReference);
        rectangle.width = (int)(f * (float)this.getClientComposite().getSize().x);
        return rectangle;
    }

    public IViewReference[] getFastViews() {
        IViewReference[] iViewReferenceArray = new IViewReference[this.fastViews.size()];
        this.fastViews.toArray(iViewReferenceArray);
        return iViewReferenceArray;
    }

    public String[] getNewWizardShortcuts() {
        return this.newWizardShortcuts.toArray(new String[this.newWizardShortcuts.size()]);
    }

    private ViewPane getPane(IViewReference iViewReference) {
        return (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
    }

    public String[] getPerspectiveShortcuts() {
        return this.perspectiveShortcuts.toArray(new String[this.perspectiveShortcuts.size()]);
    }

    public PerspectiveHelper getPresentation() {
        return this.presentation;
    }

    private float getFastViewWidthRatio(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, true);
        if (viewLayoutRec.fastViewWidthRatio == -1.0f) {
            IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
            IViewDescriptor iViewDescriptor = iViewRegistry.find(iViewReference.getId());
            viewLayoutRec.fastViewWidthRatio = iViewDescriptor != null ? iViewDescriptor.getFastViewWidthRatio() : 0.3f;
        }
        return viewLayoutRec.fastViewWidthRatio;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public long getShowInTime(String string) {
        Long l = (Long)this.showInTimes.get(string);
        return l == null ? 0L : l;
    }

    public String[] getShowViewShortcuts() {
        return this.showViewShortcuts.toArray(new String[this.showViewShortcuts.size()]);
    }

    private ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        if (this.presentation == null) {
            return new IViewReference[0];
        }
        ArrayList arrayList = new ArrayList(5);
        this.presentation.collectViewPanes(arrayList);
        IViewReference[] iViewReferenceArray = new IViewReference[arrayList.size() + this.fastViews.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.fastViews.size()) {
            iViewReferenceArray[n] = (IViewReference)this.fastViews.get(n2);
            ++n;
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            ViewPane viewPane = (ViewPane)arrayList.get(n2);
            iViewReferenceArray[n] = viewPane.getViewReference();
            ++n;
            ++n2;
        }
        return iViewReferenceArray;
    }

    public void hideActionSet(String string) {
    }

    protected void hideEditorArea() {
        if (!this.isEditorAreaVisible()) {
            return;
        }
    }

    public boolean hideView(IViewReference iViewReference) {
        ViewPane viewPane = this.getPane(iViewReference);
        if (this.isFastView(iViewReference)) {
            this.fastViews.remove(iViewReference);
            if (viewPane != null) {
                viewPane.setFast(false);
            }
            if (viewPane != null) {
                viewPane.getControl().setEnabled(true);
            }
        } else {
            this.presentation.removePart(viewPane);
        }
        this.getViewFactory().releaseView(iViewReference);
        return true;
    }

    protected boolean isEditorAreaVisible() {
        return this.editorHolder == null;
    }

    public boolean isFastView(IViewReference iViewReference) {
        return this.fastViews.contains(iViewReference);
    }

    private ViewLayoutRec getViewLayoutRec(IViewReference iViewReference, boolean bl) {
        return this.getViewLayoutRec(ViewFactory.getKey(iViewReference), bl);
    }

    private ViewLayoutRec getViewLayoutRec(String string, boolean bl) {
        ViewLayoutRec viewLayoutRec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(string);
        if (viewLayoutRec == null && bl) {
            viewLayoutRec = new ViewLayoutRec();
            this.mapIDtoViewLayoutRec.put(string, viewLayoutRec);
        }
        return viewLayoutRec;
    }

    public boolean isFixedLayout() {
        return this.fixed;
    }

    public boolean isStandaloneView(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        return viewLayoutRec != null && viewLayoutRec.isStandalone;
    }

    public boolean getShowTitleView(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        return viewLayoutRec != null && viewLayoutRec.showTitle;
    }

    private void loadCustomPersp(PerspectiveDescriptor perspectiveDescriptor) {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento iMemento = perspectiveRegistry.getCustomPersp(perspectiveDescriptor.getId());
            MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_unableToRestorePerspective, (Object)perspectiveDescriptor.getLabel()), null);
            multiStatus.merge(this.restoreState(iMemento));
            multiStatus.merge(this.restoreState());
            if (multiStatus.getSeverity() != 0) {
                this.unableToOpenPerspective(perspectiveDescriptor, (IStatus)multiStatus);
            }
        }
        catch (IOException iOException) {
            this.unableToOpenPerspective(perspectiveDescriptor, null);
        }
        catch (WorkbenchException workbenchException) {
            this.unableToOpenPerspective(perspectiveDescriptor, workbenchException.getStatus());
        }
    }

    private void unableToOpenPerspective(PerspectiveDescriptor perspectiveDescriptor, IStatus iStatus) {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        perspectiveRegistry.deletePerspective(perspectiveDescriptor);
        perspectiveDescriptor.deleteCustomDefinition();
        String string = WorkbenchMessages.Perspective_problemRestoringTitle;
        String string2 = WorkbenchMessages.Perspective_errorReadingState;
        if (iStatus == null) {
            ShowMessage.openError(null, string, string2);
        } else {
            ShowMessage.printError(string2, iStatus);
        }
    }

    private void loadPredefinedPersp(PerspectiveDescriptor perspectiveDescriptor) throws WorkbenchException {
        IPerspectiveFactory iPerspectiveFactory = null;
        try {
            iPerspectiveFactory = perspectiveDescriptor.createFactory();
        }
        catch (CoreException coreException) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)perspectiveDescriptor.getId()));
        }
        if (iPerspectiveFactory == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)perspectiveDescriptor.getId()));
        }
        ViewSashContainer viewSashContainer = new ViewSashContainer(this.page);
        PageLayout pageLayout = new PageLayout(viewSashContainer, this.getViewFactory(), this.editorArea, this.descriptor);
        pageLayout.setFixed(this.descriptor.getFixed());
        Workbench workbench = (Workbench)PlatformUI.getWorkbench();
        iPerspectiveFactory.createInitialLayout(pageLayout, workbench.getLaunchId(), workbench.getLinkPath());
        this.mapIDtoViewLayoutRec.putAll(pageLayout.getIDtoViewLayoutRecMap());
        this.createInitialActionSets(pageLayout.getActionSets());
        this.alwaysOnActionSets.addAll(this.visibleActionSets);
        this.showViewShortcuts = pageLayout.getShowViewShortcuts();
        this.perspectiveShortcuts = pageLayout.getPerspectiveShortcuts();
        this.showInPartIds = pageLayout.getShowInPartIds();
        this.fixed = pageLayout.isFixed();
        this.presentation = new PerspectiveHelper(this.page, viewSashContainer, this);
        if (!pageLayout.isEditorAreaVisible()) {
            this.hideEditorArea();
        }
    }

    protected void onActivate() {
        this.presentation.activate(this.getClientComposite());
    }

    protected void onDeactivate() {
        this.presentation.deactivate();
        this.setAllPinsVisible(false);
        int n = 0;
        while (n < this.fastViews.size()) {
            Control control;
            ViewPane viewPane = this.getPane((IViewReference)this.fastViews.get(n));
            if (viewPane != null && (control = viewPane.getControl()) != null) {
                control.setEnabled(true);
            }
            ++n;
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void performedShowIn(String string) {
        this.showInTimes.put(string, new Long(System.currentTimeMillis()));
    }

    public IStatus restoreState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        this.descriptor = new PerspectiveDescriptor(null, null, null);
        multiStatus.add(this.descriptor.restoreState(iMemento));
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.descriptor.getId());
        if (perspectiveDescriptor != null) {
            this.descriptor = perspectiveDescriptor;
        }
        this.memento = iMemento;
        IMemento[] iMementoArray = iMemento.getChildren("view");
        multiStatus.merge(this.createReferences(iMementoArray));
        iMemento = iMemento.getChild("fastViews");
        if (iMemento != null) {
            iMementoArray = iMemento.getChildren("view");
            multiStatus.merge(this.createReferences(iMementoArray));
        }
        return multiStatus;
    }

    private IStatus createReferences(IMemento[] iMementoArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringViews, null);
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento = iMementoArray[n];
            String string = iMemento.getString("id");
            String string2 = ViewFactory.extractSecondaryId(string);
            if (string2 != null) {
                string = ViewFactory.extractPrimaryId(string);
            }
            try {
                if (!"true".equals(iMemento.getString("removed"))) {
                    this.viewFactory.createView(string, string2);
                }
            }
            catch (PartInitException partInitException) {
                iMemento.putString("removed", "true");
                multiStatus.add(StatusUtil.newStatus(4, partInitException.getMessage() == null ? "" : partInitException.getMessage(), (Throwable)((Object)partInitException)));
            }
            ++n;
        }
        return multiStatus;
    }

    public IStatus restoreState() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        IMemento[] iMementoArray;
        ViewSashContainer viewSashContainer;
        if (this.memento == null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        IMemento iMemento = this.memento;
        this.memento = null;
        IMemento iMemento2 = iMemento.getChild("org.eclipse.jface.window");
        if (iMemento2 != null) {
            viewSashContainer = new Rectangle(0, 0, 0, 0);
            ((Rectangle)viewSashContainer).x = iMemento2.getInteger("x");
            ((Rectangle)viewSashContainer).y = iMemento2.getInteger("y");
            ((Rectangle)viewSashContainer).height = iMemento2.getInteger("height");
            ((Rectangle)viewSashContainer).width = iMemento2.getInteger("width");
            if (this.page.getWorkbenchWindow().getPages().length == 0) {
                this.page.getWorkbenchWindow().getShell().setBounds((Rectangle)viewSashContainer);
            }
        }
        viewSashContainer = new ViewSashContainer(this.page);
        PerspectiveHelper perspectiveHelper = new PerspectiveHelper(this.page, viewSashContainer, this);
        multiStatus.merge(perspectiveHelper.restoreState(iMemento.getChild("layout")));
        perspectiveHelper.replacePlaceholderWithPart(this.editorArea);
        IMemento[] iMementoArray2 = iMemento.getChildren("view");
        int n = 0;
        while (n < iMementoArray2.length) {
            iMementoArray = iMementoArray2[n];
            object7 = iMementoArray.getString("id");
            object6 = ViewFactory.extractSecondaryId((String)object7);
            if (object6 != null) {
                object7 = ViewFactory.extractPrimaryId((String)object7);
            }
            if ((object5 = (WorkbenchPartReference)(object4 = this.viewFactory.getView((String)object7, (String)object6))) == null) {
                object3 = ViewFactory.getKey((String)object7, (String)object6);
                multiStatus.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)object3), null));
            } else {
                this.page.addPart((IWorkbenchPartReference)object5);
                boolean bl = perspectiveHelper.willPartBeVisible(((WorkbenchPartReference)object5).getId(), (String)object6);
                if (bl) {
                    object2 = this.viewFactory.restoreView((IViewReference)object4);
                    multiStatus.add((IStatus)object2);
                    if (object2.getSeverity() == 0) {
                        object = (IViewPart)object5.getPart(true);
                        if (object != null) {
                            ViewSite viewSite = (ViewSite)object.getSite();
                            ViewPane viewPane = (ViewPane)viewSite.getPane();
                            perspectiveHelper.replacePlaceholderWithPart(viewPane);
                        }
                    } else {
                        this.page.removePart((IWorkbenchPartReference)object5);
                    }
                } else {
                    perspectiveHelper.replacePlaceholderWithPart(((WorkbenchPartReference)object5).getPane());
                }
            }
            ++n;
        }
        IMemento iMemento3 = iMemento.getChild("fastViews");
        if (iMemento3 != null) {
            iMementoArray2 = iMemento3.getChildren("view");
            int n2 = 0;
            while (n2 < iMementoArray2.length) {
                object7 = iMementoArray2[n2];
                object6 = object7.getString("id");
                object4 = ViewFactory.extractSecondaryId((String)object6);
                if (object4 != null) {
                    object6 = ViewFactory.extractPrimaryId((String)object6);
                }
                if ((object3 = (WorkbenchPartReference)(object5 = this.viewFactory.getView((String)object6, (String)object4))) == null) {
                    object2 = ViewFactory.getKey((String)object6, object4);
                    WorkbenchPlugin.log("Could not create view: '" + (String)object2 + "'.");
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)object2), null));
                } else {
                    object2 = object7.getFloat("ratio");
                    if (object2 == null) {
                        object = object7.getInteger("width");
                        object2 = object == null ? new Float(0.3f) : new Float((float)((Integer)object).intValue() / (float)this.getClientComposite().getSize().x);
                    }
                    object = this.getViewLayoutRec((IViewReference)object5, true);
                    ((ViewLayoutRec)object).fastViewWidthRatio = ((Float)object2).floatValue();
                    this.fastViews.add(object3);
                    this.page.addPart((IWorkbenchPartReference)object3);
                }
                ++n2;
            }
        }
        iMementoArray = iMemento.getChildren("viewLayoutRec");
        int n3 = 0;
        while (n3 < iMementoArray.length) {
            object6 = iMementoArray[n3];
            object4 = object6.getString("id");
            if (object4 != null) {
                object5 = this.getViewLayoutRec((String)object4, true);
                if ("false".equals(object6.getString("closeable"))) {
                    ((ViewLayoutRec)object5).isCloseable = false;
                }
                if ("false".equals(object6.getString("moveable"))) {
                    ((ViewLayoutRec)object5).isMoveable = false;
                }
                if ("true".equals(object6.getString("standalone"))) {
                    ((ViewLayoutRec)object5).isStandalone = true;
                    ((ViewLayoutRec)object5).showTitle = !"false".equals(object6.getString("showTitle"));
                }
            }
            ++n3;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        object6 = iMemento.getChildren("actionSet");
        object4 = new ArrayList<Object>(((IMemento[])object6).length);
        int n4 = 0;
        while (n4 < ((Object)object6).length) {
            object3 = object6[n4].getString("id");
            ((ArrayList)object4).add(object3);
            hashSet.add(object3);
            ++n4;
        }
        this.createInitialActionSets((List)object4);
        object6 = iMemento.getChildren("show_view_action");
        this.showViewShortcuts = new ArrayList(((Object)object6).length);
        n4 = 0;
        while (n4 < ((Object)object6).length) {
            object3 = object6[n4].getString("id");
            this.showViewShortcuts.add(object3);
            ++n4;
        }
        object6 = iMemento.getChildren("show_in_time");
        n4 = 0;
        while (n4 < ((Object)object6).length) {
            object3 = object6[n4].getString("id");
            object2 = object6[n4].getString("time");
            if (object3 != null && object2 != null) {
                try {
                    long l = Long.parseLong((String)object2);
                    this.showInTimes.put(object3, new Long(l));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n4;
        }
        this.showInPartIds = this.getShowInIdsFromRegistry();
        object6 = iMemento.getChildren("new_wizard_action");
        this.newWizardShortcuts = new ArrayList(((Object)object6).length);
        n4 = 0;
        while (n4 < ((Object)object6).length) {
            object3 = object6[n4].getString("id");
            this.newWizardShortcuts.add(object3);
            ++n4;
        }
        object6 = iMemento.getChildren("perspective_action");
        this.perspectiveShortcuts = new ArrayList(((Object)object6).length);
        n4 = 0;
        while (n4 < ((Object)object6).length) {
            object3 = object6[n4].getString("id");
            this.perspectiveShortcuts.add(object3);
            ++n4;
        }
        ArrayList arrayList = this.getPerspectiveExtensionActionSets();
        int n5 = 0;
        while (n5 < arrayList.size()) {
            object2 = (String)arrayList.get(n5);
            if (hashSet.contains(object2)) {
                // empty if block
            }
            ++n5;
        }
        this.presentation = perspectiveHelper;
        Integer n6 = iMemento.getInteger("editorAreaVisible");
        this.shouldHideEditorsOnActivate = n6 != null && n6 == 0;
        object2 = iMemento.getInteger("fixed");
        this.fixed = object2 != null && (Integer)object2 == 1;
        return multiStatus;
    }

    private ArrayList getPerspectiveExtensionActionSets() {
        PageLayout pageLayout = new PageLayout();
        return pageLayout.getActionSets();
    }

    private ArrayList getShowInIdsFromRegistry() {
        PageLayout pageLayout = new PageLayout();
        return pageLayout.getShowInPartIds();
    }

    public void saveDesc() {
        this.saveDescAs(this.descriptor);
    }

    public void saveDescAs(IPerspectiveDescriptor iPerspectiveDescriptor) {
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("perspective");
        IStatus iStatus = this.saveState(xMLMemento, perspectiveDescriptor, false);
        if (iStatus.getSeverity() == 4) {
            ShowMessage.printError(WorkbenchMessages.Perspective_problemSavingMessage, iStatus);
            return;
        }
        try {
            perspectiveRegistry.saveCustomPersp(perspectiveDescriptor, xMLMemento);
            this.descriptor = perspectiveDescriptor;
        }
        catch (IOException iOException) {
            perspectiveRegistry.deletePerspective(perspectiveDescriptor);
            ShowMessage.openError(null, WorkbenchMessages.Perspective_problemSavingTitle, WorkbenchMessages.Perspective_problemSavingMessage);
        }
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        multiStatus.merge(this.saveState(iMemento, this.descriptor, true));
        return multiStatus;
    }

    private IStatus saveState(IMemento iMemento, PerspectiveDescriptor perspectiveDescriptor, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList arrayList;
        Object object5;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        if (this.memento != null) {
            iMemento.putMemento(this.memento);
            return multiStatus;
        }
        iMemento.putString("version", VERSION_STRING);
        multiStatus.add(perspectiveDescriptor.saveState(iMemento));
        if (!bl) {
            object5 = this.page.getWorkbenchWindow().getShell().getBounds();
            arrayList = iMemento.createChild("org.eclipse.jface.window");
            arrayList.putInteger("x", ((Rectangle)object5).x);
            arrayList.putInteger("y", ((Rectangle)object5).y);
            arrayList.putInteger("height", ((Rectangle)object5).height);
            arrayList.putInteger("width", ((Rectangle)object5).width);
        }
        object5 = this.showViewShortcuts.iterator();
        while (object5.hasNext()) {
            arrayList = (String)object5.next();
            IMemento iMemento2 = iMemento.createChild("show_view_action");
            iMemento2.putString("id", (String)((Object)arrayList));
        }
        arrayList = new ArrayList(5);
        this.presentation.collectViewPanes(arrayList);
        object5 = arrayList.iterator();
        int n = 0;
        while (object5.hasNext()) {
            object4 = (ViewPane)object5.next();
            object3 = ((ViewPane)object4).getViewReference();
            object2 = iMemento.createChild("view");
            object2.putString("id", ViewFactory.getKey((IViewReference)object3));
        }
        if (this.fastViews.size() > 0) {
            object4 = iMemento.createChild("fastViews");
            object5 = this.fastViews.iterator();
            while (object5.hasNext()) {
                object3 = (IViewReference)object5.next();
                object2 = object4.createChild("view");
                object = ViewFactory.getKey((IViewReference)object3);
                object2.putString("id", (String)object);
                float f = this.getFastViewWidthRatio((IViewReference)object3);
                object2.putFloat("ratio", f);
            }
        }
        object4 = this.mapIDtoViewLayoutRec.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            object2 = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(object3);
            if (object2 == null || ((ViewLayoutRec)object2).isCloseable && ((ViewLayoutRec)object2).isMoveable && !((ViewLayoutRec)object2).isStandalone) continue;
            object = iMemento.createChild("viewLayoutRec");
            object.putString("id", (String)object3);
            if (!((ViewLayoutRec)object2).isCloseable) {
                object.putString("closeable", "false");
            }
            if (!((ViewLayoutRec)object2).isMoveable) {
                object.putString("moveable", "false");
            }
            if (!((ViewLayoutRec)object2).isStandalone) continue;
            object.putString("standalone", "true");
            object.putString("showTitle", ((ViewLayoutRec)object2).showTitle ? "true" : "false");
        }
        if (n > 0) {
            object4 = WorkbenchMessages.Perspective_multipleErrors;
            if (n == 1) {
                object4 = WorkbenchMessages.Perspective_oneError;
            }
            ShowMessage.openError(null, WorkbenchMessages.Error, (String)object4);
        }
        object4 = iMemento.createChild("layout");
        multiStatus.add(this.presentation.saveState((IMemento)object4));
        if (this.isEditorAreaVisible()) {
            iMemento.putInteger("editorAreaVisible", 1);
        } else {
            iMemento.putInteger("editorAreaVisible", 0);
        }
        if (this.fixed) {
            iMemento.putInteger("fixed", 1);
        } else {
            iMemento.putInteger("fixed", 0);
        }
        return multiStatus;
    }

    public IViewReference getActiveFastView() {
        return this.activeFastView;
    }

    private void setAllPinsVisible(boolean bl) {
        Iterator iterator = this.fastViews.iterator();
        while (iterator.hasNext()) {
            ViewPane viewPane = this.getPane((IViewReference)iterator.next());
            if (viewPane == null) continue;
            viewPane.setFast(bl);
        }
    }

    public void setNewWizardActionIds(ArrayList arrayList) {
        this.newWizardShortcuts = arrayList;
    }

    public void setPerspectiveActionIds(ArrayList arrayList) {
        this.perspectiveShortcuts = arrayList;
    }

    public void setShowInPartIds(ArrayList arrayList) {
        this.showInPartIds = arrayList;
    }

    public void setShowViewActionIds(ArrayList arrayList) {
        this.showViewShortcuts = arrayList;
    }

    public void showActionSet(String string) {
    }

    protected void showEditorArea() {
        if (this.isEditorAreaVisible()) {
            return;
        }
        this.presentation.getLayout().replace(this.editorHolder, this.editorArea);
        this.editorHolder = null;
    }

    public IViewPart showView(String string, String string2) throws PartInitException {
        Object object;
        ViewFactory viewFactory = this.getViewFactory();
        IViewReference iViewReference = viewFactory.createView(string, string2);
        IViewPart iViewPart = (IViewPart)iViewReference.getPart(false);
        if (iViewPart == null) {
            object = viewFactory.restoreView(iViewReference);
            if (object.getSeverity() == 4) {
                if (object.getException() instanceof PartInitException) {
                    throw (PartInitException)((Object)object.getException());
                }
                throw new PartInitException((IStatus)object);
            }
            iViewPart = (IViewPart)iViewReference.getPart(false);
        }
        object = (ViewSite)iViewPart.getSite();
        ViewPane viewPane = (ViewPane)((PartSite)object).getPane();
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt("OPEN_VIEW_MODE");
        if (this.presentation.hasPlaceholder(string, string2)) {
            this.presentation.addPart(viewPane);
        } else if (n == 0) {
            this.presentation.addPart(viewPane);
        } else if (n == 2 && this.presentation.canDetach()) {
            this.presentation.addDetachedPart(viewPane);
        }
        return iViewPart;
    }

    public IWorkbenchPartReference getOldPartRef() {
        return this.oldPartRef;
    }

    public void setOldPartRef(IWorkbenchPartReference iWorkbenchPartReference) {
        this.oldPartRef = iWorkbenchPartReference;
    }

    void moveFastView(IViewReference iViewReference, IViewReference iViewReference2) {
        if (iViewReference == iViewReference2) {
            return;
        }
        int n = this.fastViews.indexOf(iViewReference2);
        this.fastViews.remove(iViewReference);
        if (n < 0 || n >= this.fastViews.size()) {
            this.fastViews.add(iViewReference);
        } else {
            this.fastViews.add(n, iViewReference);
        }
    }

    public boolean isCloseable(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        if (viewLayoutRec != null) {
            return viewLayoutRec.isCloseable;
        }
        return true;
    }

    public boolean isMoveable(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        if (viewLayoutRec != null) {
            return viewLayoutRec.isMoveable;
        }
        return true;
    }

    public void describeLayout(StringBuffer stringBuffer) {
        IViewReference[] iViewReferenceArray = this.getFastViews();
        if (iViewReferenceArray.length != 0) {
            stringBuffer.append("fastviews (");
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IViewReference iViewReference = iViewReferenceArray[n];
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iViewReference.getPartName());
                ++n;
            }
            stringBuffer.append("), ");
        }
        this.getPresentation().describeLayout(stringBuffer);
    }

    public void testInvariants() {
        this.getPresentation().getLayout().testInvariants();
    }
}

