/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class ViewPart
extends WorkbenchPart
implements IViewPart {
    private IPropertyListener compatibilityTitleListener = new IPropertyListener(){

        public void propertyChanged(Object object, int n) {
            if (n == 1) {
                ViewPart.this.setDefaultContentDescription();
            }
        }
    };

    protected ViewPart() {
        this.addPropertyListener(this.compatibilityTitleListener);
    }

    public IViewSite getViewSite() {
        return (IViewSite)this.getSite();
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        this.setSite(iViewSite);
        this.setDefaultContentDescription();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
    }

    public void saveState(IMemento iMemento) {
    }

    protected void setPartName(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setPartName(string);
    }

    protected void setContentDescription(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setContentDescription(string);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        super.setInitializationData(iConfigurationElement, string, object);
        this.setDefaultContentDescription();
    }

    private void setDefaultContentDescription() {
        String string;
        if (this.compatibilityTitleListener == null) {
            return;
        }
        String string2 = this.getPartName();
        if (Util.equals(string2, string = this.getTitle())) {
            this.internalSetContentDescription("");
        } else {
            this.internalSetContentDescription(string);
        }
    }

    protected final void checkSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.checkSite(iWorkbenchPartSite);
        Assert.isTrue(iWorkbenchPartSite instanceof IViewSite, "The site for a view must be an IViewSite");
    }
}

