/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ArchiveReference;
import org.eclipse.update.core.Category;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.URLEntry;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.IResponse;

public abstract class BaseSiteFactory
extends SiteModelFactory
implements ISiteFactory {
    public abstract ISite createSite(URL var1) throws CoreException, InvalidSiteTypeException;

    protected ResourceBundle getResourceBundle(URL uRL) {
        ResourceBundle resourceBundle = null;
        try {
            uRL = UpdateManagerUtils.asDirectoryURL(uRL);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
            resourceBundle = ResourceBundle.getBundle("site", Locale.getDefault(), uRLClassLoader);
        }
        catch (MissingResourceException missingResourceException) {
            AppPlugin.warn(String.valueOf(missingResourceException.getLocalizedMessage()) + ":" + uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            AppPlugin.warn(NLS.bind((String)Messages.BaseSiteFactory_CannotRetriveParentDirectory, (Object[])new String[]{uRL.toExternalForm()}));
        }
        return resourceBundle;
    }

    public SiteModel createSiteMapModel() {
        return new Site();
    }

    public SiteFeatureReferenceModel createFeatureReferenceModel() {
        return new SiteFeatureReference();
    }

    public ArchiveReferenceModel createArchiveReferenceModel() {
        return new ArchiveReference();
    }

    public URLEntryModel createURLEntryModel() {
        return new URLEntry();
    }

    public CategoryModel createSiteCategoryModel() {
        return new Category();
    }

    protected InputStream openStream(URL uRL) throws IOException {
        IResponse iResponse = ConnectionFactory.get(uRL);
        return iResponse.getInputStream();
    }
}

