/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Utilities {
    private static Map entryMap;
    private static final DateFormat dateFormat;
    private static long tmpseed;
    private static String dirRoot;

    static {
        dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        tmpseed = new Date().getTime();
        dirRoot = null;
    }

    public static synchronized File createWorkingDirectory() throws IOException {
        String string;
        if (dirRoot == null) {
            dirRoot = System.getProperty("java.io.tmpdir");
            if (!dirRoot.endsWith(File.separator)) {
                dirRoot = String.valueOf(dirRoot) + File.separator;
            }
            if (!Platform.getOS().equals("win32")) {
                string = System.getProperty("user.home");
                string = Integer.toString(string.hashCode());
                dirRoot = String.valueOf(dirRoot) + string + File.separator;
            }
            dirRoot = String.valueOf(dirRoot) + "eclipse" + File.separator + ".update" + File.separator + Long.toString(tmpseed) + File.separator;
        }
        string = String.valueOf(dirRoot) + Long.toString(++tmpseed) + File.separator;
        File file = new File(string);
        Utilities.verifyPath(file, false);
        if (!file.exists()) {
            throw new FileNotFoundException(string);
        }
        return file;
    }

    public static synchronized File createLocalFile(File file, String string) throws IOException {
        File file2;
        if (string != null) {
            String string2 = string.replace('/', File.separatorChar);
            if (string2.startsWith(File.separator)) {
                string2 = string2.substring(1);
            }
            file2 = new File(file, string2);
        } else {
            file2 = File.createTempFile("eclipse", null, file);
        }
        file2.deleteOnExit();
        Utilities.verifyPath(file2, true);
        return file2;
    }

    public static synchronized void mapLocalFile(String string, File file) {
        if (string != null) {
            if (entryMap == null) {
                entryMap = new HashMap();
            }
            entryMap.put(string, file);
        }
    }

    public static synchronized File lookupLocalFile(String string) {
        if (entryMap == null) {
            return null;
        }
        return (File)entryMap.get(string);
    }

    public static synchronized void flushLocalFile() {
        entryMap = null;
    }

    public static synchronized void removeLocalFile(String string) {
        if (entryMap != null) {
            entryMap.remove(string);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, InstallMonitor installMonitor) throws IOException, InstallAbortedException {
        long l = UpdateManagerUtils.copy(inputStream, outputStream, installMonitor, 0L);
        if (l != -1L) {
            if (installMonitor.isCanceled()) {
                String string = Messages.Feature_InstallationCancelled;
                throw new InstallAbortedException(string, null);
            }
            throw new IOException();
        }
    }

    public static CoreException newCoreException(String string, int n, Throwable throwable) {
        MultiStatus multiStatus;
        String string2 = AppPlugin.getPlugin().getBundle().getSymbolicName();
        if (throwable instanceof FeatureDownloadException) {
            return (FeatureDownloadException)((Object)throwable);
        }
        if (throwable instanceof CoreException) {
            if (string == null) {
                string = "";
            }
            multiStatus = new MultiStatus(string2, n, string, throwable);
            IStatus iStatus = ((CoreException)throwable).getStatus();
            multiStatus.add(iStatus);
            multiStatus.addAll(iStatus);
        } else {
            StringBuffer stringBuffer = new StringBuffer("");
            if (string != null) {
                stringBuffer.append(string);
            }
            if (throwable != null) {
                stringBuffer.append(" [");
                String string3 = throwable.getLocalizedMessage();
                stringBuffer.append(string3 != null ? string3 : throwable.toString());
                stringBuffer.append("]");
            }
            multiStatus = new Status(4, string2, n, stringBuffer.toString(), throwable);
        }
        return new CoreException((IStatus)multiStatus);
    }

    public static CoreException newCoreException(String string, Throwable throwable) {
        return Utilities.newCoreException(string, 0, throwable);
    }

    public static CoreException newCoreException(String string, String string2, String string3, CoreException coreException, CoreException coreException2) {
        String string4 = AppPlugin.getPlugin().getBundle().getSymbolicName();
        if (string == null) {
            string = "";
        }
        IStatus iStatus = coreException.getStatus();
        IStatus iStatus2 = coreException2.getStatus();
        int n = iStatus.getCode() == iStatus2.getCode() ? iStatus.getCode() : 0;
        MultiStatus multiStatus = new MultiStatus(string4, n, string, null);
        multiStatus.add(iStatus);
        multiStatus.addAll(iStatus);
        multiStatus.add(iStatus2);
        multiStatus.addAll(iStatus2);
        return new CoreException((IStatus)multiStatus);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        return dateFormat.format(date);
    }

    public static void shutdown() {
        if (dirRoot == null) {
            return;
        }
        File file = new File(dirRoot);
        Utilities.cleanupTemp(file);
        file.delete();
    }

    private static void cleanupTemp(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                Utilities.cleanupTemp(fileArray[n]);
            }
            fileArray[n].delete();
            ++n;
        }
    }

    private static void verifyPath(File file, boolean bl) {
        if (bl && file.getAbsolutePath().endsWith(File.separator)) {
            file = file.getParentFile();
            bl = false;
        }
        if (file.exists()) {
            return;
        }
        File file2 = file.getParentFile();
        Utilities.verifyPath(file2, false);
        if (!bl) {
            file.mkdir();
        }
        file.deleteOnExit();
    }
}

