/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.xml.sax.SAXException;

public class SiteModelFactory {
    private static DefaultSiteParser parser = new DefaultSiteParser();

    public boolean canParseSiteType(String string) {
        return string == null || string.trim().equals("");
    }

    public SiteModel parseSite(InputStream inputStream) throws CoreException, InvalidSiteTypeException {
        SiteModel siteModel = null;
        try {
            parser.init(this);
            siteModel = parser.parse(inputStream);
            if (parser.getStatus() != null) {
                MultiStatus multiStatus = parser.getStatus();
                throw new CoreException((IStatus)multiStatus);
            }
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof InvalidSiteTypeException) {
                throw (InvalidSiteTypeException)sAXException.getException();
            }
            throw Utilities.newCoreException(Messages.SiteModelObject_ErrorParsingSiteStream, sAXException);
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(Messages.SiteModelObject_ErrorAccessingSiteStream, iOException);
        }
        return siteModel;
    }

    public SiteModel createSiteMapModel() {
        return new SiteModel();
    }

    public SiteFeatureReferenceModel createFeatureReferenceModel() {
        return new SiteFeatureReferenceModel();
    }

    public ArchiveReferenceModel createArchiveReferenceModel() {
        return new ArchiveReferenceModel();
    }

    public URLEntryModel createURLEntryModel() {
        return new URLEntryModel();
    }

    public CategoryModel createSiteCategoryModel() {
        return new CategoryModel();
    }
}

