/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IConfiguredSiteChangedListener;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.operations.UpdateUtils;

public class ConfiguredSite
extends ConfiguredSiteModel
implements IConfiguredSite {
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String EXTENSION_SITE_MARKER = ".eclipseextension";
    private ListenersList listeners = new ListenersList();
    private IStatus verifyStatus;
    private transient boolean justCreated = false;

    public ConfiguredSite() {
    }

    public ConfiguredSite(IConfiguredSite iConfiguredSite) {
        ConfiguredSite configuredSite = (ConfiguredSite)iConfiguredSite;
        this.setSiteModel(configuredSite.getSiteModel());
        this.setConfigurationPolicyModel(new ConfigurationPolicy(configuredSite.getConfigurationPolicy()));
        this.setUpdatable(configuredSite.isUpdatable());
        this.setEnabled(configuredSite.isEnabled());
        this.setPreviousPluginPath(configuredSite.getPreviousPluginPath());
        this.setPlatformURLString(configuredSite.getPlatformURLString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguredSiteChangedListener(IConfiguredSiteChangedListener iConfiguredSiteChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(iConfiguredSiteChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguredSiteChangedListener(IConfiguredSiteChangedListener iConfiguredSiteChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.remove(iConfiguredSiteChangedListener);
        }
    }

    public IFeatureReference install(IFeature iFeature, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        return this.install(iFeature, null, iVerificationListener, iProgressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeatureReference install(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        IFeatureReference iFeatureReference;
        block15: {
            if (this.justCreated) {
                this.justCreated = false;
            }
            if (!this.isUpdatable()) {
                String string = NLS.bind((String)Messages.ConfiguredSite_NonInstallableSite, (Object[])new String[]{this.getSite().getURL().toExternalForm()});
                IStatus iStatus = this.verifyUpdatableStatus();
                if (iStatus != null) {
                    string = String.valueOf(string) + " " + iStatus.getMessage();
                }
                throw Utilities.newCoreException(string, null);
            }
            if (iFeature == null) {
                String string = Messages.ConfiguredSite_NullFeatureToInstall;
                throw Utilities.newCoreException(string, null);
            }
            IFeature iFeature2 = null;
            ConfigurationActivity configurationActivity = new ConfigurationActivity(1);
            configurationActivity.setLabel(iFeature.getVersionedIdentifier().toString());
            configurationActivity.setDate(new Date());
            try {
                try {
                    iFeatureReference = this.getSite().install(iFeature, iFeatureReferenceArray, iVerificationListener, iProgressMonitor);
                    if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_INSTALL) {
                        AppPlugin.debug("Sucessfully installed: " + iFeatureReference.getURL().toExternalForm());
                    }
                    if (iFeatureReference != null) {
                        try {
                            iFeature2 = iFeatureReference.getFeature(null);
                        }
                        catch (CoreException coreException) {
                            AppPlugin.warn(null, coreException);
                        }
                    }
                    configurationActivity.setStatus(0);
                    Object[] objectArray = this.listeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (iFeature2 != null) {
                            IConfiguredSiteChangedListener iConfiguredSiteChangedListener = (IConfiguredSiteChangedListener)objectArray[n];
                            iConfiguredSiteChangedListener.featureInstalled(iFeature2);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    configurationActivity.setStatus(1);
                    throw coreException;
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
                ((InstallConfiguration)iInstallConfiguration).addActivity(configurationActivity);
                throw throwable;
            }
            {
                Object var11_18 = null;
                IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
                ((InstallConfiguration)iInstallConfiguration).addActivity(configurationActivity);
                if (iFeature2 == null) break block15;
            }
            this.configure(iFeature2, iFeatureReferenceArray, true);
        }
        return iFeatureReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(IFeature iFeature, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.isUpdatable()) {
            String string = NLS.bind((String)Messages.ConfiguredSite_NonUninstallableSite, (Object[])new String[]{this.getSite().getURL().toExternalForm()});
            throw Utilities.newCoreException(string, null);
        }
        ConfigurationActivity configurationActivity = new ConfigurationActivity(2);
        configurationActivity.setLabel(iFeature.getVersionedIdentifier().toString());
        configurationActivity.setDate(new Date());
        try {
            try {
                IFeatureReference iFeatureReference = null;
                ISiteFeatureReference[] iSiteFeatureReferenceArray = this.getSite().getFeatureReferences();
                ISiteFeatureReference iSiteFeatureReference = this.getSite().getFeatureReference(iFeature);
                int n = 0;
                while (n < iSiteFeatureReferenceArray.length) {
                    if (iSiteFeatureReferenceArray[n].equals(iSiteFeatureReference)) {
                        iFeatureReference = iSiteFeatureReferenceArray[n];
                        break;
                    }
                    ++n;
                }
                if (iFeatureReference == null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.ConfiguredSite_UnableToFindFeature, (Object[])new String[]{iFeature.getURL().toString()}), null);
                }
                if (this.getConfigurationPolicy().isConfigured(iFeatureReference)) {
                    IFeature iFeature2 = iFeatureReference.getFeature(null);
                    String string = iFeature2 == null ? null : iFeature2.getLabel();
                    throw Utilities.newCoreException(NLS.bind((String)Messages.ConfiguredSite_UnableToRemoveConfiguredFeature, (Object[])new String[]{string}), null);
                }
                this.getSite().remove(iFeature, iProgressMonitor);
                this.getConfigurationPolicy().removeFeatureReference(iFeatureReference);
                configurationActivity.setStatus(0);
                Object[] objectArray = this.listeners.getListeners();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ((IConfiguredSiteChangedListener)objectArray[n2]).featureRemoved(iFeature);
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                configurationActivity.setStatus(1);
                throw coreException;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
            ((InstallConfiguration)iInstallConfiguration).addActivity(configurationActivity);
            throw throwable;
        }
        {
            Object var9_16 = null;
            IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
            ((InstallConfiguration)iInstallConfiguration).addActivity(configurationActivity);
            return;
        }
    }

    public void configure(IFeature iFeature) throws CoreException {
        this.configure(iFeature, null, true);
    }

    private void configure(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, boolean bl) throws CoreException {
        Object[] objectArray;
        if (iFeature == null) {
            AppPlugin.warn("Attempting to configure a null feature in site:" + this.getSite().getURL().toExternalForm());
            return;
        }
        ConfigurationPolicy configurationPolicy = this.getConfigurationPolicy();
        if (configurationPolicy == null) {
            return;
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        if (iFeatureReferenceArray != null) {
            iIncludedFeatureReferenceArray = this.childrenToConfigure(iIncludedFeatureReferenceArray, iFeatureReferenceArray);
        }
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            block7: {
                try {
                    objectArray = iIncludedFeatureReferenceArray[n].getFeature(null);
                    this.configure((IFeature)objectArray, iFeatureReferenceArray, bl);
                }
                catch (CoreException coreException) {
                    if (iIncludedFeatureReferenceArray[n].isOptional()) break block7;
                    AppPlugin.warn("Unable to configure child feature: " + iIncludedFeatureReferenceArray[n] + " " + (Object)((Object)coreException));
                }
            }
            ++n;
        }
        ISiteFeatureReference iSiteFeatureReference = this.getSite().getFeatureReference(iFeature);
        configurationPolicy.configure(iSiteFeatureReference, bl, true);
        objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IConfiguredSiteChangedListener)objectArray[n2]).featureConfigured(iFeature);
            ++n2;
        }
    }

    private IIncludedFeatureReference[] childrenToConfigure(IIncludedFeatureReference[] iIncludedFeatureReferenceArray, IFeatureReference[] iFeatureReferenceArray) {
        ArrayList<IIncludedFeatureReference> arrayList = new ArrayList<IIncludedFeatureReference>();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
            if (!iIncludedFeatureReference.isOptional()) {
                arrayList.add(iIncludedFeatureReference);
            } else {
                int n2 = 0;
                while (n2 < iFeatureReferenceArray.length) {
                    try {
                        IFeature iFeature = iFeatureReferenceArray[n2].getFeature(null);
                        if (iFeature.equals(iIncludedFeatureReference.getFeature(null))) {
                            arrayList.add(iIncludedFeatureReference);
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        AppPlugin.warn("", coreException);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray2 = new IIncludedFeatureReference[arrayList.size()];
        if (arrayList.size() > 0) {
            arrayList.toArray(iIncludedFeatureReferenceArray2);
        }
        return iIncludedFeatureReferenceArray2;
    }

    public boolean unconfigure(IFeature iFeature) throws CoreException {
        return this.unconfigure(iFeature, true, false);
    }

    private boolean unconfigure(IFeature iFeature, boolean bl, boolean bl2) throws CoreException {
        ISiteFeatureReference iSiteFeatureReference = this.getSite().getFeatureReference(iFeature);
        if (iSiteFeatureReference == null) {
            AppPlugin.warn("Unable to retrieve Feature Reference for feature" + iFeature);
            return false;
        }
        ConfigurationPolicy configurationPolicy = this.getConfigurationPolicy();
        if (configurationPolicy == null) {
            return false;
        }
        if (bl2 && !this.validateNoConfiguredParents(iFeature)) {
            AppPlugin.warn("The feature " + iFeature.getVersionedIdentifier() + " to disable is needed by another enable feature");
            return false;
        }
        boolean bl3 = false;
        try {
            bl3 = configurationPolicy.unconfigure(iSiteFeatureReference, true, true);
        }
        catch (CoreException coreException) {
            URL uRL = iSiteFeatureReference.getURL();
            String string = uRL != null ? uRL.toExternalForm() : "<no feature reference url>";
            AppPlugin.warn("Unable to unconfigure" + string, coreException);
            throw coreException;
        }
        if (bl3) {
            if (bl) {
                this.unconfigurePatches(iFeature);
            }
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
            int n = 0;
            while (n < iIncludedFeatureReferenceArray.length) {
                try {
                    IFeature iFeature2 = iIncludedFeatureReferenceArray[n].getFeature(null);
                    this.unconfigure(iFeature2, bl, true);
                }
                catch (CoreException coreException) {
                    AppPlugin.warn("Unable to unconfigure child feature: " + iIncludedFeatureReferenceArray[n] + " " + (Object)((Object)coreException));
                }
                ++n;
            }
            Object[] objectArray = this.listeners.getListeners();
            int n2 = 0;
            while (n2 < objectArray.length) {
                IConfiguredSiteChangedListener iConfiguredSiteChangedListener = (IConfiguredSiteChangedListener)objectArray[n2];
                iConfiguredSiteChangedListener.featureUnconfigured(iFeature);
                ++n2;
            }
            return true;
        }
        URL uRL = iSiteFeatureReference.getURL();
        String string = uRL != null ? uRL.toExternalForm() : "<no feature reference url>";
        AppPlugin.warn("Unable to unconfigure:" + string);
        return false;
    }

    private void unconfigurePatches(IFeature iFeature) {
        IFeatureReference[] iFeatureReferenceArray = this.getConfiguredFeatures();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            IFeatureReference iFeatureReference = iFeatureReferenceArray[n];
            try {
                IFeature iFeature2 = iFeatureReference.getFeature(null);
                if (!iFeature2.equals(iFeature) && UpdateUtils.isPatch(iFeature, iFeature2)) {
                    this.unconfigure(iFeature2, false, false);
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn("", coreException);
            }
            ++n;
        }
    }

    public IFeatureReference[] getConfiguredFeatures() {
        if (this.isEnabled()) {
            return this.getRawConfiguredFeatures();
        }
        return new ISiteFeatureReference[0];
    }

    private IFeatureReference[] getRawConfiguredFeatures() {
        ConfigurationPolicy configurationPolicy = this.getConfigurationPolicy();
        if (configurationPolicy == null) {
            return new ISiteFeatureReference[0];
        }
        return configurationPolicy.getConfiguredFeatures();
    }

    public IFeatureReference[] getFeatureReferences() {
        ConfigurationPolicy configurationPolicy = this.getConfigurationPolicy();
        if (configurationPolicy == null) {
            return new ISiteFeatureReference[0];
        }
        IFeatureReference[] iFeatureReferenceArray = this.getConfiguredFeatures();
        int n = iFeatureReferenceArray.length;
        IFeatureReference[] iFeatureReferenceArray2 = configurationPolicy.getUnconfiguredFeatures();
        int n2 = iFeatureReferenceArray2.length;
        IFeatureReference[] iFeatureReferenceArray3 = new IFeatureReference[n + n2];
        if (n > 0) {
            System.arraycopy(iFeatureReferenceArray, 0, iFeatureReferenceArray3, 0, n);
        }
        if (n2 > 0) {
            System.arraycopy(iFeatureReferenceArray2, 0, iFeatureReferenceArray3, n, n2);
        }
        return iFeatureReferenceArray3;
    }

    public void revertTo(IConfiguredSite iConfiguredSite, IProgressMonitor iProgressMonitor, IProblemHandler iProblemHandler) throws CoreException, InterruptedException {
        ConfiguredSite configuredSite = (ConfiguredSite)iConfiguredSite;
        IFeatureReference[] iFeatureReferenceArray = configuredSite.validConfiguredFeatures(iProblemHandler);
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            this.getConfigurationPolicy().configure(iFeatureReferenceArray[n], true, true);
            ++n;
        }
        List list = configuredSite.calculateUnconfiguredFeatures(iFeatureReferenceArray);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFeatureReference iFeatureReference = (IFeatureReference)iterator.next();
            try {
                this.getConfigurationPolicy().unconfigure(iFeatureReference, true, true);
            }
            catch (CoreException coreException) {
                String string = iFeatureReference.getURL().toString();
                ISite iSite = iFeatureReference.getSite();
                String string2 = iSite != null ? iSite.getURL().toExternalForm() : Messages.ConfiguredSite_NoSite;
                AppPlugin.warn(NLS.bind((String)Messages.ConfiguredSite_CannotFindFeatureToUnconfigure, (Object[])new String[]{string, string2}), coreException);
            }
        }
    }

    private IFeatureReference[] validConfiguredFeatures(IProblemHandler iProblemHandler) throws InterruptedException {
        IFeatureReference[] iFeatureReferenceArray = this.getConfiguredFeatures();
        if (iFeatureReferenceArray != null) {
            int n = 0;
            while (n < iFeatureReferenceArray.length) {
                Object object;
                IFeature iFeature;
                block12: {
                    iFeature = null;
                    try {
                        iFeature = iFeatureReferenceArray[n].getFeature(null);
                    }
                    catch (CoreException coreException) {
                        AppPlugin.warn(null, coreException);
                        object = iFeatureReferenceArray[n].getURL().toExternalForm();
                        if (iProblemHandler.reportProblem(NLS.bind((String)Messages.ConfiguredSite_CannotFindFeatureToConfigure, (Object[])new String[]{object}))) break block12;
                        throw new InterruptedException();
                    }
                }
                if (iFeature != null) {
                    ArrayList<VersionedIdentifier> arrayList = new ArrayList<VersionedIdentifier>();
                    object = iFeature.getSite();
                    IPluginEntry[] iPluginEntryArray = null;
                    if (object != null) {
                        iPluginEntryArray = object.getPluginEntries();
                        int n2 = 0;
                        while (n2 < iPluginEntryArray.length) {
                            IPluginEntry iPluginEntry = iPluginEntryArray[n2];
                            arrayList.add(iPluginEntry.getVersionedIdentifier());
                            ++n2;
                        }
                    }
                    if (iPluginEntryArray.length > 0) {
                        IPluginEntry[] iPluginEntryArray2 = iFeature.getPluginEntries();
                        int n3 = 0;
                        while (n3 < iPluginEntryArray2.length) {
                            IPluginEntry iPluginEntry = iPluginEntryArray2[n3];
                            if (!this.contains(iPluginEntry.getVersionedIdentifier(), arrayList)) {
                                String string = "Error verifying existence of plugin:" + iPluginEntry.getVersionedIdentifier().toString();
                                AppPlugin.log(string, new Exception());
                                String string2 = object != null ? object.getURL().toExternalForm() : Messages.ConfiguredSite_NoSite;
                                String string3 = NLS.bind((String)Messages.ConfiguredSite_CannotFindPluginEntry, (Object[])new String[]{iPluginEntry.getVersionedIdentifier().toString(), string2});
                                if (iProblemHandler == null) {
                                    throw new InterruptedException(string3);
                                }
                                if (!iProblemHandler.reportProblem(string3)) {
                                    throw new InterruptedException();
                                }
                            }
                            ++n3;
                        }
                    }
                }
                ++n;
            }
        }
        return iFeatureReferenceArray;
    }

    private List calculateUnconfiguredFeatures(IFeatureReference[] iFeatureReferenceArray) throws CoreException {
        HashSet<IFeatureReference> hashSet = new HashSet<IFeatureReference>();
        IInstallConfiguration[] iInstallConfigurationArray = SiteManager.getLocalSite().getConfigurationHistory();
        int n = 0;
        while (n < iInstallConfigurationArray.length) {
            IInstallConfiguration iInstallConfiguration = iInstallConfigurationArray[n];
            IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
            int n2 = 0;
            while (n2 < iConfiguredSiteArray.length) {
                ConfiguredSite configuredSite = (ConfiguredSite)iConfiguredSiteArray[n2];
                if (configuredSite.getSite().equals(this.getSite())) {
                    hashSet.addAll(Arrays.asList(configuredSite.getConfigurationPolicy().getUnconfiguredFeatures()));
                    hashSet.addAll(Arrays.asList(configuredSite.getConfigurationPolicy().getConfiguredFeatures()));
                }
                ++n2;
            }
            ++n;
        }
        List list = this.remove(iFeatureReferenceArray, hashSet);
        return list;
    }

    private List remove(IFeatureReference[] iFeatureReferenceArray, Set set) {
        ArrayList<IFeatureReference> arrayList = new ArrayList<IFeatureReference>();
        if (set == null) {
            return arrayList;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IFeatureReference iFeatureReference = (IFeatureReference)iterator.next();
            boolean bl = false;
            int n = 0;
            while (n < iFeatureReferenceArray.length) {
                if (iFeatureReference.equals(iFeatureReferenceArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (bl) continue;
            arrayList.add(iFeatureReference);
        }
        return arrayList;
    }

    private boolean contains(VersionedIdentifier versionedIdentifier, List list) {
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                VersionedIdentifier versionedIdentifier2 = (VersionedIdentifier)iterator.next();
                if (!versionedIdentifier2.equals(versionedIdentifier)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public ConfigurationPolicy getConfigurationPolicy() {
        return (ConfigurationPolicy)this.getConfigurationPolicyModel();
    }

    public ISite getSite() {
        return (ISite)((Object)this.getSiteModel());
    }

    public IInstallConfiguration getInstallConfiguration() {
        return (IInstallConfiguration)((Object)this.getInstallConfigurationModel());
    }

    public IStatus getBrokenStatus(IFeature iFeature) {
        IStatus iStatus = this.createStatus(0, 0, "", null);
        IPluginEntry[] iPluginEntryArray = this.getSite().getPluginEntries();
        IPluginEntry[] iPluginEntryArray2 = iFeature.getPluginEntries();
        IPluginEntry[] iPluginEntryArray3 = UpdateManagerUtils.diff(iPluginEntryArray2, iPluginEntryArray);
        if (iPluginEntryArray3 != null && iPluginEntryArray3.length != 0) {
            String string = Messages.SiteLocal_FeatureUnHappy;
            MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), 2, string, null);
            int n = 0;
            while (n < iPluginEntryArray3.length) {
                VersionedIdentifier versionedIdentifier = iPluginEntryArray3[n].getVersionedIdentifier();
                Object[] objectArray = new String[]{"", ""};
                if (versionedIdentifier != null) {
                    objectArray = new Object[]{versionedIdentifier.getIdentifier(), versionedIdentifier.getVersion()};
                }
                String string2 = NLS.bind((String)Messages.ConfiguredSite_MissingPluginsBrokenFeature, (Object[])objectArray);
                AppPlugin.warn(string2);
                IStatus iStatus2 = this.createStatus(4, 2, string2, null);
                multiStatus.add(iStatus2);
                ++n;
            }
            return multiStatus;
        }
        String string = Messages.SiteLocal_FeatureHappy;
        return this.createStatus(0, 0, string, null);
    }

    public boolean isConfigured(IFeature iFeature) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.getConfigurationPolicy() == null) {
            return false;
        }
        ISiteFeatureReference iSiteFeatureReference = this.getSite().getFeatureReference(iFeature);
        if (iSiteFeatureReference == null) {
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_WARNINGS) {
                AppPlugin.warn("Unable to retrieve featureReference for feature:" + iFeature);
            }
            return false;
        }
        return this.getConfigurationPolicy().isConfigured(iSiteFeatureReference);
    }

    public String toString() {
        if (this.getSite() == null) {
            return "No Site";
        }
        if (this.getSite().getURL() == null) {
            return "No URL";
        }
        return this.getSite().getURL().toExternalForm();
    }

    public IStatus verifyUpdatableStatus() {
        if (this.verifyStatus != null) {
            return this.verifyStatus;
        }
        URL uRL = this.getSite().getURL();
        if (uRL == null) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_SiteURLNull, null);
            return this.verifyStatus;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_NonLocalSite, null);
            return this.verifyStatus;
        }
        String string = uRL.getFile();
        File file = new File(string);
        String string2 = ConfiguredSite.getProductName(file);
        if (string2 != null) {
            if (!string2.equals(ConfiguredSite.getProductIdentifier("id", ConfiguredSite.getProductFile()))) {
                this.verifyStatus = this.createStatus(4, NLS.bind((String)Messages.ConfiguredSite_NotSameProductId, (Object[])new String[]{string2}), null);
                return this.verifyStatus;
            }
        } else {
            File file2 = ConfiguredSite.getSiteContaining(file);
            if (file2 != null) {
                this.verifyStatus = this.createStatus(4, NLS.bind((String)Messages.ConfiguredSite_ContainedInAnotherSite, (Object[])new String[]{file2.getAbsolutePath()}), null);
                return this.verifyStatus;
            }
        }
        if (!ConfiguredSite.canWrite(file)) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_ReadOnlySite, null);
            return this.verifyStatus;
        }
        this.verifyStatus = this.createStatus(0, "", null);
        this.setUpdatable(true);
        return this.verifyStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canWrite(File file) {
        if (!file.isDirectory() && file.getParentFile() != null) {
            file = file.getParentFile();
        }
        File file2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                file2 = new File(file, "toDelete");
                fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(0);
            }
            catch (IOException iOException) {
                Object var3_3 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                if (file2 == null) return false;
                file2.delete();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException iOException) {}
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (file2 == null) throw throwable;
            file2.delete();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        if (file2 == null) return true;
        file2.delete();
        return true;
    }

    private static File getSiteContaining(File file) {
        if (file == null) {
            return null;
        }
        AppPlugin.warn("IsContained: Checking for markers at:" + file);
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, PRODUCT_SITE_MARKER);
            File file3 = new File(file, EXTENSION_SITE_MARKER);
            if (file2.exists() || file3.exists()) {
                return file;
            }
        }
        return ConfiguredSite.getSiteContaining(file.getParentFile());
    }

    private static String getProductName(File file) {
        if (file == null) {
            return null;
        }
        File file2 = new File(file, EXTENSION_SITE_MARKER);
        if (!file2.exists()) {
            return null;
        }
        File file3 = ConfiguredSite.getProductFile();
        String string = null;
        String string2 = null;
        if (file3 != null) {
            string = ConfiguredSite.getProductIdentifier("id", file3);
            string2 = ConfiguredSite.getProductIdentifier("id", file2);
            if (string == null) {
                AppPlugin.warn("Product ID is null at:" + file3);
                return null;
            }
            if (!string.equalsIgnoreCase(string2)) {
                String string3;
                AppPlugin.warn("Product id at" + file3 + " Different than:" + file2);
                String string4 = ConfiguredSite.getProductIdentifier("name", file2);
                String string5 = ConfiguredSite.getProductIdentifier("version", file2);
                String string6 = string3 = string4 == null ? string5 : String.valueOf(string4) + ":" + string5;
                if (string3 == null) {
                    string3 = "";
                }
                return string3;
            }
            return string2;
        }
        AppPlugin.warn("Product Marker doesn't exist:" + file3);
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String getProductIdentifier(String var0, File var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 145->148)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File getProductFile() {
        String string = ConfiguratorUtils.getInstallURL().getFile();
        if (string != null) {
            File file = new File(string, PRODUCT_SITE_MARKER);
            if (file.exists()) {
                return file;
            }
            AppPlugin.warn("Product marker doesn't exist:" + file);
        } else {
            AppPlugin.warn("Cannot retrieve install URL from BootLoader");
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean createPrivateSiteMarker() {
        URL uRL = this.getSite().getURL();
        if (uRL == null) {
            AppPlugin.warn("Unable to create marker. The Site url is null.");
            return false;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            AppPlugin.warn("Unable to create private marker. The Site is not on the local file system.");
            return false;
        }
        String string = uRL.getFile();
        File file = ConfiguredSite.getProductFile();
        boolean bl = false;
        if (file == null) return bl;
        String string2 = ConfiguredSite.getProductIdentifier("id", file);
        String string3 = ConfiguredSite.getProductIdentifier("name", file);
        String string4 = ConfiguredSite.getProductIdentifier("version", file);
        if (string2 == null) return bl;
        File file2 = new File(string, EXTENSION_SITE_MARKER);
        if (file2.exists()) return bl;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                outputStreamWriter.write("id=" + string2 + "\n");
                if (string3 != null) {
                    outputStreamWriter.write("name=" + string3 + "\n");
                }
                if (string4 != null) {
                    outputStreamWriter.write("version=" + string4 + "\n");
                }
                bl = true;
                this.justCreated = true;
            }
            catch (Exception exception) {
                AppPlugin.warn("Unable to create private Marker at:" + file2, exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
        try {}
        catch (IOException iOException) {
            return bl;
        }
        if (fileOutputStream == null) return bl;
        ((OutputStream)fileOutputStream).close();
        return bl;
    }

    public boolean isExtensionSite() {
        return this.containsMarker(EXTENSION_SITE_MARKER);
    }

    public boolean isProductSite() {
        return this.containsMarker(PRODUCT_SITE_MARKER);
    }

    public boolean isPrivateSite() {
        return this.isExtensionSite();
    }

    private boolean containsMarker(String string) {
        ISite iSite = this.getSite();
        if (iSite == null) {
            AppPlugin.warn("Contains Markers:The site is null");
            return false;
        }
        URL uRL = iSite.getURL();
        if (uRL == null) {
            AppPlugin.warn("Contains Markers:Site URL is null");
            return false;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            AppPlugin.warn("Contains Markers:Non file protocol");
            return false;
        }
        File file = new File(uRL.getFile());
        if (!file.exists()) {
            AppPlugin.warn("Contains Markers:The site doesn't exist:" + file);
            return false;
        }
        File file2 = new File(file, string);
        if (!file2.exists()) {
            AppPlugin.warn("Contains Markers:The extensionfile does not exist:" + file2);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNativelyLinked() throws CoreException {
        String string = this.getPlatformURLString();
        if (string == null) {
            AppPlugin.warn("Unable to retrieve platformString");
            return false;
        }
        URL uRL = null;
        try {
            URL uRL2 = new URL(string);
            IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            IPlatformConfiguration.ISiteEntry iSiteEntry = iPlatformConfiguration.findConfiguredSite(uRL2);
            if (iSiteEntry != null) {
                return iSiteEntry.isNativelyLinked();
            }
            AppPlugin.warn("Unable to retrieve site:" + string + " from platform.");
            IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = iPlatformConfiguration.getConfiguredSites();
            int n = 0;
            while (true) {
                if (n >= iSiteEntryArray.length) {
                    return false;
                }
                uRL = iSiteEntryArray[n].getURL();
                URL uRL3 = Platform.resolve((URL)uRL);
                if (UpdateManagerUtils.sameURL(uRL3, uRL2)) {
                    return true;
                }
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = NLS.bind((String)Messages.ConfiguredSite_UnableResolveURL, (Object[])new String[]{string});
            throw Utilities.newCoreException(string2, malformedURLException);
        }
        catch (IOException iOException) {
            String string3 = NLS.bind((String)Messages.ConfiguredSite_UnableToAccessSite, (Object[])new Object[]{uRL});
            throw Utilities.newCoreException(string3, iOException);
        }
    }

    private boolean validateNoConfiguredParents(IFeature iFeature) throws CoreException {
        if (iFeature == null) {
            AppPlugin.warn("ConfigurationPolicy: validate Feature is null");
            return true;
        }
        IFeatureReference[] iFeatureReferenceArray = UpdateManagerUtils.getParentFeatures(iFeature, this.getConfiguredFeatures(), false);
        return iFeatureReferenceArray.length == 0;
    }
}

