/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IInstallHandler;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.IInstallHandlerWithFilter;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.osgi.framework.Bundle;

public class InstallHandlerProxy
implements IInstallHandlerWithFilter {
    private IFeature feature = null;
    private int type;
    private IInstallHandler handler = null;
    private IStatus savedStatus = null;
    private boolean DEBUG = false;
    private static final String EXT_PLUGIN = "org.eclipse.ercp.update";
    private static final String UI_PLUGIN = "org.eclipse.ui";
    private static final String EXT_POINT = "installHandlers";
    private Method nonPluginDataAcceptor = null;
    static /* synthetic */ Class class$0;

    private InstallHandlerProxy() {
    }

    public InstallHandlerProxy(int n, IFeature iFeature, IInstallHandlerEntry iInstallHandlerEntry, InstallMonitor installMonitor) throws CoreException {
        this.initialize(n, iFeature, iInstallHandlerEntry, installMonitor);
    }

    public void initialize(int n, IFeature iFeature, IInstallHandlerEntry iInstallHandlerEntry, InstallMonitor installMonitor) throws CoreException {
        this.DEBUG = AppPlugin.DEBUG_SHOW_IHANDLER;
        if (iFeature == null) {
            throw new IllegalArgumentException();
        }
        this.feature = iFeature;
        this.type = n;
        if (iInstallHandlerEntry == null) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        String string = iInstallHandlerEntry.getLibrary();
        String string2 = iInstallHandlerEntry.getHandlerName();
        if (string2 == null || string2.trim().equals("")) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("handler=" + string2);
            this.debug("path=   " + string);
        }
        try {
            this.handler = string == null || string.trim().equals("") ? this.getGlobalHandler(string2) : this.getLocalHandler(string, string2);
            if (this.handler == null) {
                return;
            }
            this.handler.initialize(n, iFeature, iInstallHandlerEntry, installMonitor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_notFound, (Object[])new String[]{iFeature.getLabel()}), classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_invalidHandler, (Object[])new String[]{iFeature.getLabel()}), classCastException);
        }
        catch (CoreException coreException) {
            this.handleExceptionInInit(null, (Exception)((Object)coreException));
        }
        catch (Exception exception) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{iFeature.getLabel()}), exception);
        }
    }

    public void installInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installInitiated()");
            }
            this.handler.installInitiated();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void pluginsDownloaded(IPluginEntry[] iPluginEntryArray) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling pluginsDownloaded()");
            }
            this.handler.pluginsDownloaded(iPluginEntryArray);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void completeInstall(IFeatureContentConsumer iFeatureContentConsumer) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeInstall()");
            }
            this.handler.completeInstall(iFeatureContentConsumer);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void nonPluginDataDownloaded(INonPluginEntry[] iNonPluginEntryArray, IVerificationListener iVerificationListener) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling nonPluginDataDownloaded()");
            }
            this.handler.nonPluginDataDownloaded(iNonPluginEntryArray, iVerificationListener);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void installCompleted(boolean bl) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installCompleted()");
            }
            this.handler.installCompleted(bl);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void configureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureInitiated()");
            }
            this.handler.configureInitiated();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void completeConfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeConfigure()");
            }
            this.handler.completeConfigure();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void configureCompleted(boolean bl) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureCompleted()");
            }
            this.handler.configureCompleted(bl);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void unconfigureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureInitiated()");
            }
            this.handler.unconfigureInitiated();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void completeUnconfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUnconfigure()");
            }
            this.handler.completeUnconfigure();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void unconfigureCompleted(boolean bl) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureCompleted()");
            }
            this.handler.unconfigureCompleted(bl);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    public void uninstallInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallInitiated()");
            }
            this.handler.uninstallInitiated();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void completeUninstall() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUninstall()");
            }
            this.handler.completeUninstall();
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
    }

    public void uninstallCompleted(boolean bl) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallCompleted()");
            }
            this.handler.uninstallCompleted(bl);
        }
        catch (Throwable throwable) {
            this.handleExceptionInCall(throwable, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    private void handleExceptionInInit(String string, Exception exception) throws CoreException {
        CoreException coreException = exception instanceof CoreException ? (CoreException)((Object)exception) : Utilities.newCoreException(string, exception);
        if (!this.isUndoAction()) {
            throw coreException;
        }
        String string2 = AppPlugin.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, string2, 0, "InstallHandler.deactivated", (Throwable)coreException);
        AppPlugin.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private void handleExceptionInCall(Throwable throwable, IFeature iFeature) throws CoreException {
        CoreException coreException = throwable instanceof CoreException ? (CoreException)throwable : Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_callException, (Object[])new String[]{iFeature.getLabel()}), throwable);
        if (!this.isUndoAction()) {
            throw coreException;
        }
        String string = AppPlugin.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, string, 0, "InstallHandler.deactivated", (Throwable)coreException);
        AppPlugin.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private boolean isUndoAction() {
        return this.type != 1 && this.type != 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IInstallHandler getLocalHandler(String string, String string2) throws IOException, CoreException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL[] uRLArray;
        block18: {
            ContentReference contentReference = this.feature.getFeatureContentProvider().getFeatureManifestReference(null);
            URL uRL = null;
            if (contentReference != null) {
                uRL = contentReference.asURL();
            }
            if (uRL == null) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{this.feature.getLabel()}), null);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (true) {
                if (n >= uRLArray.length) {
                    if (this.type == 4) {
                        break;
                    }
                    break block18;
                }
                uRLArray[n] = new URL(uRL, stringTokenizer.nextToken());
                ++n;
            }
            URL[] uRLArray2 = new URL[uRLArray.length];
            int n2 = 0;
            while (true) {
                InputStream inputStream;
                File file;
                block20: {
                    Object var12_15;
                    if (n2 >= uRLArray.length) {
                        uRLArray = uRLArray2;
                        break;
                    }
                    file = File.createTempFile("tmp" + n2, ".jar");
                    file.deleteOnExit();
                    FileOutputStream fileOutputStream = null;
                    inputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        inputStream = new FileInputStream(uRLArray[n2].getPath());
                        Utilities.copy(inputStream, fileOutputStream, null);
                    }
                    catch (Throwable throwable) {
                        var12_15 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    {
                        var12_15 = null;
                        if (fileOutputStream == null) break block20;
                    }
                    try {}
                    catch (Exception exception) {}
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    try {}
                    catch (Exception exception) {}
                    inputStream.close();
                }
                uRLArray2[n2] = file.toURL();
                ++n2;
            }
        }
        InstallHandlerClassLoader installHandlerClassLoader = new InstallHandlerClassLoader(uRLArray);
        Class<?> clazz = ((ClassLoader)installHandlerClassLoader).loadClass(string2);
        return (IInstallHandler)clazz.newInstance();
    }

    private IInstallHandler getGlobalHandler(String string) throws Exception {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(EXT_PLUGIN, EXT_POINT, string);
        if (iConfigurationElementArray == null || iConfigurationElementArray.length <= 0) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{this.feature.getLabel()}), null);
        }
        return (IInstallHandler)iConfigurationElementArray[0].createExecutableExtension("class");
    }

    private void debug(String string) {
        String string2 = this.feature == null ? "" : this.feature.getVersionedIdentifier().toString();
        System.out.println("InstallHandler[" + string2 + "]: " + string);
    }

    public boolean acceptNonPluginData(INonPluginEntry iNonPluginEntry) {
        Boolean bl = new Boolean(true);
        if (this.handler != null) {
            if (this.DEBUG) {
                this.debug("calling acceptNonPluginData()");
            }
            if (this.handler instanceof IInstallHandlerWithFilter) {
                return ((IInstallHandlerWithFilter)this.handler).acceptNonPluginData(iNonPluginEntry);
            }
            if (this.getNonPluginDataAcceptor() != null) {
                try {
                    Object[] objectArray = new Object[]{iNonPluginEntry};
                    bl = (Boolean)this.getNonPluginDataAcceptor().invoke((Object)this.handler, objectArray);
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private Method getNonPluginDataAcceptor() {
        if (this.nonPluginDataAcceptor == null) {
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.update.core.INonPluginEntry");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] classArray2 = classArray;
                this.nonPluginDataAcceptor = this.handler.getClass().getMethod("acceptNonPluginData", classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return this.nonPluginDataAcceptor;
    }

    private static class InstallHandlerClassLoader
    extends URLClassLoader {
        private Bundle updateCore = Platform.getBundle((String)"org.eclipse.ercp.update");
        private Bundle eclipseUI = Platform.getBundle((String)"org.eclipse.ui");

        public InstallHandlerClassLoader(URL[] uRLArray) {
            super(uRLArray);
            if (this.eclipseUI != null && this.eclipseUI.getState() != 32) {
                this.eclipseUI = null;
            }
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = this.updateCore.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    if (this.eclipseUI != null) {
                        clazz = this.eclipseUI.loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            if (clazz != null) {
                return clazz;
            }
            return super.loadClass(string);
        }

        public URL getResource(String string) {
            URL uRL = this.updateCore.getResource(string);
            if (uRL == null && this.eclipseUI != null) {
                uRL = this.eclipseUI.getResource(string);
            }
            if (uRL != null) {
                return uRL;
            }
            return super.getResource(string);
        }
    }
}

