/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.FileFragment;
import org.eclipse.update.internal.core.FragmentEntry;
import org.eclipse.update.internal.core.IWritable;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.IResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class UpdateManagerUtils {
    private static boolean OS_UNIX = "hpux".equals(Platform.getOS()) || "aix".equals(Platform.getOS()) || "linux".equals(Platform.getOS()) || "solaris".equals(Platform.getOS());
    private static FragmentEntry[] noFragments = new FragmentEntry[0];
    private static Map table = new HashMap();
    private static Writer writer;
    private static Map urlFileMap;
    private static Map localFileFragmentMap;
    private static Stack bufferPool;
    private static final int BUFFER_SIZE = 4096;
    private static final int INCREMENT_SIZE = 10240;

    static {
        table.put("compatible", new Integer(3));
        table.put("perfect", new Integer(1));
        table.put("equivalent", new Integer(2));
        table.put("greaterOrEqual", new Integer(4));
    }

    public static URL getURL(URL uRL, String string, String string2) throws MalformedURLException {
        URL uRL2 = null;
        if (string == null || string.trim().equals("")) {
            if (string2 == null || string2.trim().equals("")) {
                return null;
            }
            string = string2;
        }
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = new URL(uRL, string);
        }
        return uRL2;
    }

    public static String getURLAsString(URL uRL, URL uRL2) {
        String string = null;
        if (uRL == null) {
            return uRL2 == null ? null : uRL2.toString();
        }
        if (uRL2 != null) {
            String string2;
            int n;
            string = uRL2.toExternalForm();
            if (uRL.getHost() != null && !uRL.getHost().equals(uRL2.getHost())) {
                return string;
            }
            if (uRL.getProtocol() != null && !uRL.getProtocol().equals(uRL2.getProtocol())) {
                return string;
            }
            if (uRL.getPort() != uRL2.getPort()) {
                return string;
            }
            String string3 = uRL.getFile();
            if (!(string3 = string3.replace(File.separatorChar, '/')).endsWith("/") && (n = string3.lastIndexOf(47)) != -1) {
                string3 = string3.substring(0, n);
            }
            if ((string2 = uRL2.getFile()).startsWith(string3)) {
                string = string2.substring(string3.length());
                string = string.replace(File.separatorChar, '/');
            } else {
                if ("file".equalsIgnoreCase(uRL2.getProtocol())) {
                    File file;
                    File file2 = new File(string3);
                    File file3 = file = new File(string2);
                    while (file3 != null && !file2.equals(file3.getParentFile())) {
                        file3 = file3.getParentFile();
                    }
                    if (file3 == null) {
                        AppPlugin.warn("Cannot calculate relative path");
                        return uRL2.toString();
                    }
                    String string4 = file3.getParentFile().getAbsolutePath();
                    String string5 = file.getAbsolutePath();
                    if (!string5.startsWith(string4)) {
                        AppPlugin.warn("Full path:" + string5 + " does not start with " + string4);
                        return uRL2.toString();
                    }
                    String string6 = string5.substring(string4.length() + 1);
                    if (file.isDirectory()) {
                        string6 = String.valueOf(string6) + File.separator;
                    }
                    string6 = string6.replace(File.separatorChar, '/');
                    return string6;
                }
                string = uRL2.toString();
            }
        }
        return string;
    }

    public static String getResourceString(String string, ResourceBundle resourceBundle) {
        String string2 = null;
        if (string != null) {
            string2 = Platform.getResourceString((Bundle)AppPlugin.getPlugin().getBundle(), (String)string, (ResourceBundle)resourceBundle);
        }
        return string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL copyToLocal(InputStream inputStream, String string, InstallMonitor installMonitor) throws MalformedURLException, IOException, InstallAbortedException {
        Object object;
        URL uRL = null;
        File file = new File(string);
        int n = file.getPath().lastIndexOf(File.separator);
        if (n != -1 && !((File)(object = new File(file.getPath().substring(0, n)))).exists()) {
            ((File)object).mkdirs();
        }
        if (file.isDirectory()) return file.toURL();
        object = new FileOutputStream(file);
        try {
            Utilities.copy(inputStream, (OutputStream)object, installMonitor);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((OutputStream)object).close();
        return file.toURL();
    }

    public static void checkPermissions(ContentReference contentReference, String string) {
        if (contentReference.getPermission() != 0) {
            AppPlugin.warn("Change permission for " + string + " to " + contentReference.getPermission());
        }
        if (string != null && OS_UNIX && contentReference.getPermission() != 0) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"chmod", "a+x", string});
                StreamConsumer streamConsumer = new StreamConsumer(process.getInputStream());
                streamConsumer.setName("chmod output reader");
                streamConsumer.start();
                StreamConsumer streamConsumer2 = new StreamConsumer(process.getErrorStream());
                streamConsumer2.setName("chmod error reader");
                streamConsumer2.start();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getLocalRandomIdentifier(String string, Date date) {
        String string2;
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf(File.separator);
        String string3 = string2 = n != -1 && n2 < n ? string.substring(n) : "";
        if (n2 == -1) {
            n2 = 0;
        }
        if (n == -1) {
            n = string.length();
        }
        String string4 = n2 < n ? string.substring(n2, n) : "Eclipse_Update_TMP_";
        String string5 = String.valueOf(string4) + date.getTime() + string2;
        return string5;
    }

    public static void removeFromFileSystem(File file) {
        Object object;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (object = file.list()) != null) {
            int n = 0;
            while (n < ((String[])object).length) {
                UpdateManagerUtils.removeFromFileSystem(new File(file, object[n]));
                ++n;
            }
        }
        if (!file.delete()) {
            object = NLS.bind((String)Messages.UpdateManagerUtils_UnableToRemoveFile, (Object[])new String[]{file.getAbsolutePath()});
            AppPlugin.log((String)object, new Exception());
        }
    }

    public static void removeEmptyDirectoriesFromFileSystem(File file) {
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(file, stringArray[n]));
                ++n;
            }
        }
        if (!file.delete()) {
            String string = NLS.bind((String)Messages.UpdateManagerUtils_UnableToRemoveFile, (Object[])new String[]{file.getAbsolutePath()});
            AppPlugin.log(string, new Exception());
        }
    }

    public static IPluginEntry[] diff(IPluginEntry[] iPluginEntryArray, IPluginEntry[] iPluginEntryArray2) {
        if (iPluginEntryArray == null || iPluginEntryArray.length == 0) {
            return new IPluginEntry[0];
        }
        if (iPluginEntryArray2 == null || iPluginEntryArray2.length == 0) {
            return iPluginEntryArray;
        }
        List<IPluginEntry> list = Arrays.asList(iPluginEntryArray2);
        ArrayList<IPluginEntry> arrayList = new ArrayList<IPluginEntry>(0);
        int n = 0;
        while (n < iPluginEntryArray.length) {
            if (!list.contains(iPluginEntryArray[n])) {
                arrayList.add(iPluginEntryArray[n]);
            }
            ++n;
        }
        IPluginEntry[] iPluginEntryArray3 = new IPluginEntry[arrayList.size()];
        if (arrayList.size() > 0) {
            arrayList.toArray(iPluginEntryArray3);
        }
        return iPluginEntryArray3;
    }

    public static URL getParent(URL uRL) {
        String string = uRL.getFile();
        int n = string.length();
        if (n == 0 || n == 1 && string.charAt(0) == '/') {
            return null;
        }
        int n2 = -1;
        int n3 = n - 2;
        while (n2 == -1 && n3 >= 0) {
            if (string.charAt(n3) == '/') {
                n2 = n3;
            }
            --n3;
        }
        string = n2 == -1 ? "" : string.substring(0, n2 + 1);
        try {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, malformedURLException.getMessage());
        }
        return uRL;
    }

    public static URL asDirectoryURL(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        if (!string.endsWith("/")) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n + 1);
            }
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        return uRL;
    }

    public static boolean sameURL(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if (uRL == uRL2) {
            return true;
        }
        if (uRL.equals(uRL2)) {
            return true;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uRL2.getProtocol())) {
            return false;
        }
        File file = UpdateManagerUtils.getFileFor(uRL);
        File file2 = UpdateManagerUtils.getFileFor(uRL2);
        if (file == null) {
            return false;
        }
        return file.equals(file2);
    }

    private static File getFileFor(URL uRL) {
        if (urlFileMap == null) {
            urlFileMap = new HashMap();
        }
        if (urlFileMap.get(uRL) != null) {
            return (File)urlFileMap.get(uRL);
        }
        File file = new File(uRL.getFile());
        urlFileMap.put(uRL, file);
        return file;
    }

    public static IFeatureReference[] getParentFeatures(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, boolean bl) throws CoreException {
        if (iFeature == null) {
            return new IFeatureReference[0];
        }
        ArrayList<IFeatureReference> arrayList = new ArrayList<IFeatureReference>();
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = null;
        IFeature iFeature2 = null;
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            block13: {
                try {
                    IFeature iFeature3 = iFeatureReferenceArray[n].getFeature(null);
                    if (iFeature3 == null) break block13;
                    iIncludedFeatureReferenceArray = iFeature3.getIncludedFeatureReferences();
                    int n2 = 0;
                    while (n2 < iIncludedFeatureReferenceArray.length) {
                        try {
                            iFeature2 = iIncludedFeatureReferenceArray[n2].getFeature(null);
                        }
                        catch (CoreException coreException) {
                            AppPlugin.warn("", coreException);
                        }
                        if (iFeature.equals(iFeature2)) {
                            if (bl) {
                                if (UpdateManagerUtils.isOptional(iIncludedFeatureReferenceArray[n2])) {
                                    arrayList.add(iFeatureReferenceArray[n]);
                                } else {
                                    AppPlugin.warn("Feature :" + iIncludedFeatureReferenceArray[n2] + " not optional. Not included in parents list.");
                                }
                            } else {
                                arrayList.add(iFeatureReferenceArray[n]);
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    AppPlugin.warn("", coreException);
                }
            }
            ++n;
        }
        IFeatureReference[] iFeatureReferenceArray2 = new IFeatureReference[]{};
        if (arrayList.size() > 0) {
            iFeatureReferenceArray2 = new IFeatureReference[arrayList.size()];
            arrayList.toArray(iFeatureReferenceArray2);
        }
        return iFeatureReferenceArray2;
    }

    public static IFeatureReference[] getParentFeatures(IFeatureReference iFeatureReference, IFeatureReference[] iFeatureReferenceArray, boolean bl) throws CoreException {
        if (iFeatureReference == null) {
            return new IFeatureReference[0];
        }
        IFeature iFeature = null;
        try {
            iFeature = iFeatureReference.getFeature(null);
        }
        catch (CoreException coreException) {
            AppPlugin.warn(null, coreException);
        }
        if (iFeature == null) {
            return new IFeatureReference[0];
        }
        return UpdateManagerUtils.getParentFeatures(iFeature, iFeatureReferenceArray, bl);
    }

    public static void checkConnectionResult(IResponse iResponse, URL uRL) throws IOException {
        int n = iResponse.getStatusCode();
        if (n != 200) {
            String string = iResponse.getStatusMessage();
            throw new IOException(NLS.bind((String)Messages.ContentReference_HttpNok, (Object[])new Object[]{new Integer(n), string, uRL}));
        }
    }

    public static IFeatureReference[] optionalChildrenToInstall(IFeatureReference[] iFeatureReferenceArray, IFeatureReference[] iFeatureReferenceArray2) {
        ArrayList<IFeatureReference> arrayList = new ArrayList<IFeatureReference>();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            IFeatureReference iFeatureReference = iFeatureReferenceArray[n];
            if (!UpdateManagerUtils.isOptional(iFeatureReference)) {
                arrayList.add(iFeatureReference);
            } else {
                int n2 = 0;
                while (n2 < iFeatureReferenceArray2.length) {
                    if (iFeatureReference.equals(iFeatureReferenceArray2[n2])) {
                        arrayList.add(iFeatureReference);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        IFeatureReference[] iFeatureReferenceArray3 = new IFeatureReference[arrayList.size()];
        if (arrayList.size() > 0) {
            arrayList.toArray(iFeatureReferenceArray3);
        }
        return iFeatureReferenceArray3;
    }

    public static int getMatchingRule(String string) {
        if (string == null) {
            return 1;
        }
        int n = (Integer)table.get(string);
        if (n == 0) {
            return 1;
        }
        return n;
    }

    public static int getMatchingIdRule(String string) {
        if (string != null && string.equalsIgnoreCase("prefix")) {
            return 1;
        }
        return 1;
    }

    public static boolean isOptional(IFeatureReference iFeatureReference) {
        if (iFeatureReference == null) {
            return false;
        }
        if (iFeatureReference instanceof IIncludedFeatureReference) {
            return ((IIncludedFeatureReference)iFeatureReference).isOptional();
        }
        return false;
    }

    public static boolean isValidEnvironment(IPlatformEnvironment iPlatformEnvironment) {
        if (iPlatformEnvironment == null) {
            return false;
        }
        String string = iPlatformEnvironment.getOS();
        String string2 = iPlatformEnvironment.getWS();
        String string3 = iPlatformEnvironment.getOSArch();
        String string4 = iPlatformEnvironment.getNL();
        if (string != null && !UpdateManagerUtils.isMatching(string, SiteManager.getOS())) {
            return false;
        }
        if (string2 != null && !UpdateManagerUtils.isMatching(string2, SiteManager.getWS())) {
            return false;
        }
        if (string3 != null && !UpdateManagerUtils.isMatching(string3, SiteManager.getOSArch())) {
            return false;
        }
        return string4 == null || UpdateManagerUtils.isMatchingLocale(string4, SiteManager.getNL());
    }

    private static boolean isMatching(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equals(string)) {
            return true;
        }
        if ("".equals(string)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            while (stringTokenizer2.hasMoreTokens()) {
                if (!string3.equalsIgnoreCase(stringTokenizer2.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMatchingLocale(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equals(string)) {
            return true;
        }
        if ("".equals(string)) {
            return true;
        }
        string2 = string2.toUpperCase();
        string = string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) == 0) {
                return true;
            }
            if (string3.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public static Writer getWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (writer == null) {
            writer = new Writer();
        }
        writer.init(file, string);
        return writer;
    }

    public static boolean isSameTimestamp(URL uRL, long l) {
        try {
            URL uRL2 = URLEncoder.encode(uRL);
            IResponse iResponse = ConnectionFactory.get(uRL2);
            long l2 = iResponse.getLastModified();
            return Math.abs(l2 - l) / 1000L <= 2L;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static synchronized void mapLocalFileFragment(String string, FileFragment fileFragment) {
        if (string != null) {
            if (localFileFragmentMap == null) {
                localFileFragmentMap = new HashMap();
            }
            localFileFragmentMap.put(string, fileFragment);
        }
    }

    public static synchronized void unMapLocalFileFragment(String string) {
        if (string != null && localFileFragmentMap != null) {
            localFileFragmentMap.remove(string);
        }
    }

    public static synchronized FileFragment lookupLocalFileFragment(String string) {
        if (localFileFragmentMap == null) {
            return null;
        }
        return (FileFragment)localFileFragmentMap.get(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream inputStream, OutputStream outputStream, InstallMonitor installMonitor, long l) {
        byte[] byArray;
        block12: {
            long l2;
            block11: {
                byArray = UpdateManagerUtils.getBuffer();
                long l3 = 0L;
                try {
                    try {
                        int n = inputStream.read(byArray);
                        int n2 = 0;
                        while (n != -1) {
                            outputStream.write(byArray, 0, n);
                            l3 += (long)n;
                            if (installMonitor != null) {
                                if ((n2 += n) >= 10240) {
                                    installMonitor.incrementCount(n2);
                                    n2 = 0;
                                }
                                if (installMonitor.isCanceled()) {
                                    l2 = l3;
                                    Object var10_11 = null;
                                    break block11;
                                }
                            }
                            if (l > 0L && l3 == l) break;
                            n = inputStream.read(byArray);
                        }
                        if (n2 > 0 && installMonitor != null) {
                            installMonitor.incrementCount(n2);
                        }
                        if (l > 0L && l3 != l) {
                            throw new IOException(NLS.bind((String)Messages.UpdateManagerUtils_inputStreamEnded, (Object[])new String[]{String.valueOf(l3), String.valueOf(l)}));
                        }
                        break block12;
                    }
                    catch (IOException iOException) {
                        AppPlugin.log(NLS.bind((String)Messages.UpdateManagerUtils_copy, (Object[])new String[]{String.valueOf(l3)}), iOException);
                        long l4 = l3;
                        Object var10_13 = null;
                        UpdateManagerUtils.freeBuffer(byArray);
                        return l4;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    UpdateManagerUtils.freeBuffer(byArray);
                    throw throwable;
                }
            }
            UpdateManagerUtils.freeBuffer(byArray);
            return l2;
        }
        Object var10_12 = null;
        UpdateManagerUtils.freeBuffer(byArray);
        return -1L;
    }

    private static synchronized byte[] getBuffer() {
        if (bufferPool == null) {
            return new byte[4096];
        }
        try {
            return (byte[])bufferPool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return new byte[4096];
        }
    }

    private static synchronized void freeBuffer(byte[] byArray) {
        if (bufferPool == null) {
            bufferPool = new Stack();
        }
        bufferPool.push(byArray);
    }

    public static FragmentEntry[] getFragments(Bundle bundle) {
        PackageAdmin packageAdmin = AppPlugin.getPlugin().getPackageAdmin();
        Bundle[] bundleArray = packageAdmin.getFragments(bundle);
        if (bundleArray == null) {
            return noFragments;
        }
        FragmentEntry[] fragmentEntryArray = new FragmentEntry[bundleArray.length];
        int n = 0;
        while (n < fragmentEntryArray.length) {
            fragmentEntryArray[n] = new FragmentEntry((String)bundleArray[n].getHeaders().get("Bundle-SymbolicName"), (String)bundleArray[n].getHeaders().get("Bundle-Version"), Platform.getResourceString((Bundle)bundleArray[n], (String)((String)bundleArray[n].getHeaders().get("Bundle-Version"))), bundleArray[n].getLocation());
            ++n;
        }
        return fragmentEntryArray;
    }

    public static String getWritableXMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class StreamConsumer
    extends Thread {
        InputStream is;
        byte[] buf;

        public StreamConsumer(InputStream inputStream) {
            this.setDaemon(true);
            this.is = inputStream;
            this.buf = new byte[512];
        }

        public void run() {
            try {
                int n = 0;
                while (n >= 0) {
                    n = this.is.read(this.buf);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static class Writer {
        private PrintWriter w;
        private OutputStream out;
        private OutputStreamWriter outWriter;
        private BufferedWriter buffWriter;
        private String encoding;

        private Writer() {
        }

        public void init(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
            this.encoding = string;
            this.out = new FileOutputStream(file);
            this.outWriter = new OutputStreamWriter(this.out, string);
            this.buffWriter = new BufferedWriter(this.outWriter);
            this.w = new PrintWriter(this.buffWriter);
        }

        public void write(IWritable iWritable) {
            this.w.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.w.println("");
            this.w.println("<!-- File written by Update manager 2.0 -->");
            this.w.println("<!-- comments in this file are not preserved -->");
            this.w.println("");
            iWritable.write(0, this.w);
            this.close();
        }

        public void close() {
            this.w.close();
        }

        private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
            String string = Writer.getReplacement(c);
            if (string != null) {
                stringBuffer.append('&');
                stringBuffer.append(string);
                stringBuffer.append(';');
            } else if (c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("&#");
                stringBuffer.append(Integer.toString(c));
                stringBuffer.append(';');
            }
        }

        public static String xmlSafe(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n = 0;
            while (n < string.length()) {
                Writer.appendEscapedChar(stringBuffer, string.charAt(n));
                ++n;
            }
            return stringBuffer.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
            }
            return null;
        }
    }

    public static class CopyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Exception rootException;
        int bytesCopied;

        public CopyException(Exception exception, int n) {
            this.rootException = exception;
            this.bytesCopied = n;
        }

        public Exception getRootException() {
            return this.rootException;
        }

        public int getBytesCopied() {
            return this.bytesCopied;
        }
    }
}

