/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.connection.AbstractResponse;
import org.eclipse.update.internal.core.connection.TooManyOpenConnectionsException;

public class HttpResponse
extends AbstractResponse {
    protected URL url;
    protected InputStream in;
    protected long lastModified;
    protected long offset;
    private boolean isPoorNetwork = false;

    protected HttpResponse(URL uRL) {
        this.url = uRL;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            try {
                InputStream inputStream = this.connection.getInputStream();
                if (inputStream != null) {
                    this.in = new MonitoringInputStream(inputStream);
                }
            }
            catch (IOException iOException) {
                this.connection = null;
                throw iOException;
            }
            this.checkOffset();
        }
        return this.in;
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getInputStream(IProgressMonitor var1_1) throws IOException, CoreException, TooManyOpenConnectionsException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            if (var1_1 != null) {
                try {
                    var2_2 = this.openStreamWithCancel(this.connection, var1_1);
                    if (var2_2 == null) ** GOTO lbl23
                    this.in = new MonitoringInputStream(var2_2);
                }
                catch (IOException var2_3) {
                    this.connection = null;
                    throw var2_3;
                }
            } else {
                try {
                    var2_4 = this.connection.getInputStream();
                    if (var2_4 != null) {
                        this.in = new MonitoringInputStream(var2_4);
                    }
                }
                catch (IOException var2_5) {
                    this.connection = null;
                    throw var2_5;
                }
            }
lbl23:
            // 3 sources

            this.checkOffset();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection == null) {
            try {
                this.connection = this.url.openConnection();
            }
            catch (IOException iOException) {}
        }
        if (this.connection != null) {
            this.isPoorNetwork = false;
            StatusThread statusThread = new StatusThread((HttpURLConnection)this.connection);
            statusThread.start();
            int n = 10000;
            try {
                String string = System.getProperty("sun.net.client.defaultConnectTimeout");
                if (string != null) {
                    n = Integer.parseInt(string);
                }
                if (n < 1000) {
                    n = 1000;
                }
            }
            catch (Exception exception) {}
            try {
                statusThread.join(n);
                if (statusThread.isAlive()) {
                    if (AppPlugin.DEBUG) {
                        System.out.println("[eUpdate Debug] Internal time out detection for HttpURLConnection.");
                    }
                    statusThread.interrupt();
                    this.isPoorNetwork = true;
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.isPoorNetwork) {
                return 504;
            }
            return statusThread.getResponseCode();
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null) {
            if (this.isPoorNetwork) {
                return "";
            }
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException iOException) {
                AppPlugin.warn("", iOException);
            }
        }
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.connection == null) {
                try {
                    this.connection = this.url.openConnection();
                }
                catch (IOException iOException) {}
            }
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.lastModified;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    private void checkOffset() throws IOException {
        if (this.offset == 0L) {
            return;
        }
        String string = this.connection.getHeaderField("Content-Range");
        if (string == null) {
            throw new IOException(Messages.HttpResponse_rangeExpected);
        }
        if (!string.startsWith("bytes " + this.offset + "-")) {
            throw new IOException(Messages.HttpResponse_wrongRange);
        }
    }

    private class MonitoringInputStream
    extends FilterInputStream {
        InputStream in;

        public MonitoringInputStream(InputStream inputStream) {
            super(inputStream);
            this.in = inputStream;
        }

        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return super.read(byArray);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return super.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public long skip(long l) throws IOException {
            try {
                return super.skip(l);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }
    }

    public class StatusThread
    extends Thread {
        HttpURLConnection conn;
        int result;

        public StatusThread(HttpURLConnection httpURLConnection) {
            this.conn = httpURLConnection;
        }

        public void run() {
            try {
                this.result = this.conn.getResponseCode();
            }
            catch (IOException iOException) {
                AppPlugin.warn("", iOException);
            }
        }

        public int getResponseCode() {
            return this.result;
        }
    }
}

