/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationParser;

public class InstallConfigurationModel
extends ModelObject {
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;
    private boolean isCurrent = false;
    private URL locationURL;
    private String locationURLString;
    protected Date date;
    private String label;
    private List activities;
    private List configurationSites;
    protected boolean initialized = false;
    protected boolean lightlyInitialized = false;

    public ConfiguredSiteModel[] getConfigurationSitesModel() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites == null || this.configurationSites.size() == 0) {
            return new ConfiguredSiteModel[0];
        }
        return (ConfiguredSiteModel[])this.configurationSites.toArray(this.arrayTypeFor(this.configurationSites));
    }

    public void addConfigurationSiteModel(ConfiguredSiteModel configuredSiteModel) {
        if (this.configurationSites == null) {
            this.configurationSites = new ArrayList();
        }
        if (!this.configurationSites.contains((Object)configuredSiteModel)) {
            this.configurationSites.add(configuredSiteModel);
        }
    }

    public void setConfigurationSiteModel(ConfiguredSiteModel[] configuredSiteModelArray) {
        this.configurationSites = null;
        int n = 0;
        while (n < configuredSiteModelArray.length) {
            this.addConfigurationSiteModel(configuredSiteModelArray[n]);
            ++n;
        }
    }

    public boolean removeConfigurationSiteModel(ConfiguredSiteModel configuredSiteModel) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites != null) {
            return this.configurationSites.remove((Object)configuredSiteModel);
        }
        return false;
    }

    public boolean isCurrent() {
        if (!this.lightlyInitialized && !this.initialized) {
            this.doLightInitialization();
        }
        return this.isCurrent;
    }

    public void setCurrent(boolean bl) {
        this.isCurrent = bl;
    }

    public ConfigurationActivityModel[] getActivityModel() {
        if (this.activities == null && !this.initialized) {
            this.initialize();
        }
        if (this.activities == null || this.activities.size() == 0) {
            return new ConfigurationActivityModel[0];
        }
        return (ConfigurationActivityModel[])this.activities.toArray(this.arrayTypeFor(this.activities));
    }

    public void addActivityModel(ConfigurationActivityModel configurationActivityModel) {
        if (this.activities == null) {
            this.activities = new ArrayList();
        }
        if (!this.activities.contains((Object)configurationActivityModel)) {
            this.activities.add(configurationActivityModel);
            configurationActivityModel.setInstallConfigurationModel(this);
        }
    }

    public Date getCreationDate() {
        if (this.date == null) {
            this.doLightInitialization();
        }
        return this.date;
    }

    public void setCreationDate(Date date) {
        this.assertIsWriteable();
        this.date = date;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.locationURL;
    }

    public String getLabel() {
        if (this.label == null) {
            this.doLightInitialization();
        }
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public void setLabel(String string) {
        this.assertIsWriteable();
        this.label = string;
    }

    public String getLocationURLString() {
        if (!this.initialized) {
            this.delayedResolve();
        }
        return this.locationURLString;
    }

    public void setLocationURLString(String string) {
        this.assertIsWriteable();
        this.locationURLString = string;
        this.locationURL = null;
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.base = uRL;
        this.bundleURL = uRL2;
    }

    public long getTimeline() {
        return 0L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        try {
            try {
                try {
                    IPlatformConfiguration iPlatformConfiguration = this.getPlatformConfiguration();
                    new InstallConfigurationParser(iPlatformConfiguration, this, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    AppPlugin.warn(String.valueOf(this.locationURLString) + " does not exist, The local site is not in synch with the file system and is pointing to a file that doesn't exist.", fileNotFoundException);
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_ErrorDuringFileAccess, (Object[])new String[]{this.locationURLString}), fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_ErrorDuringFileAccess, (Object[])new String[]{this.locationURLString}), iOException);
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn("Error processing configuration history:" + this.locationURL.toExternalForm(), coreException);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.initialized = true;
            throw throwable;
        }
        {
            Object var2_7 = null;
            this.initialized = true;
        }
        {
            this.resolveListReference(this.getActivityModel(), this.base, this.bundleURL);
            this.resolveListReference(this.getConfigurationSitesModel(), this.base, this.bundleURL);
            return;
        }
    }

    private IPlatformConfiguration getPlatformConfiguration() throws IOException {
        IPlatformConfiguration iPlatformConfiguration = UpdateManagerUtils.sameURL(this.getURL(), ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation()) ? ConfiguratorUtils.getCurrentPlatformConfiguration() : ConfiguratorUtils.getPlatformConfiguration((URL)this.getURL());
        return iPlatformConfiguration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doLightInitialization() {
        try {
            try {
                try {
                    IPlatformConfiguration iPlatformConfiguration = this.getPlatformConfiguration();
                    new InstallConfigurationParser(iPlatformConfiguration, this, true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    AppPlugin.warn(String.valueOf(this.locationURLString) + " does not exist, The local site is not in synch with the file system and is pointing to a file that doesn't exist.", fileNotFoundException);
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_ErrorDuringFileAccess, (Object[])new String[]{this.locationURLString}), fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_ErrorDuringFileAccess, (Object[])new String[]{this.locationURLString}), iOException);
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn("Error processing configuration history:" + this.locationURL.toExternalForm(), coreException);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.lightlyInitialized = true;
            throw throwable;
        }
        {
            Object var2_7 = null;
            this.lightlyInitialized = true;
            return;
        }
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        try {
            this.locationURL = new URL(this.locationURLString);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(this.locationURLString);
            try {
                this.locationURL = file.exists() ? file.toURL() : this.base;
            }
            catch (MalformedURLException malformedURLException2) {
                this.locationURL = this.base;
            }
        }
    }

    public void resetActivities() {
        this.activities = null;
    }
}

