/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.IBatchFeatureOperation;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;

public abstract class BatchFeatureOperation
extends Operation
implements IBatchFeatureOperation {
    private IFeature[] features;
    private IConfiguredSite[] targetSites;

    public BatchFeatureOperation(IConfiguredSite[] iConfiguredSiteArray, IFeature[] iFeatureArray) {
        this.features = iFeatureArray;
        this.targetSites = iConfiguredSiteArray;
    }

    public IFeature[] getFeatures() {
        return this.features;
    }

    public IConfiguredSite[] getTargetSites() {
        return this.targetSites;
    }

    public void setTargetSites(IConfiguredSite[] iConfiguredSiteArray) {
        this.targetSites = iConfiguredSiteArray;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException, InvocationTargetException {
        if (this.getFeatures() == null || this.getFeatures().length == 0) {
            return false;
        }
        IOperation[] iOperationArray = new IOperation[this.getFeatures().length];
        int n = 0;
        while (n < this.getFeatures().length) {
            iOperationArray[n] = this.createOperation(this.getTargetSites()[n], this.getFeatures()[n]);
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < iOperationArray.length) {
            try {
                boolean bl = iOperationArray[n2].execute(iProgressMonitor, iOperationListener);
                if (bl) {
                    n = 1;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
        return n != 0;
    }

    protected abstract IOperation createOperation(IConfiguredSite var1, IFeature var2);
}

