/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class OptionalFeatureSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries;
    private ArrayList vids = new ArrayList();
    private static final String CATEGORY_ID = "org.eclipse.ercp.update.unified-search";

    public void addVersionedIdentifier(VersionedIdentifier versionedIdentifier) {
        this.vids.add(versionedIdentifier);
    }

    public void clear() {
        this.vids.clear();
    }

    public OptionalFeatureSearchCategory() {
        super(CATEGORY_ID);
        this.queries = new IUpdateSearchQuery[]{new OptionalQuery()};
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    private class OptionalQuery
    implements IUpdateSearchQuery {
        private OptionalQuery() {
        }

        public void run(ISite iSite, String[] stringArray, IUpdateSearchFilter iUpdateSearchFilter, IUpdateSearchResultCollector iUpdateSearchResultCollector, IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask("", OptionalFeatureSearchCategory.this.vids.size());
            int n = 0;
            while (n < OptionalFeatureSearchCategory.this.vids.size()) {
                VersionedIdentifier versionedIdentifier = (VersionedIdentifier)OptionalFeatureSearchCategory.this.vids.get(n);
                iProgressMonitor.subTask(versionedIdentifier.toString());
                IFeature iFeature = this.createFeature(iSite, versionedIdentifier, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (iFeature != null && iUpdateSearchFilter.accept(iFeature)) {
                    iUpdateSearchResultCollector.accept(iFeature);
                }
                ++n;
            }
        }

        private IFeature createFeature(ISite iSite, VersionedIdentifier versionedIdentifier, IProgressMonitor iProgressMonitor) {
            try {
                URL uRL = iSite.getURL();
                String string = versionedIdentifier.toString();
                URL uRL2 = new URL(uRL, "features/" + string + ".jar");
                return iSite.createFeature("org.eclipse.ercp.update.packaged", uRL2, iProgressMonitor);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }
}

