/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class OpenStrategy {
    public static final int DOUBLE_CLICK = 0;
    public static final int SINGLE_CLICK = 1;
    public static final int SELECT_ON_HOVER = 2;
    public static final int ARROW_KEYS_OPEN = 4;
    public static final int NO_TIMER = 1;
    public static final int FILE_EXPLORER = 5;
    public static final int ACTIVE_DESKTOP = 3;
    private static final int TIME = 500;
    private static int CURRENT_METHOD = 0;
    private Listener eventHandler;
    private ListenerList openEventListeners = new ListenerList(1);
    private ListenerList selectionEventListeners = new ListenerList(1);
    private ListenerList postSelectionEventListeners = new ListenerList(1);

    public OpenStrategy(Control control) {
        this.initializeHandler(control.getDisplay());
        this.addListener(control);
    }

    public void addOpenListener(IOpenEventListener iOpenEventListener) {
        this.openEventListeners.add(iOpenEventListener);
    }

    public void removeOpenListener(IOpenEventListener iOpenEventListener) {
        this.openEventListeners.remove(iOpenEventListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionEventListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionEventListeners.remove(selectionListener);
    }

    public void addPostSelectionListener(SelectionListener selectionListener) {
        this.postSelectionEventListeners.add(selectionListener);
    }

    public void removePostSelectionListener(SelectionListener selectionListener) {
        this.postSelectionEventListeners.remove(selectionListener);
    }

    public static int getOpenMethod() {
        return CURRENT_METHOD;
    }

    public static void setOpenMethod(int n) {
        if (n == 0) {
            CURRENT_METHOD = n;
            return;
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("Invalid open mode");
        }
        if ((n & 7) == 0) {
            throw new IllegalArgumentException("Invalid open mode");
        }
        CURRENT_METHOD = n;
    }

    public static boolean activateOnOpen() {
        return OpenStrategy.getOpenMethod() == 0;
    }

    private void addListener(Control control) {
        control.addListener(6, this.eventHandler);
        control.addListener(7, this.eventHandler);
        control.addListener(5, this.eventHandler);
        control.addListener(3, this.eventHandler);
        control.addListener(4, this.eventHandler);
        control.addListener(1, this.eventHandler);
        control.addListener(13, this.eventHandler);
        control.addListener(14, this.eventHandler);
        control.addListener(18, this.eventHandler);
        control.addListener(17, this.eventHandler);
    }

    private void fireSelectionEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.item != null && selectionEvent.item.isDisposed()) {
            return;
        }
        Object[] objectArray = this.selectionEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((SelectionListener)objectArray[n]).widgetSelected(selectionEvent);
            ++n;
        }
    }

    private void fireDefaultSelectionEvent(SelectionEvent selectionEvent) {
        Object[] objectArray = this.selectionEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((SelectionListener)objectArray[n]).widgetDefaultSelected(selectionEvent);
            ++n;
        }
    }

    private void firePostSelectionEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.item != null && selectionEvent.item.isDisposed()) {
            return;
        }
        Object[] objectArray = this.postSelectionEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((SelectionListener)objectArray[n]).widgetSelected(selectionEvent);
            ++n;
        }
    }

    private void fireOpenEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.item != null && selectionEvent.item.isDisposed()) {
            return;
        }
        Object[] objectArray = this.openEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IOpenEventListener)objectArray[n]).handleOpen(selectionEvent);
            ++n;
        }
    }

    private void initializeHandler(final Display display) {
        this.eventHandler = new Listener(){
            boolean timerStarted = false;
            Event mouseUpEvent = null;
            Event mouseMoveEvent = null;
            SelectionEvent selectionPendent = null;
            boolean enterKeyDown = false;
            SelectionEvent defaultSelectionPendent = null;
            boolean arrowKeyDown = false;
            final int[] count = new int[1];
            long startTime = System.currentTimeMillis();
            boolean collapseOccurred = false;
            boolean expandOccurred = false;

            public void handleEvent(Event event) {
                if (event.type == 14) {
                    SelectionEvent selectionEvent = new SelectionEvent(event);
                    OpenStrategy.this.fireDefaultSelectionEvent(selectionEvent);
                    if (CURRENT_METHOD == 0) {
                        OpenStrategy.this.fireOpenEvent(selectionEvent);
                    } else if (this.enterKeyDown) {
                        OpenStrategy.this.fireOpenEvent(selectionEvent);
                        this.enterKeyDown = false;
                        this.defaultSelectionPendent = null;
                    } else {
                        this.defaultSelectionPendent = selectionEvent;
                    }
                    return;
                }
                switch (event.type) {
                    case 6: 
                    case 7: {
                        this.mouseUpEvent = null;
                        this.mouseMoveEvent = null;
                        this.selectionPendent = null;
                        break;
                    }
                    case 5: {
                        Runnable[] runnableArray;
                        if ((CURRENT_METHOD & 2) == 0) {
                            return;
                        }
                        if (event.stateMask != 0) {
                            return;
                        }
                        if (event.widget.getDisplay().getFocusControl() != event.widget) {
                            return;
                        }
                        this.mouseMoveEvent = event;
                        runnableArray = new Runnable[]{new Runnable(this, display, runnableArray){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Display val$display;
                            private final /* synthetic */ Runnable[] val$runnable;
                            {
                                this.this$1 = var1_1;
                                this.val$display = display;
                                this.val$runnable = runnableArray;
                            }

                            public void run() {
                                long l = System.currentTimeMillis();
                                int n = (int)(l - this.this$1.startTime);
                                if (n <= 500) {
                                    this.val$display.timerExec(n * 2 / 3, this.val$runnable[0]);
                                } else {
                                    this.this$1.timerStarted = false;
                                    this.this$1.setSelection(this.this$1.mouseMoveEvent);
                                }
                            }
                        }};
                        this.startTime = System.currentTimeMillis();
                        if (this.timerStarted) break;
                        this.timerStarted = true;
                        display.timerExec(333, runnableArray[0]);
                        break;
                    }
                    case 3: {
                        this.mouseUpEvent = null;
                        this.arrowKeyDown = false;
                        break;
                    }
                    case 17: {
                        this.expandOccurred = true;
                        break;
                    }
                    case 18: {
                        this.collapseOccurred = true;
                        break;
                    }
                    case 4: {
                        this.mouseMoveEvent = null;
                        if (event.button != 1 || (event.stateMask & 0xFFF7FFFF) != 0) {
                            return;
                        }
                        if (this.selectionPendent != null && !this.collapseOccurred && !this.expandOccurred) {
                            this.mouseSelectItem(this.selectionPendent);
                            break;
                        }
                        this.mouseUpEvent = event;
                        this.collapseOccurred = false;
                        this.expandOccurred = false;
                        break;
                    }
                    case 1: {
                        this.mouseMoveEvent = null;
                        this.mouseUpEvent = null;
                        boolean bl = this.arrowKeyDown = (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) && event.stateMask == 0;
                        if (event.character != '\r') break;
                        if (this.defaultSelectionPendent != null) {
                            OpenStrategy.this.fireOpenEvent(new SelectionEvent(event));
                            this.enterKeyDown = false;
                            this.defaultSelectionPendent = null;
                            break;
                        }
                        this.enterKeyDown = true;
                        break;
                    }
                    case 13: {
                        SelectionEvent selectionEvent = new SelectionEvent(event);
                        OpenStrategy.this.fireSelectionEvent(selectionEvent);
                        this.mouseMoveEvent = null;
                        if (this.mouseUpEvent != null) {
                            this.mouseSelectItem(selectionEvent);
                        } else {
                            this.selectionPendent = selectionEvent;
                        }
                        this.count[0] = this.count[0] + 1;
                        display.asyncExec(new Runnable(this, display, event){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Display val$display;
                            private final /* synthetic */ Event val$e;
                            {
                                this.this$1 = var1_1;
                                this.val$display = display;
                                this.val$e = event;
                            }

                            public void run() {
                                if (this.this$1.arrowKeyDown) {
                                    this.val$display.timerExec(500, new Runnable(this, this.val$e){
                                        int id;
                                        final /* synthetic */ 3 this$2;
                                        private final /* synthetic */ Event val$e;
                                        {
                                            this.this$2 = var1_1;
                                            this.val$e = event;
                                            this.id = 3.access$0(var1_1).count[0];
                                        }

                                        public void run() {
                                            if (this.id == 3.access$0(this.this$2).count[0]) {
                                                OpenStrategy.access$4(1.access$0(3.access$0(this.this$2)), new SelectionEvent(this.val$e));
                                                if ((OpenStrategy.access$1() & 4) != 0) {
                                                    OpenStrategy.access$2(1.access$0(3.access$0(this.this$2)), new SelectionEvent(this.val$e));
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    OpenStrategy.access$4(1.access$0(this.this$1), new SelectionEvent(this.val$e));
                                }
                            }

                            static /* synthetic */ 1 access$0(3 var0) {
                                return var0.this$1;
                            }
                        });
                    }
                }
            }

            void mouseSelectItem(SelectionEvent selectionEvent) {
                if ((CURRENT_METHOD & 1) != 0) {
                    OpenStrategy.this.fireOpenEvent(selectionEvent);
                }
                this.mouseUpEvent = null;
                this.selectionPendent = null;
            }

            void setSelection(Event event) {
                if (event == null) {
                    return;
                }
                Widget widget = event.widget;
                if (widget.isDisposed()) {
                    return;
                }
                SelectionEvent selectionEvent = new SelectionEvent(event);
                if (widget instanceof Tree) {
                    Tree tree = (Tree)widget;
                    TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                    if (treeItem != null) {
                        tree.setSelection(new TreeItem[]{treeItem});
                    }
                    selectionEvent.item = treeItem;
                } else if (widget instanceof Table) {
                    Table table = (Table)widget;
                    TableItem tableItem = table.getItem(new Point(event.x, event.y));
                    if (tableItem != null) {
                        table.setSelection(new TableItem[]{tableItem});
                    }
                    selectionEvent.item = tableItem;
                } else {
                    return;
                }
                if (selectionEvent.item == null) {
                    return;
                }
                OpenStrategy.this.fireSelectionEvent(selectionEvent);
                OpenStrategy.this.firePostSelectionEvent(selectionEvent);
            }

            static /* synthetic */ OpenStrategy access$0(1 var0) {
                return var0.OpenStrategy.this;
            }
        };
    }
}

