/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    Button saveDefault;
    Button currentDefault;
    Menu menuBar;
    Image image;
    boolean minimized;
    boolean maximized;
    Menu[] menus;
    String text;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, style);
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != null) continue;
            this.menus[i] = menu;
            return;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    static int checkStyle(int style) {
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.currentDefault;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 8) == 0) {
            if ((this.internal_style & 0x40) == 64) {
                nativeStyle |= 1;
            }
            if ((this.internal_style & 0x80) == 128) {
                nativeStyle |= 2;
            }
            if ((this.internal_style & 0x400) == 1024) {
                nativeStyle |= 4;
            }
            if ((this.internal_style & 0x20) == 32) {
                nativeStyle |= 0x20;
            }
        }
        return nativeStyle;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean isTabItem() {
        return false;
    }

    public boolean isReparentable() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseWidget() {
        this.saveDefault = null;
        this.image = null;
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null || menu.isDisposed()) continue;
                menu.releaseResources();
            }
        }
        this.menuBar = null;
        this.menus = null;
        super.releaseWidget();
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != menu) continue;
            this.menus[i] = null;
            return;
        }
    }

    public void setDefaultButton(Button button) {
        Button newDefault;
        this.checkWidget();
        if (button == null) {
            if (this.saveDefault != null) {
                if (this.saveDefault.isDisposed()) {
                    this.saveDefault = null;
                    newDefault = null;
                } else {
                    newDefault = this.saveDefault;
                }
            } else {
                newDefault = null;
            }
        } else {
            if (button.isDisposed()) {
                Decorations.error(5);
            }
            if ((button.getStyle() & 8) == 0) {
                return;
            }
            newDefault = button;
        }
        Button defaultButton = this.getDefaultButton();
        if (newDefault != defaultButton) {
            OS.Shell_SetDefaultButton(this.internal_handle, newDefault == null ? 0 : newDefault.internal_handle);
            if (newDefault != null) {
                newDefault.setDefault(true);
            }
            if (defaultButton != null) {
                defaultButton.setDefault(false);
            }
            if (this.saveDefault == null) {
                this.saveDefault = newDefault;
            }
            this.currentDefault = newDefault;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            Decorations.error(5);
        }
        this.image = image;
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if (this.maximized == maximized) {
            return;
        }
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                Decorations.error(5);
            }
            if ((menu.internal_style & 2) == 0) {
                Decorations.error(33);
            }
            if (menu.parent != this) {
                Decorations.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        this.minimized = minimized;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Decorations.error(4);
        }
        this.text = string;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.minimized = false;
        this.maximized = false;
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.minimized = false;
        this.maximized = false;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        Button defaultButton = this.getDefaultButton();
        if (defaultButton == null || defaultButton.isDisposed()) {
            return false;
        }
        if (!defaultButton.isVisible() || !defaultButton.isEnabled()) {
            return false;
        }
        defaultButton.click();
        return true;
    }
}

