/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.NativeScrollbar;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    private NativeScrollbar scrollbar;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    protected void internal_createHandle(int index) {
        this.scrollbar = new NativeScrollbar(this, this.internal_parent.internal_handle, this.internal_handle);
        this.internal_handle = this.scrollbar.getHandle();
    }

    void releaseHandle() {
        this.scrollbar.releaseNativeWidget();
        this.internal_handle = 0;
        this.display = null;
        this.scrollbar = null;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Slider.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.scrollbar.getIncrement();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.scrollbar.getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return this.scrollbar.getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.scrollbar.getPageIncrement();
    }

    public int getSelection() {
        this.checkWidget();
        return this.scrollbar.getSelection();
    }

    public int getThumb() {
        this.checkWidget();
        return this.scrollbar.getThumb();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Slider.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        this.scrollbar.setIncrement(value);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        this.scrollbar.setMaximum(value);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        this.scrollbar.setMinimum(value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        this.scrollbar.setPageIncrement(value);
    }

    public void setSelection(int selection) {
        this.checkWidget();
        this.scrollbar.setSelection(selection);
    }

    public void setThumb(int value) {
        this.checkWidget();
        this.scrollbar.setThumb(value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        this.scrollbar.setValues(selection, minimum, maximum, thumb, increment, pageIncrement);
    }
}

