/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Utils {
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_NL = "osgi.nl";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PI_OSGI = "org.eclipse.osgi";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    public static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    static FrameworkLog log;
    private static ServiceTracker bundleTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void debug(String string) {
        if (ConfigurationActivator.DEBUG) {
            System.out.println("PlatformConfig: " + string);
        }
    }

    public static CoreException newCoreException(String string, Throwable throwable) {
        MultiStatus multiStatus;
        if (throwable instanceof CoreException) {
            if (string == null) {
                string = "";
            }
            multiStatus = new MultiStatus("org.eclipse.update.configurator", 0, string, throwable);
            IStatus iStatus = ((CoreException)throwable).getStatus();
            multiStatus.add(iStatus);
            multiStatus.addAll(iStatus);
        } else {
            StringBuffer stringBuffer = new StringBuffer("");
            if (string != null) {
                stringBuffer.append(string);
            }
            if (throwable != null) {
                stringBuffer.append(" [");
                String string2 = throwable.getLocalizedMessage();
                stringBuffer.append(string2 != null ? string2 : throwable.toString());
                stringBuffer.append("]");
            }
            multiStatus = Utils.newStatus(stringBuffer.toString(), throwable);
        }
        return new CoreException((IStatus)multiStatus);
    }

    public static IStatus newStatus(String string, Throwable throwable) {
        return new Status(4, "org.eclipse.update.configurator", 0, string, throwable);
    }

    public static void log(String string) {
        Utils.log(Utils.newStatus(string, null));
    }

    public static void log(IStatus iStatus) {
        if (log != null) {
            log.log(new FrameworkLogEntry(ConfigurationActivator.PI_CONFIGURATOR, iStatus.getMessage(), 0, iStatus.getException(), null));
        } else {
            System.out.println(iStatus.getMessage());
            if (iStatus.getException() != null) {
                iStatus.getException().printStackTrace();
            }
        }
    }

    public static URL asPlatformURL(URL uRL) {
        try {
            URL uRL2 = new URL("platform:/base/");
            URL uRL3 = FileLocator.toFileURL((URL)uRL2);
            if (uRL3.getProtocol().equals("file")) {
                uRL3 = new File(uRL3.getFile()).toURL();
            }
            String string = uRL3.toExternalForm();
            String string2 = uRL.toExternalForm();
            if (string2.startsWith(string)) {
                return new URL(String.valueOf(uRL2.toExternalForm()) + string2.substring(string.length()));
            }
            return uRL;
        }
        catch (Exception exception) {
            return uRL;
        }
    }

    static void shutdown() {
        if (bundleTracker != null) {
            bundleTracker.close();
        }
    }

    public static boolean isRunning() {
        Bundle bundle = Utils.getBundle(PI_OSGI);
        return bundle == null ? false : bundle.getState() == 32;
    }

    public static boolean isValidEnvironment(String string, String string2, String string3, String string4) {
        if (string != null && !Utils.isMatching(string, Utils.getOS())) {
            return false;
        }
        if (string2 != null && !Utils.isMatching(string2, Utils.getWS())) {
            return false;
        }
        if (string3 != null && !Utils.isMatching(string3, Utils.getArch())) {
            return false;
        }
        return string4 == null || Utils.isMatchingLocale(string4, Utils.getNL());
    }

    public static String getOS() {
        return Utils.getContext().getProperty(PROP_OS);
    }

    public static String getWS() {
        return Utils.getContext().getProperty(PROP_WS);
    }

    public static String getArch() {
        return Utils.getContext().getProperty(PROP_ARCH);
    }

    public static String getNL() {
        return Utils.getContext().getProperty(PROP_NL);
    }

    public static long getStateStamp() {
        ServiceReference serviceReference;
        BundleContext bundleContext = Utils.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((serviceReference = bundleContext.getServiceReference(clazz.getName())) == null) {
            return -1L;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)Utils.getContext().getService(serviceReference);
        return platformAdmin == null ? -1L : platformAdmin.getState(false).getTimeStamp();
    }

    public static Bundle getBundle(String string) {
        PackageAdmin packageAdmin;
        if (bundleTracker == null) {
            BundleContext bundleContext = Utils.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bundleTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            bundleTracker.open();
        }
        if ((packageAdmin = (PackageAdmin)bundleTracker.getService()) == null) {
            return null;
        }
        Bundle[] bundleArray = packageAdmin.getBundles(string, null);
        if (bundleArray == null) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            if ((bundleArray[n].getState() & 3) == 0) {
                return bundleArray[n];
            }
            ++n;
        }
        return null;
    }

    private static BundleContext getContext() {
        return ConfigurationActivator.getBundleContext();
    }

    public static Location getConfigurationLocation() {
        Filter filter = null;
        try {
            filter = Utils.getContext().createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        ServiceTracker serviceTracker = new ServiceTracker(Utils.getContext(), filter, null);
        serviceTracker.open();
        return (Location)serviceTracker.getService();
    }

    private static boolean isMatching(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(string)) {
            return true;
        }
        string2 = string2.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toUpperCase();
            if (string2.indexOf(string3) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatchingLocale(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(string)) {
            return true;
        }
        string2 = string2.toUpperCase();
        string = string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) == 0) {
                return true;
            }
            if (string3.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public static Locale getDefaultLocale() {
        String string = Utils.getNL();
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() == 1) {
            return new Locale(stringTokenizer.nextToken(), "");
        }
        if (stringTokenizer.countTokens() == 2) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 3) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        return Locale.getDefault();
    }

    public static String getResourceString(ResourceBundle resourceBundle, String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        if (string3.equals("")) {
            return string;
        }
        if (!string3.startsWith(KEY_PREFIX)) {
            return string;
        }
        if (string3.startsWith(KEY_DOUBLE_PREFIX)) {
            return string3.substring(1);
        }
        int n = string3.indexOf(" ");
        String string4 = n == -1 ? string3 : string3.substring(0, n);
        String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
        if (resourceBundle == null) {
            return string2;
        }
        try {
            return resourceBundle.getString(string4.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static boolean isAutomaticallyStartedBundle(String string) {
        if (string.indexOf(PI_OSGI) != -1) {
            return true;
        }
        String string2 = ConfigurationActivator.getBundleContext().getProperty("osgi.bundles");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(64);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            if (string3.startsWith("reference:file:") && string.indexOf((file = new File(string3.substring(15))).getName()) != -1) {
                return true;
            }
            if (string.indexOf(string3) == -1) continue;
            return true;
        }
        return false;
    }

    public static URL makeAbsolute(URL uRL, URL uRL2) {
        if (!"file".equals(uRL.getProtocol())) {
            return uRL2;
        }
        if (uRL2.getProtocol() != null && !uRL2.getProtocol().equals(uRL.getProtocol())) {
            return uRL2;
        }
        Path path = new Path(uRL2.getPath());
        if (path.isAbsolute()) {
            return uRL2;
        }
        try {
            IPath iPath = new Path(uRL.getPath()).append(uRL2.getPath());
            return iPath.toFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Utils.log(malformedURLException.getLocalizedMessage());
            return uRL2;
        }
    }

    public static URL makeRelative(URL uRL, URL uRL2) {
        if (uRL == null) {
            return uRL2;
        }
        if (!"file".equals(uRL.getProtocol())) {
            return uRL2;
        }
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return uRL2;
        }
        Path path = new Path(uRL2.getPath());
        if (!path.isAbsolute()) {
            return uRL2;
        }
        IPath iPath = Utils.makeRelative((IPath)new Path(uRL.getPath()), (IPath)path);
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), iPath.toString());
        }
        catch (MalformedURLException malformedURLException) {
            String string = malformedURLException.getMessage();
            if (string == null) {
                string = "";
            }
            Utils.log(Utils.newStatus(string, malformedURLException));
            return uRL2;
        }
    }

    public static IPath makeRelative(IPath iPath, IPath iPath2) {
        if (iPath2.getDevice() != null && !iPath2.getDevice().equalsIgnoreCase(iPath.getDevice())) {
            return iPath2;
        }
        int n = iPath.segmentCount();
        int n2 = iPath.matchingFirstSegments(iPath2);
        String string = "";
        int n3 = 0;
        while (n3 < n - n2) {
            string = String.valueOf(string) + "../";
            ++n3;
        }
        return new Path(string).append(iPath2.removeFirstSegments(n2));
    }

    public static String makeRelative(URL uRL, String string) {
        try {
            return Utils.makeRelative(uRL, new URL(string)).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static String canonicalizeURL(String string) {
        if (!isWindows || !string.startsWith("file:")) {
            return string;
        }
        try {
            String string2 = new URL(string).getPath();
            File file = new File(string2);
            string2 = file.toString().replace('\\', '/');
            if (Character.isUpperCase(string2.charAt(0))) {
                char[] cArray = string2.toCharArray();
                cArray[0] = Character.toLowerCase(cArray[0]);
                string2 = new String(cArray);
                return new File(string2).toURL().toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return string;
    }

    public static URL getInstallURL() {
        Filter filter = null;
        try {
            filter = Utils.getContext().createFilter(Location.INSTALL_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        ServiceTracker serviceTracker = new ServiceTracker(Utils.getContext(), filter, null);
        serviceTracker.open();
        Location location = (Location)serviceTracker.getService();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }
}

