/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.DefaultVariable;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class AdaptExpression
extends CompositeExpression {
    private static final String ATT_TYPE = "type";
    private static final int HASH_INITIAL;
    private String fTypeName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.AdaptExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public AdaptExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fTypeName = iConfigurationElement.getAttribute(ATT_TYPE);
        Expressions.checkAttribute(ATT_TYPE, this.fTypeName);
    }

    public AdaptExpression(String string) {
        Assert.isNotNull((Object)string);
        this.fTypeName = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AdaptExpression)) {
            return false;
        }
        AdaptExpression adaptExpression = (AdaptExpression)object;
        return this.fTypeName.equals(adaptExpression.fTypeName) && AdaptExpression.equals(this.fExpressions, adaptExpression.fExpressions);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + AdaptExpression.hashCode(this.fExpressions) * 89 + this.fTypeName.hashCode();
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.fTypeName == null) {
            return EvaluationResult.FALSE;
        }
        Object object = iEvaluationContext.getDefaultVariable();
        Object object2 = null;
        if (Expressions.isInstanceOf(object, this.fTypeName)) {
            object2 = object;
        } else {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            if (!iAdapterManager.hasAdapter(object, this.fTypeName)) {
                return EvaluationResult.FALSE;
            }
            object2 = iAdapterManager.getAdapter(object, this.fTypeName);
        }
        if (object2 == null) {
            return EvaluationResult.NOT_LOADED;
        }
        return this.evaluateAnd(new DefaultVariable(iEvaluationContext, object2));
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markDefaultVariableAccessed();
        super.collectExpressionInfo(expressionInfo);
    }
}

