/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.protocol.bundleentry.Handler;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BaseData
implements BundleData {
    private long id;
    private BaseAdaptor adaptor;
    private Bundle bundle;
    private int startLevel = -1;
    private int status = 0;
    private StorageHook[] storageHooks;
    private String location;
    private long lastModified;
    protected BundleFile bundleFile;
    private boolean dirty = false;
    protected Dictionary manifest;
    protected String fileName;
    private String symbolicName;
    private Version version;
    private String activator;
    private String classpath;
    private String executionEnvironment;
    private String dynamicImports;
    private int type;

    public BaseData(long l, BaseAdaptor baseAdaptor) {
        this.id = l;
        this.adaptor = baseAdaptor;
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, String[] stringArray) {
        ClassLoadingHook[] classLoadingHookArray = this.adaptor.getHookRegistry().getClassLoadingHooks();
        ClassLoader classLoader = this.adaptor.getBundleClassLoaderParent();
        BaseClassLoader baseClassLoader = null;
        int n = 0;
        while (n < classLoadingHookArray.length && baseClassLoader == null) {
            baseClassLoader = classLoadingHookArray[n].createClassLoader(classLoader, classLoaderDelegate, bundleProtectionDomain, this, stringArray);
            ++n;
        }
        if (baseClassLoader == null) {
            baseClassLoader = new DefaultClassLoader(classLoader, classLoaderDelegate, bundleProtectionDomain, this, stringArray);
        }
        return baseClassLoader;
    }

    public final URL getEntry(String string) {
        BundleEntry bundleEntry = this.getBundleFile().getEntry(string);
        if (bundleEntry == null) {
            return null;
        }
        if (string.length() == 0 || string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return new URL("bundleentry", Long.toString(this.id), 0, string, new Handler(bundleEntry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final Enumeration getEntryPaths(String string) {
        return this.getBundleFile().getEntryPaths(string);
    }

    public String findLibrary(String string) {
        ClassLoadingHook[] classLoadingHookArray = this.adaptor.getHookRegistry().getClassLoadingHooks();
        String string2 = null;
        int n = 0;
        while (n < classLoadingHookArray.length) {
            string2 = classLoadingHookArray[n].findLibrary(this, string);
            if (string2 != null) {
                return string2;
            }
            ++n;
        }
        return string2;
    }

    public void installNativeCode(String[] stringArray) throws BundleException {
        this.adaptor.getStorage().installNativeCode(this, stringArray);
    }

    public File getDataFile(String string) {
        return this.adaptor.getStorage().getDataFile(this, string);
    }

    public Dictionary getManifest() throws BundleException {
        if (this.manifest == null) {
            this.manifest = this.adaptor.getStorage().loadManifest(this);
        }
        return this.manifest;
    }

    public long getBundleID() {
        return this.id;
    }

    public final String getLocation() {
        return this.location;
    }

    public final void setLocation(String string) {
        this.location = string;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(long l) {
        this.lastModified = l;
    }

    public void close() throws IOException {
        if (this.bundleFile != null) {
            this.getBundleFile().close();
        }
    }

    public void open() throws IOException {
        this.getBundleFile().open();
    }

    public final void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public final Bundle getBundle() {
        return this.bundle;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStartLevel(int n) {
        this.startLevel = this.setPersistentData(n, true, this.startLevel);
    }

    public void setStatus(int n) {
        this.status = this.setPersistentData(n, false, this.status);
    }

    private int setPersistentData(int n, boolean bl, int n2) {
        StorageHook[] storageHookArray = this.getStorageHooks();
        int n3 = 0;
        while (n3 < storageHookArray.length) {
            if (bl ? storageHookArray[n3].forgetStartLevelChange(n) : storageHookArray[n3].forgetStatusChange(n)) {
                return n;
            }
            ++n3;
        }
        if (n != n2) {
            this.dirty = true;
        }
        return n;
    }

    public void save() throws IOException {
        this.adaptor.getStorage().save(this);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final void setSymbolicName(String string) {
        this.symbolicName = string;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(Version version) {
        this.version = version;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final String[] getClassPath() throws BundleException {
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader("Bundle-ClassPath", this.classpath);
        return BaseData.getClassPath(manifestElementArray);
    }

    public String getClassPathString() {
        return this.classpath;
    }

    public void setClassPathString(String string) {
        this.classpath = string;
    }

    public final String getActivator() {
        return this.activator;
    }

    public final void setActivator(String string) {
        this.activator = string;
    }

    public final String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String string) {
        this.executionEnvironment = string;
    }

    public final String getDynamicImports() {
        return this.dynamicImports;
    }

    public void setDynamicImports(String string) {
        this.dynamicImports = string;
    }

    public final boolean matchDNChain(String string) {
        StorageHook[] storageHookArray = this.getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length) {
            if (storageHookArray[n].matchDNChain(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final BaseAdaptor getAdaptor() {
        return this.adaptor;
    }

    public synchronized BundleFile getBundleFile() throws IllegalArgumentException {
        if (this.bundleFile == null) {
            try {
                this.bundleFile = this.adaptor.createBundleFile(null, this);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }
        return this.bundleFile;
    }

    private static String[] getClassPath(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> arrayList = new ArrayList<String>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  found classpath entry " + manifestElementArray[n].getValueComponents());
            }
            String[] stringArray = manifestElementArray[n].getValueComponents();
            int n2 = 0;
            while (n2 < stringArray.length) {
                arrayList.add(stringArray[n2]);
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public StorageHook getStorageHook(String string) {
        if (this.storageHooks == null) {
            return null;
        }
        int n = 0;
        while (n < this.storageHooks.length) {
            if (this.storageHooks[n].getKey().equals(string)) {
                return this.storageHooks[n];
            }
            ++n;
        }
        return null;
    }

    public void setStorageHooks(StorageHook[] storageHookArray) {
        if (this.storageHooks != null) {
            return;
        }
        this.storageHooks = storageHookArray;
    }

    public StorageHook[] getStorageHooks() {
        return this.storageHooks == null ? new StorageHook[]{} : this.storageHooks;
    }

    public File getExtractFile(String string) {
        return this.adaptor.getStorage().getExtractFile(this, string);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String toString() {
        String string = this.getSymbolicName();
        if (string == null) {
            return this.getLocation();
        }
        Version version = this.getVersion();
        if (version == null) {
            return string;
        }
        return String.valueOf(string) + "_" + version;
    }
}

