/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.NullURLStreamHandlerService;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerSetter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class URLStreamHandlerProxy
extends URLStreamHandler
implements ServiceTrackerCustomizer {
    protected URLStreamHandlerService realHandlerService;
    protected URLStreamHandlerSetter urlSetter;
    protected ServiceTracker urlStreamHandlerServiceTracker;
    protected boolean handlerRegistered = true;
    protected BundleContext context;
    protected ServiceReference urlStreamServiceReference;
    protected String protocol;
    protected int ranking = -1;

    public URLStreamHandlerProxy(String string, ServiceReference serviceReference, BundleContext bundleContext) {
        this.context = bundleContext;
        this.protocol = string;
        this.urlSetter = new URLStreamHandlerSetter(this);
        this.setNewHandler(serviceReference, this.getRank(serviceReference));
        this.urlStreamHandlerServiceTracker = new ServiceTracker(bundleContext, "org.osgi.service.url.URLStreamHandlerService", (ServiceTrackerCustomizer)this);
        StreamHandlerFactory.secureAction.open(this.urlStreamHandlerServiceTracker);
    }

    private void setNewHandler(ServiceReference serviceReference, int n) {
        this.urlStreamServiceReference = serviceReference;
        this.ranking = n;
        this.realHandlerService = (URLStreamHandlerService)StreamHandlerFactory.secureAction.getService(serviceReference, this.context);
    }

    protected boolean equals(URL uRL, URL uRL2) {
        return this.realHandlerService.equals(uRL, uRL2);
    }

    protected int getDefaultPort() {
        return this.realHandlerService.getDefaultPort();
    }

    protected InetAddress getHostAddress(URL uRL) {
        return this.realHandlerService.getHostAddress(uRL);
    }

    protected int hashCode(URL uRL) {
        return this.realHandlerService.hashCode(uRL);
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) {
        return this.realHandlerService.hostsEqual(uRL, uRL2);
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return this.realHandlerService.openConnection(uRL);
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        this.realHandlerService.parseURL(this.urlSetter, uRL, string, n, n2);
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        return this.realHandlerService.sameFile(uRL, uRL2);
    }

    protected String toExternalForm(URL uRL) {
        return this.realHandlerService.toExternalForm(uRL);
    }

    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        super.setURL(uRL, string, string2, n, string3, string4, string5, string6, string7);
    }

    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        super.setURL(uRL, string, string2, n, null, null, string3, null, string4);
    }

    public Object addingService(ServiceReference serviceReference) {
        Object object = serviceReference.getProperty("url.handler.protocol");
        if (!(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.protocol)) {
                int n2;
                Object object2 = serviceReference.getProperty("service.ranking");
                int n3 = n2 = object2 instanceof Integer ? (Integer)object2 : 0;
                if (!this.handlerRegistered) {
                    this.setNewHandler(serviceReference, n2);
                    this.handlerRegistered = true;
                }
                if (n2 > this.ranking) {
                    this.setNewHandler(serviceReference, n2);
                }
                return serviceReference;
            }
            ++n;
        }
        return null;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        int n = this.getRank(serviceReference);
        if (serviceReference == this.urlStreamServiceReference) {
            ServiceReference serviceReference2;
            if (n < this.ranking && (serviceReference2 = this.urlStreamHandlerServiceTracker.getServiceReference()) != this.urlStreamServiceReference && serviceReference2 != null) {
                this.setNewHandler(serviceReference2, (Integer)serviceReference2.getProperty("service.ranking"));
            }
        } else if (n > this.ranking) {
            this.setNewHandler(serviceReference, n);
        }
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        if (serviceReference == this.urlStreamServiceReference) {
            ServiceReference serviceReference2 = this.urlStreamHandlerServiceTracker.getServiceReference();
            if (serviceReference2 != null) {
                this.setNewHandler(serviceReference2, this.getRank(serviceReference2));
            } else {
                this.handlerRegistered = false;
                this.realHandlerService = new NullURLStreamHandlerService();
                this.ranking = -1;
            }
        }
    }

    private int getRank(ServiceReference serviceReference) {
        Object object = serviceReference.getProperty("service.ranking");
        return object instanceof Integer ? (Integer)object : 0;
    }
}

