/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.osgi.framework.BundleException;

public class SystemState
extends StateImpl {
    public synchronized boolean addBundle(BundleDescription bundleDescription) {
        if (!super.addBundle(bundleDescription)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    public synchronized boolean removeBundle(BundleDescription bundleDescription) {
        if (!super.removeBundle(bundleDescription)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    public synchronized boolean updateBundle(BundleDescription bundleDescription) {
        if (!super.updateBundle(bundleDescription)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    private void updateTimeStamp() {
        if (this.getTimeStamp() == Long.MAX_VALUE) {
            this.setTimeStamp(0L);
        }
        this.setTimeStamp(this.getTimeStamp() + 1L);
    }

    public StateDelta compare(State state) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public synchronized StateDelta resolve() {
        StateDelta stateDelta = super.resolve();
        if (stateDelta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return stateDelta;
    }

    public synchronized StateDelta resolve(boolean bl) {
        StateDelta stateDelta = super.resolve(bl);
        if (stateDelta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return stateDelta;
    }

    public synchronized StateDelta resolve(BundleDescription[] bundleDescriptionArray) {
        StateDelta stateDelta = super.resolve(bundleDescriptionArray);
        if (stateDelta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return stateDelta;
    }
}

