/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.verifier.Base64;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.DigestedInputStream;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class SignedBundleFile
extends BundleFile
implements CertificateVerifier {
    static MessageDigest md5;
    static MessageDigest sha1;
    private static final String MF_ENTRY_NEWLN_NAME = "\nName: ";
    private static final String MF_ENTRY_NAME = "Name: ";
    private static final String MF_DIGEST_PART = "-Digest: ";
    private static final String digestManifestSearch = "-Digest-Manifest: ";
    private static final int digestManifestSearchLen;
    private static final String[] EMPTY_STRING;
    private BundleFile bundleFile;
    CertificateChain[] chains;
    Hashtable digests4entries;
    Hashtable results4entries;
    String manifestSHAResult = null;
    String manifestMD5Result = null;
    boolean certsInitialized = false;

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        digestManifestSearchLen = digestManifestSearch.length();
        EMPTY_STRING = new String[0];
    }

    SignedBundleFile() {
    }

    SignedBundleFile(CertificateChain[] certificateChainArray, Hashtable hashtable, Hashtable hashtable2, String string, String string2) {
        this.chains = certificateChainArray;
        this.digests4entries = hashtable;
        this.results4entries = hashtable2;
        this.manifestMD5Result = string;
        this.manifestSHAResult = string2;
        this.certsInitialized = true;
    }

    private void populateManifest(byte[] byArray) {
        String string = new String(byArray);
        int n = string.indexOf(MF_ENTRY_NEWLN_NAME);
        while (n != -1 && n < string.length()) {
            String[] stringArray;
            int n2 = string.indexOf(MF_ENTRY_NEWLN_NAME, n + 1);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = this.getName(string2 = this.stripContinuations(string2));
            if (string3 != null && (stringArray = this.getDigestLines(string2)) != null) {
                MessageDigest[] messageDigestArray = this.getDigestList(stringArray);
                byte[][] byArray2 = this.getDigestResultsList(stringArray);
                if (messageDigestArray != null && byArray2 != null && messageDigestArray.length != byArray2.length) {
                    throw new RuntimeException("digest and digest results were different counts..");
                }
                if (string3 != null && messageDigestArray != null && byArray2 != null) {
                    if (this.digests4entries == null) {
                        this.digests4entries = new Hashtable(10);
                        this.results4entries = new Hashtable(10);
                    }
                    if (!this.digests4entries.contains(string3)) {
                        this.digests4entries.put(string3, messageDigestArray);
                        this.results4entries.put(string3, byArray2);
                    }
                }
            }
            n = n2;
        }
    }

    private String stripContinuations(String string) {
        if (string.indexOf("\n ") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf("\n ");
        int n2 = 0;
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n - 1));
            n2 = n + 2;
            int n3 = n = n + 2 < string.length() ? string.indexOf("\n ", n + 2) : -1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private String getName(String string) {
        int n = string.indexOf(MF_ENTRY_NAME);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(10, n);
        if (n2 == -1) {
            return null;
        }
        if (string.charAt(n2 - 1) == '\r') {
            --n2;
        }
        if ((n += MF_ENTRY_NAME.length()) >= n2) {
            return null;
        }
        return string.substring(n, n2);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getDigestLines(String var1_1) {
        var2_2 = new String[1];
        var3_3 = 0;
        var4_4 = var1_1.indexOf("-Digest: ");
        if (var4_4 != -1) ** GOTO lbl28
        return null;
lbl-1000:
        // 1 sources

        {
            var5_5 = var1_1.lastIndexOf(10, var4_4);
            if (var5_5 == -1) {
                return null;
            }
            var6_6 = var1_1.indexOf(10, var4_4);
            if (var6_6 == -1) {
                return null;
            }
            var7_7 = var6_6;
            if (var1_1.charAt(var7_7 - 1) == '\r') {
                --var7_7;
            }
            if ((var8_8 = var5_5 + 1) >= var7_7) {
                return null;
            }
            var9_9 = var1_1.substring(var8_8, var7_7);
            if (var9_9.startsWith("MD5") || var9_9.startsWith("SHA1")) {
                if (++var3_3 == 2) {
                    var10_10 = var2_2;
                    var2_2 = new String[]{var10_10[0], var9_9};
                } else if (var3_3 == 1) {
                    var2_2[0] = var9_9;
                } else {
                    return null;
                }
            }
            var4_4 = var1_1.indexOf("-Digest: ", var6_6);
lbl28:
            // 2 sources

            ** while (var4_4 != -1)
        }
lbl29:
        // 1 sources

        return var3_3 == 0 ? null : var2_2;
    }

    private MessageDigest[] getDigestList(String[] stringArray) {
        MessageDigest[] messageDigestArray = new MessageDigest[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf(MF_DIGEST_PART);
            String string2 = string.substring(0, n2);
            if (string2.equals("MD5")) {
                messageDigestArray[n] = md5;
            } else if (string2.equals("SHA1")) {
                messageDigestArray[n] = sha1;
            } else {
                messageDigestArray = null;
                break;
            }
            ++n;
        }
        return messageDigestArray;
    }

    private byte[][] getDigestResultsList(String[] stringArray) {
        byte[][] byArray = new byte[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf(MF_DIGEST_PART);
            if ((n2 += MF_DIGEST_PART.length()) >= string.length()) {
                byArray = null;
                break;
            }
            String string2 = string.substring(n2);
            try {
                byArray[n] = Base64.decode(string2.getBytes());
            }
            catch (Throwable throwable) {
                byArray = null;
                break;
            }
            ++n;
        }
        return byArray;
    }

    private static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, n2)) > 0) {
            n2 -= n;
            n3 += n;
        }
        return n3;
    }

    byte[] readIntoArray(BundleEntry bundleEntry) throws IOException {
        byte[] byArray;
        int n = (int)bundleEntry.getSize();
        InputStream inputStream = bundleEntry.getInputStream();
        int n2 = SignedBundleFile.readFully(inputStream, byArray = new byte[n]);
        if (n2 != n) {
            throw new IOException("Couldn't read all of " + bundleEntry.getName() + ": " + n2 + " != " + n);
        }
        return byArray;
    }

    void setBundleFile(BundleFile bundleFile) throws IOException {
        this.bundleFile = bundleFile;
        if (this.certsInitialized) {
            return;
        }
        ArrayList<PKCS7Processor> arrayList = new ArrayList<PKCS7Processor>();
        BundleEntry bundleEntry = bundleFile.getEntry("META-INF/MANIFEST.MF");
        if (bundleEntry == null) {
            return;
        }
        byte[] byArray = this.readIntoArray(bundleEntry);
        Enumeration enumeration = bundleFile.getEntryPaths("META-INF/");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".DSA") && !string.endsWith(".RSA") || string.indexOf(47) != string.lastIndexOf(47)) continue;
            bundleEntry = bundleFile.getEntry(string);
            byte[] byArray2 = this.readIntoArray(bundleEntry);
            int n = string.lastIndexOf(46);
            bundleEntry = bundleFile.getEntry(String.valueOf(string.substring(0, n)) + ".SF");
            byte[] byArray3 = this.readIntoArray(bundleEntry);
            if (!this.checkManifestDigest(byArray, byArray3)) continue;
            PKCS7Processor pKCS7Processor = null;
            try {
                pKCS7Processor = new PKCS7Processor(byArray2, 0, byArray2.length, byArray3, 0, byArray3.length);
            }
            catch (Exception exception) {
                SignedBundleHook.log("Invalid or untrusted certificate: " + bundleFile.getBaseFile(), 2, exception);
                continue;
            }
            if (pKCS7Processor == null || pKCS7Processor.getSigner() == null) continue;
            arrayList.add(pKCS7Processor);
        }
        CertificateChain[] certificateChainArray = this.chains = arrayList.size() == 0 ? null : arrayList.toArray(new CertificateChain[arrayList.size()]);
        if (this.chains != null) {
            this.populateManifest(byArray);
        }
    }

    private boolean checkManifestDigest(byte[] byArray, byte[] byArray2) {
        String string = new String(byArray2);
        string = this.stripContinuations(string);
        boolean bl = false;
        int n = string.indexOf(digestManifestSearch);
        while (n != -1) {
            int n2 = string.lastIndexOf(10, n);
            String string2 = null;
            if (n2 != -1) {
                String string3 = string.substring(n2 + 1, n);
                if (string3.equals("MD5")) {
                    if (this.manifestMD5Result == null) {
                        this.manifestMD5Result = this.calculateDigest(md5, byArray);
                    }
                    string2 = this.manifestMD5Result;
                } else if (string3.equals("SHA1")) {
                    if (this.manifestSHAResult == null) {
                        this.manifestSHAResult = this.calculateDigest(sha1, byArray);
                    }
                    string2 = this.manifestSHAResult;
                }
                if (string2 == null || !string.startsWith(string2, n += digestManifestSearchLen)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            n = string.indexOf(digestManifestSearch, n);
        }
        return bl;
    }

    private String calculateDigest(MessageDigest messageDigest, byte[] byArray) {
        String string;
        try {
            messageDigest = (MessageDigest)messageDigest.clone();
            string = new String(Base64.encode(messageDigest.digest(byArray)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(String.valueOf(messageDigest.getAlgorithm()) + " doesn't support clone()");
        }
        return string;
    }

    public static void main(String[] stringArray) throws IOException {
        CertificateChain[] certificateChainArray;
        ZipBundleFile zipBundleFile = new ZipBundleFile(new File(stringArray[0]), null);
        SignedBundleFile signedBundleFile = new SignedBundleFile();
        signedBundleFile.setBundleFile(zipBundleFile);
        Enumeration enumeration = signedBundleFile.getEntryPaths("/");
        while (enumeration.hasMoreElements()) {
            certificateChainArray = (CertificateChain[])enumeration.nextElement();
            System.out.println("main(): " + (String)certificateChainArray);
            if (certificateChainArray.indexOf(47) != -1) continue;
            BundleEntry bundleEntry = signedBundleFile.getEntry((String)certificateChainArray);
            InputStream inputStream = bundleEntry.getInputStream();
            inputStream.skip(bundleEntry.getSize());
            inputStream.read();
            inputStream.close();
        }
        if (!signedBundleFile.isSigned()) {
            System.out.println("No signers present");
        } else {
            certificateChainArray = signedBundleFile.getChains();
            int n = 0;
            while (n < certificateChainArray.length) {
                System.out.println(certificateChainArray[n].getChain());
                ++n;
            }
        }
        System.out.println("Done");
    }

    public File getFile(String string, boolean bl) {
        return this.bundleFile.getFile(string, bl);
    }

    public BundleEntry getEntry(String string) {
        BundleEntry bundleEntry = this.bundleFile.getEntry(string);
        if (bundleEntry == null) {
            if (this.digests4entries != null && this.digests4entries.get(string) == null) {
                return null;
            }
            throw new RuntimeException("A file has been removed from the bundle: " + this.getBaseFile().toString() + " : " + string);
        }
        if (bundleEntry.getName().startsWith("META-INF/")) {
            return bundleEntry;
        }
        if (!this.isSigned()) {
            return bundleEntry;
        }
        return new SignedBundleEntry(bundleEntry);
    }

    public Enumeration getEntryPaths(String string) {
        return this.bundleFile.getEntryPaths(string);
    }

    public void close() throws IOException {
        this.bundleFile.close();
    }

    public void open() throws IOException {
        this.bundleFile.open();
    }

    public boolean containsDir(String string) {
        return this.bundleFile.containsDir(string);
    }

    boolean matchDNChain(String string) {
        CertificateChain[] certificateChainArray = this.getChains();
        int n = 0;
        while (n < certificateChainArray.length) {
            if (certificateChainArray[n].isTrusted() && DNChainMatching.match(certificateChainArray[n].getChain(), string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public File getBaseFile() {
        return this.bundleFile.getBaseFile();
    }

    public String[] verifyContent() {
        if (!this.isSigned()) {
            return EMPTY_STRING;
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        Enumeration enumeration = this.digests4entries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            BundleEntry bundleEntry = this.getEntry(string);
            if (bundleEntry == null) {
                arrayList.add(string);
                continue;
            }
            try {
                bundleEntry.getBytes();
            }
            catch (IOException iOException) {
                arrayList.add(string);
            }
        }
        return arrayList.size() == 0 ? EMPTY_STRING : arrayList.toArray(new String[arrayList.size()]);
    }

    public CertificateChain[] getChains() {
        if (!this.isSigned()) {
            return new CertificateChain[0];
        }
        return this.chains;
    }

    public boolean isSigned() {
        return this.chains != null;
    }

    class SignedBundleEntry
    extends BundleEntry {
        BundleEntry nestedEntry;

        SignedBundleEntry(BundleEntry bundleEntry) {
            this.nestedEntry = bundleEntry;
        }

        public InputStream getInputStream() throws IOException {
            MessageDigest[] messageDigestArray;
            String string = this.getName();
            MessageDigest[] messageDigestArray2 = messageDigestArray = SignedBundleFile.this.digests4entries == null ? null : (MessageDigest[])SignedBundleFile.this.digests4entries.get(string);
            if (messageDigestArray == null) {
                return null;
            }
            byte[][] byArray = (byte[][])SignedBundleFile.this.results4entries.get(string);
            return new DigestedInputStream(this.nestedEntry.getInputStream(), messageDigestArray, byArray, this.nestedEntry.getSize());
        }

        public long getSize() {
            return this.nestedEntry.getSize();
        }

        public String getName() {
            return this.nestedEntry.getName();
        }

        public long getTime() {
            return this.nestedEntry.getTime();
        }

        public URL getLocalURL() {
            return this.nestedEntry.getLocalURL();
        }

        public URL getFileURL() {
            return this.nestedEntry.getFileURL();
        }
    }
}

