/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.eclipse.osgi.internal.verifier.SignedStorageHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public class SignedBundleHook
implements AdaptorHook,
BundleFileWrapperFactoryHook,
HookConfigurator,
CertificateVerifierFactory {
    private static BaseAdaptor ADAPTOR;
    private static String SIGNED_BUNDLE_SUPPORT;
    private static boolean supportSignedBundles;
    private ServiceRegistration reg;
    static /* synthetic */ Class class$0;

    static {
        SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
        supportSignedBundles = false;
    }

    public boolean matchDNChain(String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (DNChainMatching.match(stringArray[n], string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        ADAPTOR = baseAdaptor;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.reg = bundleContext.registerService(clazz.getName(), (Object)this, null);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object object, BaseData baseData, boolean bl) {
        try {
            if (bundleFile != null) {
                SignedStorageHook signedStorageHook = (SignedStorageHook)baseData.getStorageHook(SignedStorageHook.KEY);
                SignedBundleFile signedBundleFile = bl && signedStorageHook != null && signedStorageHook.signedBundleFile != null ? signedStorageHook.signedBundleFile : new SignedBundleFile();
                signedBundleFile.setBundleFile(bundleFile);
                if (signedBundleFile.isSigned()) {
                    bundleFile = signedBundleFile;
                }
            }
        }
        catch (IOException iOException) {}
        return bundleFile;
    }

    public void addHooks(HookRegistry hookRegistry) {
        supportSignedBundles = "true".equals(FrameworkProperties.getProperty(SIGNED_BUNDLE_SUPPORT));
        hookRegistry.addAdaptorHook(this);
        if (supportSignedBundles) {
            hookRegistry.addStorageHook(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    public CertificateVerifier getVerifier(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null content");
        }
        BundleFile bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, null);
        SignedBundleFile signedBundleFile = new SignedBundleFile();
        signedBundleFile.setBundleFile(bundleFile);
        return signedBundleFile;
    }

    public CertificateVerifier getVerifier(Bundle bundle) throws IOException {
        BundleData bundleData = ((AbstractBundle)bundle).getBundleData();
        if (!(bundleData instanceof BaseData)) {
            throw new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        BundleFile bundleFile = ((BaseData)bundleData).getBundleFile();
        if (bundleFile instanceof SignedBundleFile) {
            return (SignedBundleFile)bundleFile;
        }
        return this.getVerifier(bundleFile.getBaseFile());
    }

    static void log(String string, int n, Throwable throwable) {
        if (ADAPTOR == null) {
            System.err.println(string);
            throwable.printStackTrace();
            return;
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", n, 0, string, 0, throwable, null);
        ADAPTOR.getFrameworkLog().log(frameworkLogEntry);
    }
}

