/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private Tracked tracked;
    private volatile int trackingCount = -1;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;

    public ServiceTracker(BundleContext bundleContext, ServiceReference serviceReference, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = serviceReference;
        this.trackClass = null;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(service.id=" + serviceReference.getProperty("service.id").toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
    }

    public ServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = string;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(objectClass=" + string.toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
    }

    public ServiceTracker(BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = null;
        this.listenerFilter = null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer2 = this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        if (bundleContext == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(boolean bl) {
        if (this.tracked != null) {
            return;
        }
        this.tracked = bl ? new AllTracked() : new Tracked();
        this.trackingCount = 0;
        Tracked tracked = this.tracked;
        synchronized (tracked) {
            try {
                this.context.addServiceListener(this.tracked, this.listenerFilter);
                ServiceReference[] serviceReferenceArray = this.listenerFilter == null ? this.getInitialReferences(bl, null, this.filter.toString()) : (this.trackClass == null ? new ServiceReference[]{this.trackReference} : this.getInitialReferences(bl, this.trackClass, null));
                this.tracked.setInitialServices(serviceReferenceArray);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            }
        }
        this.tracked.trackInitialServices();
    }

    private ServiceReference[] getInitialReferences(boolean bl, String string, String string2) throws InvalidSyntaxException {
        if (bl) {
            return this.context.getAllServiceReferences(string, string2);
        }
        return this.context.getServiceReferences(string, string2);
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        Tracked tracked = this.tracked;
        this.tracked = null;
        try {
            this.context.removeServiceListener(tracked);
        }
        catch (IllegalStateException illegalStateException) {}
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                tracked.untrack(serviceReferenceArray[n]);
                ++n;
            }
        }
        this.trackingCount = -1;
    }

    public Object addingService(ServiceReference serviceReference) {
        return this.context.getService(serviceReference);
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.context.ungetService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(l);
                }
            }
            object = this.getService();
            if (l <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            block6: {
                n = tracked.size();
                if (n != 0) break block6;
                return null;
            }
            ServiceReference[] serviceReferenceArray = new ServiceReference[n];
            Enumeration enumeration = tracked.keys();
            int n2 = 0;
            while (n2 < n) {
                serviceReferenceArray[n2] = (ServiceReference)enumeration.nextElement();
                ++n2;
            }
            return serviceReferenceArray;
        }
    }

    public ServiceReference getServiceReference() {
        int n;
        ServiceReference serviceReference = this.cachedReference;
        if (serviceReference != null) {
            return serviceReference;
        }
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
        if (n == 0) {
            return null;
        }
        int n3 = 0;
        if (n > 1) {
            int n4;
            int[] nArray = new int[n];
            int n5 = 0;
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n7 < n) {
                Object object = serviceReferenceArray[n7].getProperty("service.ranking");
                nArray[n7] = n4 = object instanceof Integer ? (Integer)object : 0;
                if (n4 > n6) {
                    n3 = n7;
                    n6 = n4;
                    n5 = 1;
                } else if (n4 == n6) {
                    ++n5;
                }
                ++n7;
            }
            if (n5 > 1) {
                long l = Long.MAX_VALUE;
                n4 = 0;
                while (n4 < n) {
                    long l2;
                    if (nArray[n4] == n6 && (l2 = ((Long)serviceReferenceArray[n4].getProperty("service.id")).longValue()) < l) {
                        n3 = n4;
                        l = l2;
                    }
                    ++n4;
                }
            }
        }
        this.cachedReference = serviceReferenceArray[n3];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.get(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            ServiceReference[] serviceReferenceArray;
            block6: {
                serviceReferenceArray = this.getServiceReferences();
                int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
                if (n != 0) break block6;
                return null;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.getService(serviceReferenceArray[n3]);
                ++n3;
            }
            return objectArray;
        }
    }

    public Object getService() {
        Object object = this.cachedService;
        if (object != null) {
            return object;
        }
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        this.cachedService = this.getService(serviceReference);
        return this.cachedService;
    }

    public void remove(ServiceReference serviceReference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(serviceReference);
    }

    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    public int getTrackingCount() {
        return this.trackingCount;
    }

    void modified() {
        ++this.trackingCount;
        this.cachedReference = null;
        this.cachedService = null;
    }

    protected void finalize() throws Throwable {
    }

    class Tracked
    extends Hashtable
    implements ServiceListener {
        static final long serialVersionUID = -7420065199791006079L;
        private ArrayList adding = new ArrayList(6);
        private volatile boolean closed = false;
        private LinkedList initial = new LinkedList();

        protected Tracked() {
        }

        protected void setInitialServices(ServiceReference[] serviceReferenceArray) {
            if (serviceReferenceArray == null) {
                return;
            }
            int n = serviceReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.initial.add(serviceReferenceArray[n2]);
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void trackInitialServices() {
            while (true) {
                ServiceReference serviceReference;
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.initial.size() == 0) {
                        return;
                    }
                    serviceReference = (ServiceReference)this.initial.removeFirst();
                    if (this.get(serviceReference) != null) {
                        continue;
                    }
                    if (this.adding.contains(serviceReference)) {
                        continue;
                    }
                    this.adding.add(serviceReference);
                }
                this.trackAdding(serviceReference);
            }
        }

        protected void close() {
            this.closed = true;
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            if (this.closed) {
                return;
            }
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            switch (serviceEvent.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(serviceReference);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(serviceReference)) {
                        this.track(serviceReference);
                        break;
                    }
                    this.untrack(serviceReference);
                    break;
                }
                case 4: {
                    this.untrack(serviceReference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void track(ServiceReference serviceReference) {
            Object v;
            Tracked tracked = this;
            synchronized (tracked) {
                v = this.get(serviceReference);
            }
            if (v != null) {
                ServiceTracker.this.customizer.modifiedService(serviceReference, v);
                return;
            }
            tracked = this;
            synchronized (tracked) {
                if (this.adding.contains(serviceReference)) {
                    return;
                }
                this.adding.add(serviceReference);
            }
            this.trackAdding(serviceReference);
        }

        /*
         * Exception decompiling
         */
        private void trackAdding(ServiceReference var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 86->89)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(ServiceReference serviceReference) {
            Object v;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.initial.remove(serviceReference)) {
                    return;
                }
                if (this.adding.remove(serviceReference)) {
                    return;
                }
                v = this.remove(serviceReference);
                if (v == null) {
                    return;
                }
                ServiceTracker.this.modified();
            }
            ServiceTracker.this.customizer.removedService(serviceReference, v);
        }
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        static final long serialVersionUID = 4050764875305137716L;

        protected AllTracked() {
        }
    }
}

