/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;

public class EclipseEnvironmentInfo
implements EnvironmentInfo {
    private static EclipseEnvironmentInfo singleton;
    private static String nl;
    private static String os;
    private static String ws;
    private static String arch;
    static String[] allArgs;
    static String[] frameworkArgs;
    static String[] appArgs;
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static final String INTERNAL_AMD64 = "amd64";

    private EclipseEnvironmentInfo() {
        EclipseEnvironmentInfo.setupSystemContext();
    }

    public static EclipseEnvironmentInfo getDefault() {
        if (singleton == null) {
            singleton = new EclipseEnvironmentInfo();
        }
        return singleton;
    }

    public boolean inDevelopmentMode() {
        return FrameworkProperties.getProperty("osgi.dev") != null;
    }

    public boolean inDebugMode() {
        return FrameworkProperties.getProperty("osgi.debug") != null;
    }

    public String[] getCommandLineArgs() {
        return allArgs;
    }

    public String[] getFrameworkArgs() {
        return frameworkArgs;
    }

    public String[] getNonFrameworkArgs() {
        return appArgs;
    }

    public String getOSArch() {
        return arch;
    }

    public String getNL() {
        return nl;
    }

    public String getOS() {
        return os;
    }

    public String getWS() {
        return ws;
    }

    private static void setupSystemContext() {
        Object object;
        nl = FrameworkProperties.getProperty("osgi.nl");
        if (nl != null) {
            object = new StringTokenizer(nl, "_");
            int n = ((StringTokenizer)object).countTokens();
            try {
                Locale locale = null;
                switch (n) {
                    case 1: {
                        locale = new Locale(((StringTokenizer)object).nextToken(), "");
                        break;
                    }
                    case 2: {
                        locale = new Locale(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
                        break;
                    }
                    case 3: {
                        locale = new Locale(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
                        break;
                    }
                    default: {
                        System.err.println(NLS.bind(EclipseAdaptorMsg.error_badNL, nl));
                        locale = Locale.getDefault();
                    }
                }
                Locale.setDefault(locale);
                FrameworkProperties.setProperty("osgi.nl.user", nl);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nl = Locale.getDefault().toString();
        FrameworkProperties.setProperty("osgi.nl", nl);
        os = FrameworkProperties.getProperty("osgi.os");
        if (os == null) {
            os = EclipseEnvironmentInfo.guessOS(FrameworkProperties.getProperty("os.name"));
            FrameworkProperties.setProperty("osgi.os", os);
        }
        if ((ws = FrameworkProperties.getProperty("osgi.ws")) == null) {
            ws = EclipseEnvironmentInfo.guessWS(os);
            FrameworkProperties.setProperty("osgi.ws", ws);
        }
        if ((arch = FrameworkProperties.getProperty("osgi.arch")) == null) {
            object = FrameworkProperties.getProperty("os.arch");
            arch = ((String)object).equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : (((String)object).equalsIgnoreCase(INTERNAL_AMD64) ? "x86_64" : object);
            FrameworkProperties.setProperty("osgi.arch", arch);
        }
    }

    public static void setAllArgs(String[] stringArray) {
        if (allArgs == null) {
            allArgs = stringArray;
        }
    }

    public static void setAppArgs(String[] stringArray) {
        if (appArgs == null) {
            appArgs = stringArray;
        }
    }

    public static void setFrameworkArgs(String[] stringArray) {
        if (frameworkArgs == null) {
            frameworkArgs = stringArray;
        }
    }

    public static String guessWS(String string) {
        if (string.equals("win32")) {
            return "win32";
        }
        if (string.equals("linux")) {
            return "motif";
        }
        if (string.equals("macosx")) {
            return "carbon";
        }
        if (string.equals("hpux")) {
            return "motif";
        }
        if (string.equals("aix")) {
            return "motif";
        }
        if (string.equals("solaris")) {
            return "motif";
        }
        if (string.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    public static String guessOS(String string) {
        if (string.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            return "solaris";
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            return "linux";
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            return "qnx";
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            return "aix";
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            return "hpux";
        }
        if (string.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            return "macosx";
        }
        return "unknown";
    }
}

