/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.net.URL;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class EclipseLazyStarter
implements ClassLoadingStatsHook,
HookConfigurator {
    public void preFindLocalClass(String string, ClasspathManager classpathManager) throws ClassNotFoundException {
        AbstractBundle abstractBundle = (AbstractBundle)classpathManager.getBaseData().getBundle();
        if ((abstractBundle.getState() & 0x31) != 0) {
            return;
        }
        EclipseStorageHook eclipseStorageHook = (EclipseStorageHook)classpathManager.getBaseData().getStorageHook(EclipseStorageHook.KEY);
        if (!this.shouldActivateFor(string, classpathManager.getBaseData(), eclipseStorageHook)) {
            return;
        }
        if (abstractBundle.getState() == 8) {
            if (abstractBundle.testStateChanging(Thread.currentThread()) || abstractBundle.testStateChanging(null)) {
                return;
            }
            if (!abstractBundle.testStateChanging(Thread.currentThread())) {
                long l;
                Thread thread = abstractBundle.getStateChanging();
                if (StatsManager.TRACE_BUNDLES && thread != null) {
                    System.out.println("Concurrent startup of bundle " + abstractBundle.getSymbolicName() + " by " + Thread.currentThread() + " and " + thread.getName() + ". Waiting up to 5000ms for " + thread + " to finish the initialization.");
                }
                long l2 = System.currentTimeMillis();
                long l3 = l = 5000L;
                while (true) {
                    try {
                        Thread.sleep(100L);
                        if (abstractBundle.testStateChanging(null) || l3 <= 0L) {
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    l3 = l2 + l - System.currentTimeMillis();
                }
                if (l3 <= 0L || abstractBundle.getState() != 32) {
                    String string2 = abstractBundle.getSymbolicName() == null ? Long.toString(abstractBundle.getBundleId()) : abstractBundle.getSymbolicName();
                    String string3 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread().getName(), string, thread.getName(), string2, Long.toString(l)});
                    classpathManager.getBaseData().getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string3, 0, new Exception(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_GENERATED_EXCEPTION), null));
                }
                return;
            }
        }
        try {
            if (eclipseStorageHook != null) {
                eclipseStorageHook.setActivatedOnClassLoad(true);
            }
            abstractBundle.start();
        }
        catch (BundleException bundleException) {
            String string4 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ACTIVATION, abstractBundle.getSymbolicName(), Long.toString(abstractBundle.getBundleId()));
            classpathManager.getBaseData().getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string4, 0, bundleException, null));
            throw new ClassNotFoundException(string, bundleException);
        }
    }

    public void postFindLocalClass(String string, Class clazz, ClasspathManager classpathManager) {
    }

    public void preFindLocalResource(String string, ClasspathManager classpathManager) {
    }

    public void postFindLocalResource(String string, URL uRL, ClasspathManager classpathManager) {
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    private boolean shouldActivateFor(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook) throws ClassNotFoundException {
        BundleStopper bundleStopper;
        if (!this.isAutoStartable(string, baseData, eclipseStorageHook)) {
            return false;
        }
        if (baseData.getAdaptor().isStopping() && (bundleStopper = EclipseStorageHook.getBundleStopper(baseData)) != null && bundleStopper.isStopped(baseData.getBundle())) {
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ALREADY_STOPPED, string, baseData.getSymbolicName());
            throw new ClassNotFoundException(string2);
        }
        return true;
    }

    private boolean isAutoStartable(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook) {
        if (eclipseStorageHook == null) {
            return false;
        }
        boolean bl = eclipseStorageHook.isAutoStart();
        String[] stringArray = eclipseStorageHook.getAutoStartExceptions();
        if (stringArray == null) {
            return bl;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return bl;
        }
        String string2 = string.substring(0, n);
        return bl ^ this.contains(stringArray, string2);
    }

    private boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingStatsHook(this);
    }
}

