/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.event.BatchBundleListener;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilteredServiceListener;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    public static final String PROP_SCOPE_SERVICE_EVENTS = "osgi.scopeServiceEvents";
    public static final boolean scopeEvents = Boolean.valueOf(FrameworkProperties.getProperty("osgi.scopeServiceEvents", "true"));
    private boolean valid;
    protected BundleHost bundle;
    protected Framework framework;
    protected Hashtable servicesInUse;
    protected EventListeners bundleEvent;
    protected EventListeners bundleEventSync;
    protected EventListeners serviceEvent;
    protected EventListeners frameworkEvent;
    protected BundleActivator activator;
    protected Object contextLock = new Object();

    protected BundleContextImpl(BundleHost bundleHost) {
        this.bundle = bundleHost;
        this.valid = true;
        this.framework = bundleHost.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.serviceEvent = null;
        this.frameworkEvent = null;
        this.servicesInUse = null;
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        if (this.serviceEvent != null) {
            this.framework.serviceEvent.removeListener(this);
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.framework.frameworkEvent.removeListener(this);
            this.frameworkEvent = null;
        }
        if (this.bundleEvent != null) {
            this.framework.bundleEvent.removeListener(this);
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.framework.bundleEventSync.removeListener(this);
            this.bundleEventSync = null;
        }
        ServiceReference[] serviceReferenceArray = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            serviceReferenceArray = this.framework.serviceRegistry.lookupServiceReferences(this);
        }
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                try {
                    ((ServiceReferenceImpl)serviceReferenceArray[n]).registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
                ++n;
            }
        }
        if (this.servicesInUse != null) {
            int n;
            ServiceReference[] serviceReferenceArray2 = null;
            Hashtable hashtable = this.servicesInUse;
            synchronized (hashtable) {
                n = this.servicesInUse.size();
                if (n > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("Releasing services");
                    }
                    serviceReferenceArray2 = new ServiceReference[n];
                    Enumeration enumeration = this.servicesInUse.keys();
                    int n2 = 0;
                    while (n2 < n) {
                        serviceReferenceArray2[n2] = (ServiceReference)enumeration.nextElement();
                        ++n2;
                    }
                }
            }
            int n3 = 0;
            while (n3 < n) {
                ((ServiceReferenceImpl)serviceReferenceArray2[n3]).registration.releaseService(this);
                ++n3;
            }
            this.servicesInUse = null;
        }
        this.bundle = null;
    }

    public String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return this.framework.getProperty(string);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public Bundle installBundle(String string) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(string);
    }

    public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(string, inputStream);
    }

    public Bundle getBundle(long l) {
        return this.framework.getBundle(l);
    }

    public AbstractBundle getBundleByLocation(String string) {
        return this.framework.getBundleByLocation(string);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(serviceListener.hashCode());
            Debug.println("addServiceListener[" + this.bundle + "](" + (String)object + ", \"" + string + "\")");
        }
        object = new FilteredServiceListener(string, serviceListener, this);
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            if (this.serviceEvent == null) {
                this.serviceEvent = new EventListeners();
                this.framework.serviceEvent.addListener(this, this);
            }
            this.serviceEvent.addListener(serviceListener, object);
        }
    }

    public void addServiceListener(ServiceListener serviceListener) {
        block2: {
            try {
                this.addServiceListener(serviceListener, null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + invalidSyntaxException.getMessage());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener serviceListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(serviceListener.hashCode());
            Debug.println("removeServiceListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (this.serviceEvent != null) {
            object = this.framework.serviceEvent;
            synchronized (object) {
                this.serviceEvent.removeListener(serviceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(bundleListener.hashCode());
            Debug.println("addBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            object = this.framework.bundleEventSync;
            synchronized (object) {
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new EventListeners();
                    this.framework.bundleEventSync.addListener(this, this);
                }
                this.bundleEventSync.addListener(bundleListener, bundleListener);
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent == null) {
                this.bundleEvent = new EventListeners();
                this.framework.bundleEvent.addListener(this, this);
            }
            this.bundleEvent.addListener(bundleListener, bundleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(bundleListener.hashCode());
            Debug.println("removeBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            if (this.bundleEventSync != null) {
                object = this.framework.bundleEventSync;
                synchronized (object) {
                    this.bundleEventSync.removeListener(bundleListener);
                }
            }
        } else if (this.bundleEvent != null) {
            object = this.framework.bundleEvent;
            synchronized (object) {
                this.bundleEvent.removeListener(bundleListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(frameworkListener.hashCode());
            Debug.println("addFrameworkListener[" + this.bundle + "](" + (String)object + ")");
        }
        object = this.framework.frameworkEvent;
        synchronized (object) {
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new EventListeners();
                this.framework.frameworkEvent.addListener(this, this);
            }
            this.frameworkEvent.addListener(frameworkListener, frameworkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener frameworkListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(frameworkListener.hashCode());
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (this.frameworkEvent != null) {
            object = this.framework.frameworkEvent;
            synchronized (object) {
                this.frameworkEvent.removeListener(frameworkListener);
            }
        }
    }

    public ServiceRegistration registerService(String[] stringArray, Object object, Dictionary dictionary) {
        String string;
        this.checkValid();
        if (object == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new NullPointerException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int n = stringArray.length;
        if (n == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = new String(stringArray[n2].getBytes());
            ++n2;
        }
        stringArray = stringArray2;
        this.framework.checkRegisterServicePermission(stringArray);
        if (!(object instanceof ServiceFactory) && (string = BundleContextImpl.checkServiceClass(stringArray, object)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + string);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, string));
        }
        return this.createServiceRegistration(stringArray, object, dictionary);
    }

    static String checkServiceClass(String[] stringArray, final Object object) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return object.getClass().getClassLoader();
            }
        });
        int n = 0;
        while (n < stringArray.length) {
            block4: {
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = classLoader == null ? Class.forName(stringArray[n]) : classLoader.loadClass(stringArray[n]);
                    if (!clazz.isInstance(object)) {
                        return stringArray[n];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!BundleContextImpl.extensiveCheckServiceClass(stringArray[n], object.getClass())) break block4;
                    return stringArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String string, Class clazz) {
        if (string.equals(clazz.getName())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (!BundleContextImpl.extensiveCheckServiceClass(string, classArray[n])) {
                return false;
            }
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        return clazz2 == null || BundleContextImpl.extensiveCheckServiceClass(string, clazz2);
    }

    protected ServiceRegistrationImpl createServiceRegistration(String[] stringArray, Object object, Dictionary dictionary) {
        return new ServiceRegistrationImpl(this, stringArray, object, dictionary);
    }

    public ServiceRegistration registerService(String string, Object object, Dictionary dictionary) {
        String[] stringArray = new String[]{string};
        return this.registerService(stringArray, object, dictionary);
    }

    public ServiceReference[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getServiceReferences(" + string + ", \"" + string2 + "\")");
        }
        return this.framework.getServiceReferences(string, string2, this, false);
    }

    public ServiceReference[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getAllServiceReferences(" + string + ", \"" + string2 + "\")");
        }
        return this.framework.getServiceReferences(string, string2, this, true);
    }

    public ServiceReference getServiceReference(String string) {
        block12: {
            this.checkValid();
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + string + ")");
            }
            try {
                ServiceReference[] serviceReferenceArray = this.framework.getServiceReferences(string, null, this, false);
                if (serviceReferenceArray != null) {
                    int n = 0;
                    int n2 = serviceReferenceArray.length;
                    if (n2 > 1) {
                        int[] nArray = new int[n2];
                        int n3 = 0;
                        int n4 = Integer.MIN_VALUE;
                        int n5 = 0;
                        while (n5 < n2) {
                            int n6;
                            nArray[n5] = n6 = ((ServiceReferenceImpl)serviceReferenceArray[n5]).getRanking();
                            if (n6 > n4) {
                                n = n5;
                                n4 = n6;
                                n3 = 1;
                            } else if (n6 == n4) {
                                ++n3;
                            }
                            ++n5;
                        }
                        if (n3 > 1) {
                            long l = Long.MAX_VALUE;
                            int n7 = 0;
                            while (n7 < n2) {
                                long l2;
                                if (nArray[n7] == n4 && (l2 = ((ServiceReferenceImpl)serviceReferenceArray[n7]).getId()) < l) {
                                    n = n7;
                                    l = l2;
                                }
                                ++n7;
                            }
                        }
                    }
                    return serviceReferenceArray[n];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block12;
                Debug.println("InvalidSyntaxException w/ null filter" + invalidSyntaxException.getMessage());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        Object object;
        this.checkValid();
        if (this.servicesInUse == null) {
            object = this.contextLock;
            synchronized (object) {
                if (this.servicesInUse == null) {
                    this.servicesInUse = new Hashtable(10);
                }
            }
        }
        object = ((ServiceReferenceImpl)serviceReference).registration;
        this.framework.checkGetServicePermission(((ServiceRegistrationImpl)object).clazzes);
        return ((ServiceRegistrationImpl)object).getService(this);
    }

    public boolean ungetService(ServiceReference serviceReference) {
        this.checkValid();
        ServiceRegistrationImpl serviceRegistrationImpl = ((ServiceReferenceImpl)serviceReference).registration;
        return serviceRegistrationImpl.ungetService(this);
    }

    public File getDataFile(String string) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, string);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException bundleException) {
                this.activator = null;
                throw bundleException;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void startActivator(BundleActivator var1_1) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 161->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (BundleContextImpl.this.activator != null) {
                            BundleContextImpl.this.activator.stop(BundleContextImpl.this);
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.activator = null;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.activator = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getRegisteredServices() {
        ServiceReference[] serviceReferenceArray = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            block11: {
                serviceReferenceArray = this.framework.serviceRegistry.lookupServiceReferences(this);
                if (serviceReferenceArray != null) break block11;
                return null;
            }
            int n = 0;
            int n2 = serviceReferenceArray.length - 1;
            while (n2 >= 0) {
                ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceReferenceArray[n2];
                String[] stringArray = serviceReferenceImpl.getClasses();
                try {
                    this.framework.checkGetServicePermission(stringArray);
                }
                catch (SecurityException securityException) {
                    serviceReferenceArray[n2] = null;
                    ++n;
                }
                --n2;
            }
            if (n > 0) {
                ServiceReference[] serviceReferenceArray2 = serviceReferenceArray;
                serviceReferenceArray = new ServiceReference[serviceReferenceArray2.length - n];
                int n3 = serviceReferenceArray2.length - 1;
                while (n3 >= 0) {
                    if (serviceReferenceArray2[n3] == null) {
                        --n;
                    } else {
                        serviceReferenceArray[n3 - n] = serviceReferenceArray2[n3];
                    }
                    --n3;
                }
            }
        }
        return serviceReferenceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ServiceReferenceImpl[] getServicesInUse() {
        if (this.servicesInUse == null) {
            return null;
        }
        Hashtable hashtable = this.servicesInUse;
        synchronized (hashtable) {
            ServiceReferenceImpl[] serviceReferenceImplArray;
            block10: {
                int n = this.servicesInUse.size();
                if (n == 0) {
                    return null;
                }
                serviceReferenceImplArray = new ServiceReferenceImpl[n];
                int n2 = 0;
                Enumeration enumeration = this.servicesInUse.keys();
                int n3 = 0;
                while (true) {
                    block11: {
                        if (n3 >= n) {
                            if (n2 < n) {
                                if (n2 != 0) break;
                                return null;
                            }
                            break block10;
                        }
                        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)enumeration.nextElement();
                        try {
                            this.framework.checkGetServicePermission(serviceReferenceImpl.registration.clazzes);
                        }
                        catch (SecurityException securityException) {
                            break block11;
                        }
                        serviceReferenceImplArray[n2] = serviceReferenceImpl;
                        ++n2;
                    }
                    ++n3;
                }
                ServiceReferenceImpl[] serviceReferenceImplArray2 = serviceReferenceImplArray;
                serviceReferenceImplArray = new ServiceReferenceImpl[n2];
                System.arraycopy(serviceReferenceImplArray2, 0, serviceReferenceImplArray, 0, n2);
            }
            return serviceReferenceImplArray;
        }
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        block16: {
            BundleHost bundleHost = this.bundle;
            try {
                if (this.isValid()) {
                    block1 : switch (n) {
                        case 1: 
                        case 2: {
                            Object object4;
                            BundleListener bundleListener = (BundleListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                object4 = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(bundleListener.hashCode());
                                Debug.println("dispatchBundleEvent[" + bundleHost + "](" + (String)object4 + ")");
                            }
                            object4 = (BundleEvent)object3;
                            switch (((BundleEvent)object4).getType()) {
                                case -2147483647: {
                                    if (!(bundleListener instanceof BatchBundleListener)) break block1;
                                    ((BatchBundleListener)bundleListener).batchBegin();
                                    break block1;
                                }
                                case -2147483648: {
                                    if (!(bundleListener instanceof BatchBundleListener)) break block1;
                                    ((BatchBundleListener)bundleListener).batchEnd();
                                    break block1;
                                }
                            }
                            bundleListener.bundleChanged((BundleEvent)object3);
                            break;
                        }
                        case 3: {
                            ServiceEvent serviceEvent = (ServiceEvent)object3;
                            ServiceListener serviceListener = (ServiceListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                String string = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(serviceListener.hashCode());
                                Debug.println("dispatchServiceEvent[" + bundleHost + "](" + string + ")");
                            }
                            serviceListener.serviceChanged(serviceEvent);
                            break;
                        }
                        case 4: {
                            FrameworkListener frameworkListener = (FrameworkListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                String string = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(frameworkListener.hashCode());
                                Debug.println("dispatchFrameworkEvent[" + bundleHost + "](" + string + ")");
                            }
                            frameworkListener.frameworkEvent((FrameworkEvent)object3);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                FrameworkEvent frameworkEvent;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in bottom level event dispatcher: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.framework.adaptor.handleRuntimeError(throwable);
                if (n == 4 && (frameworkEvent = (FrameworkEvent)object3).getType() == 2) break block16;
                this.framework.publishFrameworkEvent(2, bundleHost, throwable);
            }
        }
    }

    protected boolean hasListenServicePermission(ServiceEvent serviceEvent) {
        BundleProtectionDomain bundleProtectionDomain = this.bundle.getProtectionDomain();
        if (bundleProtectionDomain != null) {
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
            String[] stringArray = serviceReferenceImpl.registration.clazzes;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (bundleProtectionDomain.implies(new ServicePermission(stringArray[n2], "get"))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public Filter createFilter(String string) throws InvalidSyntaxException {
        this.checkValid();
        return new FilterImpl(string);
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    boolean isAssignableTo(ServiceReferenceImpl serviceReferenceImpl) {
        if (!scopeEvents) {
            return true;
        }
        String[] stringArray = serviceReferenceImpl.getClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (!serviceReferenceImpl.isAssignableTo(this.bundle, stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

