/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.PolicyHandler;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleLoader
implements ClassLoaderDelegate {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final byte FLAG_IMPORTSINIT = 1;
    public static final byte FLAG_HASDYNAMICIMPORTS = 2;
    public static final byte FLAG_HASDYNAMICEIMPORTALL = 4;
    public static final byte FLAG_CLOSED = 8;
    public static final ClassContext CLASS_CONTEXT = (ClassContext)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContext();
        }
    });
    public static final ClassLoader FW_CLASSLOADER;
    BundleLoaderProxy proxy;
    BundleHost bundle;
    BundleClassLoader classloader;
    ClassLoader parent;
    KeyedHashSet importedSources;
    KeyedHashSet requiredSources;
    String[] dynamicImportPackageStems;
    String[] dynamicImportPackages;
    ArrayList exportedPackages;
    BundleLoaderProxy[] requiredBundles;
    int[] reexportTable;
    byte loaderFlags = 0;
    private PolicyHandler policy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FW_CLASSLOADER = BundleLoader.getClassLoader(clazz);
    }

    public static final String getPackageName(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(0, n);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String string) {
        if (string != null) {
            int n = string.length() > 1 && string.charAt(0) == '/' ? 1 : 0;
            int n2 = string.lastIndexOf(47);
            if (n2 > n) {
                return string.substring(n, n2).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    protected BundleLoader(BundleHost bundleHost, BundleLoaderProxy bundleLoaderProxy) throws BundleException {
        this.bundle = bundleHost;
        this.proxy = bundleLoaderProxy;
        try {
            bundleHost.getBundleData().open();
        }
        catch (IOException iOException) {
            throw new BundleException(Msg.BUNDLE_READ_EXCEPTION, iOException);
        }
        this.initialize(bundleLoaderProxy.getBundleDescription());
    }

    final void initialize(BundleDescription bundleDescription) {
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        BundleDescription[] bundleDescriptionArray = bundleDescription.getResolvedRequires();
        if (bundleDescriptionArray.length > 0) {
            object = new HashSet(bundleDescriptionArray.length);
            objectArray2 = bundleDescription.getRequiredBundles();
            if (objectArray2 != null && objectArray2.length > 0) {
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (objectArray2[n2].isExported()) {
                        ((HashSet)object).add(objectArray2[n2].getName());
                    }
                    ++n2;
                }
            }
            this.requiredBundles = new BundleLoaderProxy[bundleDescriptionArray.length];
            objectArray = new int[bundleDescriptionArray.length];
            n = 0;
            int n3 = 0;
            while (n3 < bundleDescriptionArray.length) {
                this.requiredBundles[n3] = this.getLoaderProxy(bundleDescriptionArray[n3]);
                if (((HashSet)object).contains(bundleDescriptionArray[n3].getSymbolicName())) {
                    objectArray[n++] = (BundleDescription)n3;
                }
                ++n3;
            }
            if (n > 0) {
                this.reexportTable = new int[n];
                System.arraycopy(objectArray, 0, this.reexportTable, 0, n);
            }
        }
        if ((object = bundleDescription.getSelectedExports()) != null && ((ExportPackageDescription[])object).length > 0) {
            this.exportedPackages = new ArrayList(((ExportPackageDescription[])object).length);
            int n4 = 0;
            while (n4 < ((ExportPackageDescription[])object).length) {
                if (!this.exportedPackages.contains(object[n4].getName())) {
                    this.exportedPackages.add(object[n4].getName());
                    this.proxy.createPackageSource((ExportPackageDescription)object[n4], true);
                }
                ++n4;
            }
        }
        objectArray = new BundleDescription[(objectArray2 = this.bundle.getFragments()) == null ? 0 : objectArray2.length];
        n = 0;
        while (n < objectArray.length) {
            objectArray[n] = ((AbstractBundle)objectArray2[n]).getBundleDescription();
            ++n;
        }
        if (bundleDescription.hasDynamicImports()) {
            this.addDynamicImportPackage(bundleDescription.getImportPackages());
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].isResolved() && objectArray[n].hasDynamicImports()) {
                this.addDynamicImportPackage(objectArray[n].getImportPackages());
            }
            ++n;
        }
        try {
            String string = null;
            string = (String)this.bundle.getBundleData().getManifest().get("Eclipse-BuddyPolicy");
            if (string != null) {
                this.policy = new PolicyHandler(this, string);
            }
        }
        catch (BundleException bundleException) {}
    }

    private synchronized void addImportedPackages(ExportPackageDescription[] exportPackageDescriptionArray) {
        if ((this.loaderFlags & 1) != 0) {
            return;
        }
        if (exportPackageDescriptionArray != null && exportPackageDescriptionArray.length > 0) {
            if (this.importedSources == null) {
                this.importedSources = new KeyedHashSet(exportPackageDescriptionArray.length, false);
            }
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                PackageSource packageSource = this.createExportPackageSource(exportPackageDescriptionArray[n]);
                if (packageSource != null) {
                    this.importedSources.add(packageSource);
                }
                ++n;
            }
        }
        this.loaderFlags = (byte)(this.loaderFlags | 1);
    }

    final PackageSource createExportPackageSource(ExportPackageDescription exportPackageDescription) {
        BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy(exportPackageDescription.getExporter());
        if (bundleLoaderProxy == null) {
            return null;
        }
        PackageSource packageSource = bundleLoaderProxy.getBundleLoader().findRequiredSource(exportPackageDescription.getName());
        PackageSource packageSource2 = bundleLoaderProxy.createPackageSource(exportPackageDescription, false);
        if (packageSource == null) {
            return packageSource2;
        }
        return BundleLoader.createMultiSource(exportPackageDescription.getName(), new PackageSource[]{packageSource, packageSource2});
    }

    private static PackageSource createMultiSource(String string, PackageSource[] packageSourceArray) {
        if (packageSourceArray.length == 1) {
            return packageSourceArray[0];
        }
        ArrayList<SingleSourcePackage> arrayList = new ArrayList<SingleSourcePackage>(packageSourceArray.length);
        int n = 0;
        while (n < packageSourceArray.length) {
            SingleSourcePackage[] singleSourcePackageArray = packageSourceArray[n].getSuppliers();
            int n2 = 0;
            while (n2 < singleSourcePackageArray.length) {
                if (!arrayList.contains(singleSourcePackageArray[n2])) {
                    arrayList.add(singleSourcePackageArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return new MultiSourcePackage(string, arrayList.toArray(new SingleSourcePackage[arrayList.size()]));
    }

    final BundleLoaderProxy getLoaderProxy(BundleDescription bundleDescription) {
        BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
        if (bundleLoaderProxy == null) {
            long l = bundleDescription.getBundleId();
            BundleHost bundleHost = (BundleHost)this.bundle.framework.getBundle(l);
            if (bundleHost == null) {
                return null;
            }
            bundleLoaderProxy = bundleHost.getLoaderProxy();
        }
        return bundleLoaderProxy;
    }

    void close() {
        if ((this.loaderFlags & 8) != 0) {
            return;
        }
        if (this.classloader != null) {
            this.classloader.close();
        }
        if (this.policy != null) {
            this.policy.close();
            this.policy = null;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 8);
    }

    final Class loadClass(String string) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(string);
    }

    final URL getResource(String string) {
        return this.createClassLoader().getResource(string);
    }

    final Enumeration getResources(String string) throws IOException {
        return this.createClassLoader().getResources(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] stringArray = this.bundle.getBundleData().getClassPath();
                if (stringArray != null) {
                    BundleClassLoader bundleClassLoader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), stringArray);
                    this.parent = this.getParentPrivileged(bundleClassLoader);
                    this.classloader = bundleClassLoader;
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.BUNDLE_NO_CLASSPATH_MATCH));
                }
            }
            catch (BundleException bundleException) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, bundleException);
            }
        }
        return this.classloader;
    }

    Class findLocalClass(String string) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + string + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(string);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + string);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, true);
    }

    Class findClass(String string, boolean bl) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + string + ")");
        }
        String string2 = BundleLoader.getPackageName(string);
        if (bl && this.parent != null) {
            if (string.startsWith(JAVA_PACKAGE)) {
                return this.parent.loadClass(string);
            }
            if (this.isBootDelegationPackage(string2)) {
                try {
                    return this.parent.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        Class<?> clazz = null;
        PackageSource packageSource = this.findImportedSource(string2);
        if (packageSource != null) {
            clazz = packageSource.loadClass(string);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
        packageSource = this.findRequiredSource(string2);
        if (packageSource != null) {
            clazz = packageSource.loadClass(string);
        }
        if (clazz == null) {
            clazz = this.findLocalClass(string);
        }
        if (clazz != null) {
            return clazz;
        }
        if (packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            clazz = packageSource.loadClass(string);
        }
        if (clazz == null && this.policy != null) {
            clazz = this.policy.doBuddyClassLoading(string);
        }
        if (clazz == null && this.findParentResource(string)) {
            clazz = this.parent.loadClass(string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    private boolean findParentResource(String string) {
        if (this.bundle.framework.bootDelegateAll || !this.bundle.framework.contextBootDelegation) {
            return false;
        }
        Class[] classArray = CLASS_CONTEXT.getClassContext();
        if (classArray == null || classArray.length < 2) {
            return false;
        }
        int n = 1;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.framework.internal.core.BundleLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ClassLoader classLoader;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("java.lang.ClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.isAssignableFrom(classArray[n]) && (classLoader = BundleLoader.getClassLoader(classArray[n])) != FW_CLASSLOADER) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.lang.Class");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4 == classArray[n] || classLoader instanceof BundleClassLoader) break;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    final boolean isClosed() {
        return (this.loaderFlags & 8) != 0;
    }

    public URL findResource(String string) {
        return this.findResource(string, true);
    }

    URL findResource(String string, boolean bl) {
        URL uRL;
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = BundleLoader.getResourcePackageName(string);
        if (bl && this.parent != null) {
            if (string2.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResource(string);
            }
            if (this.isBootDelegationPackage(string2) && (uRL = this.parent.getResource(string)) != null) {
                return uRL;
            }
        }
        uRL = null;
        PackageSource packageSource = this.findImportedSource(string2);
        if (packageSource != null) {
            return packageSource.getResource(string);
        }
        packageSource = this.findRequiredSource(string2);
        if (packageSource != null) {
            uRL = packageSource.getResource(string);
        }
        if (uRL == null) {
            uRL = this.findLocalResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        if (packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            uRL = packageSource.getResource(string);
        }
        if (uRL == null && this.policy != null) {
            return this.policy.doBuddyResourceLoading(string);
        }
        if (uRL == null && this.findParentResource(string)) {
            uRL = this.parent.getResource(string);
        }
        return uRL;
    }

    private boolean isBootDelegationPackage(String string) {
        int n;
        if (this.bundle.framework.bootDelegateAll) {
            return true;
        }
        if (this.bundle.framework.bootDelegation != null) {
            n = 0;
            while (n < this.bundle.framework.bootDelegation.length) {
                if (string.equals(this.bundle.framework.bootDelegation[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (this.bundle.framework.bootDelegationStems != null) {
            n = 0;
            while (n < this.bundle.framework.bootDelegationStems.length) {
                if (string.startsWith(this.bundle.framework.bootDelegationStems[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public Enumeration findResources(String string) throws IOException {
        Vector vector;
        Enumeration enumeration;
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = BundleLoader.getResourcePackageName(string);
        Enumeration enumeration2 = null;
        PackageSource packageSource = this.findImportedSource(string2);
        if (packageSource != null) {
            return packageSource.getResources(string);
        }
        packageSource = this.findRequiredSource(string2);
        if (packageSource != null) {
            enumeration2 = packageSource.getResources(string);
        }
        if (enumeration2 == null) {
            enumeration2 = this.findLocalResources(string);
        } else {
            enumeration = this.findLocalResources(string);
            if (enumeration != null) {
                vector = new Vector();
                while (enumeration2.hasMoreElements()) {
                    vector.add(enumeration2.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                enumeration2 = vector.elements();
            }
        }
        if (enumeration2 == null && packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            return packageSource.getResources(string);
        }
        if (this.policy != null) {
            enumeration = this.policy.doBuddyResourcesLoading(string);
            if (enumeration == null) {
                return enumeration2;
            }
            if (enumeration2 == null) {
                return enumeration;
            }
            vector = new Vector();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (vector.contains(e)) continue;
                vector.add(e);
            }
            enumeration2 = vector.elements();
        }
        return enumeration2;
    }

    URL findLocalResource(String string) {
        return this.createClassLoader().findLocalResource(string);
    }

    Enumeration findLocalResources(String string) {
        return this.createClassLoader().findLocalResources(string);
    }

    public String findLibrary(final String string) {
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(string);
            }
        });
    }

    final String findLocalLibrary(String string) {
        String string2 = this.bundle.getBundleData().findLibrary(string);
        if (string2 != null) {
            return string2;
        }
        Bundle[] bundleArray = this.bundle.getFragments();
        if (bundleArray == null || bundleArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            string2 = ((AbstractBundle)bundleArray[n]).getBundleData().findLibrary(string);
            if (string2 != null) {
                return string2;
            }
            ++n;
        }
        return string2;
    }

    final AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final BundleProtectionDomain bundleProtectionDomain, final String[] stringArray) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(bundleProtectionDomain, stringArray);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(bundleProtectionDomain, stringArray);
            }
        });
    }

    BundleClassLoader createBCL(BundleProtectionDomain bundleProtectionDomain, String[] stringArray) {
        BundleClassLoader bundleClassLoader = this.bundle.getBundleData().createClassLoader(this, bundleProtectionDomain, stringArray);
        Bundle[] bundleArray = this.bundle.getFragments();
        if (bundleArray != null) {
            int n = 0;
            while (n < bundleArray.length) {
                AbstractBundle abstractBundle = (AbstractBundle)bundleArray[n];
                try {
                    bundleClassLoader.attachFragment(abstractBundle.getBundleData(), abstractBundle.domain, abstractBundle.getBundleData().getClassPath());
                }
                catch (BundleException bundleException) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, bundleException);
                }
                ++n;
            }
        }
        bundleClassLoader.initialize();
        return bundleClassLoader;
    }

    public final String toString() {
        BundleData bundleData = this.bundle.getBundleData();
        return bundleData == null ? "BundleLoader.bundledata == null!" : bundleData.toString();
    }

    final boolean isDynamicallyImported(String string) {
        int n;
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (string.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        if ((this.loaderFlags & 2) == 0) {
            return false;
        }
        if ((this.loaderFlags & 4) != 0) {
            return true;
        }
        if (this.dynamicImportPackages != null) {
            n = 0;
            while (n < this.dynamicImportPackages.length) {
                if (string.equals(this.dynamicImportPackages[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            n = 0;
            while (n < this.dynamicImportPackageStems.length) {
                if (string.startsWith(this.dynamicImportPackageStems[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    final void addExportedProvidersFor(String string, String string2, ArrayList arrayList, KeyedHashSet keyedHashSet) {
        if (!keyedHashSet.add(this.bundle)) {
            return;
        }
        PackageSource packageSource = null;
        if (this.isExportedPackage(string2)) {
            packageSource = this.proxy.getPackageSource(string2);
        }
        if (this.requiredBundles != null) {
            int n = this.reexportTable == null ? 0 : this.reexportTable.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.requiredBundles.length) {
                if (packageSource != null) {
                    this.requiredBundles[n3].getBundleLoader().addExportedProvidersFor(string, string2, arrayList, keyedHashSet);
                } else if (n2 < n && this.reexportTable[n2] == n3) {
                    ++n2;
                    this.requiredBundles[n3].getBundleLoader().addExportedProvidersFor(string, string2, arrayList, keyedHashSet);
                }
                ++n3;
            }
        }
        if (packageSource != null && packageSource.isFriend(string)) {
            if (packageSource instanceof BundleLoaderProxy.ReexportPackageSource) {
                packageSource = new SingleSourcePackage(string2, -1, this.proxy);
            }
            arrayList.add(packageSource);
        }
    }

    final boolean isExportedPackage(String string) {
        return this.exportedPackages == null ? false : this.exportedPackages.contains(string);
    }

    private void addDynamicImportPackage(ImportPackageSpecification[] importPackageSpecificationArray) {
        if (importPackageSpecificationArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(importPackageSpecificationArray.length);
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            if ("dynamic".equals(importPackageSpecificationArray[n].getDirective("resolution"))) {
                arrayList.add(importPackageSpecificationArray[n].getName());
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.addDynamicImportPackage(arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private void addDynamicImportPackage(String[] stringArray) {
        int n;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        if (stringArray == null) {
            return;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 2);
        if (this.importedSources == null) {
            this.importedSources = new KeyedHashSet(10, false);
        }
        if (stringArray == null) {
            return;
        }
        int n2 = stringArray.length;
        if (this.dynamicImportPackageStems == null) {
            arrayList2 = new ArrayList<String>(n2);
        } else {
            arrayList2 = new ArrayList(n2 + this.dynamicImportPackageStems.length);
            int n3 = 0;
            while (n3 < this.dynamicImportPackageStems.length) {
                arrayList2.add(this.dynamicImportPackageStems[n3]);
                ++n3;
            }
        }
        if (this.dynamicImportPackages == null) {
            arrayList = new ArrayList<String>(n2);
        } else {
            arrayList = new ArrayList(n2 + this.dynamicImportPackages.length);
            n = 0;
            while (n < this.dynamicImportPackages.length) {
                arrayList.add(this.dynamicImportPackages[n]);
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            String string = stringArray[n];
            if (!this.isDynamicallyImported(string)) {
                if (string.equals("*")) {
                    this.loaderFlags = (byte)(this.loaderFlags | 4);
                    return;
                }
                if (string.endsWith(".*")) {
                    arrayList2.add(string.substring(0, string.length() - 1));
                } else {
                    arrayList.add(string);
                }
            }
            ++n;
        }
        n2 = arrayList2.size();
        if (n2 > 0) {
            this.dynamicImportPackageStems = arrayList2.toArray(new String[n2]);
        }
        if ((n2 = arrayList.size()) > 0) {
            this.dynamicImportPackages = arrayList.toArray(new String[n2]);
        }
    }

    public final void addDynamicImportPackage(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            arrayList.add(manifestElementArray[n].getValue());
            ++n;
        }
        if (arrayList.size() > 0) {
            this.addDynamicImportPackage(arrayList.toArray(new String[arrayList.size()]));
        }
    }

    final void attachFragment(BundleFragment bundleFragment) throws BundleException {
        if (this.classloader == null) {
            return;
        }
        String[] stringArray = bundleFragment.getBundleData().getClassPath();
        if (stringArray != null) {
            this.classloader.attachFragment(bundleFragment.getBundleData(), bundleFragment.domain, stringArray);
        }
    }

    private PackageSource findSource(String string) {
        if (string == null) {
            return null;
        }
        PackageSource packageSource = this.findImportedSource(string);
        if (packageSource != null) {
            return packageSource;
        }
        return this.findRequiredSource(string);
    }

    private PackageSource findImportedSource(String string) {
        if ((this.loaderFlags & 1) == 0) {
            this.addImportedPackages(this.proxy.getBundleDescription().getResolvedImports());
        }
        return this.importedSources == null ? null : (PackageSource)this.importedSources.getByKey(string);
    }

    private PackageSource findDynamicSource(String string) {
        ExportPackageDescription exportPackageDescription;
        if (this.isDynamicallyImported(string) && (exportPackageDescription = this.bundle.framework.adaptor.getState().linkDynamicImport(this.proxy.getBundleDescription(), string)) != null) {
            PackageSource packageSource = this.createExportPackageSource(exportPackageDescription);
            this.importedSources.add(packageSource);
            return packageSource;
        }
        return null;
    }

    private PackageSource findRequiredSource(String string) {
        Object object;
        Object object2;
        if (this.requiredBundles == null) {
            return null;
        }
        if (this.requiredSources != null && (object2 = (PackageSource)this.requiredSources.getByKey(string)) != null) {
            return ((PackageSource)object2).isNullSource() ? null : object2;
        }
        object2 = new KeyedHashSet(false);
        ((KeyedHashSet)object2).add(this.bundle);
        ArrayList arrayList = new ArrayList(3);
        int n = 0;
        while (n < this.requiredBundles.length) {
            object = this.requiredBundles[n].getBundleLoader();
            ((BundleLoader)object).addExportedProvidersFor(this.proxy.getSymbolicName(), string, arrayList, (KeyedHashSet)object2);
            ++n;
        }
        if (this.requiredSources == null) {
            this.requiredSources = new KeyedHashSet(10, false);
        }
        if (arrayList.size() == 0) {
            this.requiredSources.add(NullPackageSource.getNullPackageSource(string));
            return null;
        }
        if (arrayList.size() == 1) {
            PackageSource packageSource = (PackageSource)arrayList.get(0);
            this.requiredSources.add(packageSource);
            return packageSource;
        }
        PackageSource[] packageSourceArray = arrayList.toArray(new PackageSource[arrayList.size()]);
        object = BundleLoader.createMultiSource(string, packageSourceArray);
        this.requiredSources.add((KeyedElement)object);
        return object;
    }

    final PackageSource getPackageSource(String string) {
        PackageSource packageSource = this.findSource(string);
        if (!this.isExportedPackage(string)) {
            return packageSource;
        }
        PackageSource packageSource2 = this.proxy.getPackageSource(string);
        if (packageSource2 instanceof BundleLoaderProxy.ReexportPackageSource) {
            packageSource2 = new SingleSourcePackage(string, -1, this.proxy);
        }
        if (packageSource == null) {
            return packageSource2;
        }
        if (packageSource2 == null) {
            return packageSource;
        }
        return BundleLoader.createMultiSource(string, new PackageSource[]{packageSource, packageSource2});
    }

    private ClassLoader getParentPrivileged(final BundleClassLoader bundleClassLoader) {
        if (System.getSecurityManager() == null) {
            return bundleClassLoader.getParent();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundleClassLoader.getParent();
            }
        });
    }

    private static final class ClassContext
    extends SecurityManager {
        private ClassContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

