/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ServiceReferenceImpl
implements ServiceReference,
Comparable {
    protected ServiceRegistrationImpl registration;

    protected ServiceReferenceImpl(ServiceRegistrationImpl serviceRegistrationImpl) {
        this.registration = serviceRegistrationImpl;
    }

    public Object getProperty(String string) {
        return this.registration.getProperty(string);
    }

    public String[] getPropertyKeys() {
        return this.registration.getPropertyKeys();
    }

    public Bundle getBundle() {
        return this.registration.getBundle();
    }

    public Bundle[] getUsingBundles() {
        return this.registration.getUsingBundles();
    }

    protected String[] getClasses() {
        return this.registration.clazzes;
    }

    protected long getId() {
        return this.registration.serviceid;
    }

    protected int getRanking() {
        return this.registration.serviceranking;
    }

    public int hashCode() {
        return this.registration.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceReferenceImpl)) {
            return false;
        }
        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)object;
        return this.registration == serviceReferenceImpl.registration;
    }

    public String toString() {
        return this.registration.toString();
    }

    public int compareTo(Object object) {
        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)object;
        int n = this.getRanking() - serviceReferenceImpl.getRanking();
        if (n == 0) {
            return (int)(serviceReferenceImpl.getId() - this.getId());
        }
        return n;
    }

    public boolean isAssignableTo(Bundle bundle, String string) {
        AbstractBundle abstractBundle = (AbstractBundle)bundle;
        if (abstractBundle.isFragment()) {
            return false;
        }
        BundleHost bundleHost = (BundleHost)this.registration.bundle;
        if (abstractBundle == bundleHost) {
            return true;
        }
        String string2 = BundleLoader.getPackageName(string);
        if (string2.startsWith("java.")) {
            return true;
        }
        BundleLoader bundleLoader = bundleHost.getBundleLoader();
        if (bundleLoader == null) {
            return false;
        }
        BundleLoader bundleLoader2 = abstractBundle.getBundleLoader();
        if (bundleLoader2 == null) {
            return false;
        }
        PackageSource packageSource = bundleLoader2.getPackageSource(string2);
        if (packageSource == null) {
            return true;
        }
        PackageSource packageSource2 = bundleLoader.getPackageSource(string2);
        if (packageSource2 == null && (packageSource2 = this.getPackageSource(this.registration.service.getClass(), string2)) == null) {
            return false;
        }
        return packageSource2.hasCommonSource(packageSource);
    }

    private PackageSource getPackageSource(Class clazz, String string) {
        if (clazz == null) {
            return null;
        }
        AbstractBundle abstractBundle = (AbstractBundle)this.registration.framework.packageAdmin.getBundle(clazz);
        if (abstractBundle == null) {
            return null;
        }
        BundleLoader bundleLoader = abstractBundle.getBundleLoader();
        if (bundleLoader == null) {
            return null;
        }
        PackageSource packageSource = bundleLoader.getPackageSource(string);
        if (packageSource != null) {
            return packageSource;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            packageSource = this.getPackageSource(clazz.getSuperclass(), string);
            if (packageSource != null) {
                return packageSource;
            }
            ++n;
        }
        return this.getPackageSource(clazz.getSuperclass(), string);
    }
}

