/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerProxy;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingContentHandler;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ContentHandlerFactory
extends MultiplexingFactory
implements java.net.ContentHandlerFactory {
    private ServiceTracker contentHandlerTracker;
    private static final String contentHandlerClazz = "java.net.ContentHandler";
    private static final String CONTENT_HANDLER_PKGS = "java.content.handler.pkgs";
    private static final String DEFAULT_VM_CONTENT_HANDLERS = "sun.net.www.content";
    private static final List ignoredClasses;
    private Hashtable proxies = new Hashtable(5);
    private java.net.ContentHandlerFactory parentFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.protocol.MultiplexingContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        ignoredClasses = Arrays.asList(classArray);
    }

    public ContentHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        super(bundleContext, frameworkAdaptor);
        this.contentHandlerTracker = new ServiceTracker(bundleContext, contentHandlerClazz, null);
        this.contentHandlerTracker.open();
    }

    public ContentHandler createContentHandler(String string) {
        String string2 = StreamHandlerFactory.secureAction.getProperty(CONTENT_HANDLER_PKGS);
        string2 = string2 == null ? DEFAULT_VM_CONTENT_HANDLERS : "sun.net.www.content|" + string2;
        Class clazz = null;
        if (string2 != null) {
            String string3 = string.replace('.', '_');
            string3 = string3.replace('/', '.');
            string3 = string3.replace('-', '_');
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreElements()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append(".");
                stringBuffer.append(string3);
                try {
                    clazz = StreamHandlerFactory.secureAction.forName(stringBuffer.toString());
                    if (clazz == null) continue;
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (this.isMultiplexing()) {
            return new MultiplexingContentHandler(string, this);
        }
        return this.createInternalContentHandler(string);
    }

    public ContentHandler createInternalContentHandler(String string) {
        ContentHandler contentHandler;
        ContentHandlerProxy contentHandlerProxy = (ContentHandlerProxy)this.proxies.get(string);
        if (contentHandlerProxy != null) {
            return contentHandlerProxy;
        }
        ServiceReference[] serviceReferenceArray = this.contentHandlerTracker.getServiceReferences();
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                Object object = serviceReferenceArray[n].getProperty("url.content.mimetype");
                if (object != null && object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equals(string)) {
                            contentHandlerProxy = new ContentHandlerProxy(string, serviceReferenceArray[n], this.context);
                            this.proxies.put(string, contentHandlerProxy);
                            return contentHandlerProxy;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this.parentFactory != null && (contentHandler = this.parentFactory.createContentHandler(string)) != null) {
            return contentHandler;
        }
        contentHandlerProxy = new ContentHandlerProxy(string, null, this.context);
        this.proxies.put(string, contentHandlerProxy);
        return contentHandlerProxy;
    }

    public synchronized ContentHandler findAuthorizedContentHandler(String string) {
        Object object = this.findAuthorizedFactory(ignoredClasses);
        if (object == null) {
            return null;
        }
        if (object == this) {
            return this.createInternalContentHandler(string);
        }
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("createInternalContentHandler", classArray);
            return (ContentHandler)method.invoke(object, string);
        }
        catch (Exception exception) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), "findAuthorizedContentHandler-loop", 4, exception, null));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public Object getParentFactory() {
        return this.parentFactory;
    }

    public void setParentFactory(Object object) {
        if (this.parentFactory == null) {
            this.parentFactory = (java.net.ContentHandlerFactory)object;
        }
    }
}

