/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();

    public String getProperty(final String string) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperty(string);
            }
        }, this.controlContext);
    }

    public String getProperty(final String string, final String string2) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string, string2);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperty(string, string2);
            }
        }, this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperties();
        }
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperties();
            }
        }, this.controlContext);
    }

    public FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public FileOutputStream getFileOutputStream(final File file, final boolean bl) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), bl);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file.getAbsolutePath(), bl);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public long length(final File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.length());
            }
        }, this.controlContext);
    }

    public boolean exists(final File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public boolean isDirectory(final File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public long lastModified(final File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.lastModified());
            }
        }, this.controlContext);
    }

    public String[] list(final File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.list();
            }
        }, this.controlContext);
    }

    public ZipFile getZipFile(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return new ZipFile(file);
        }
        try {
            return (ZipFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ZipFile(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public URL getURL(final String string, final String string2, final int n, final String string3, final URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(string, string2, n, string3, uRLStreamHandler);
        }
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(string, string2, n, string3, uRLStreamHandler);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public Thread createThread(final Runnable runnable, final String string) {
        if (System.getSecurityManager() == null) {
            return new Thread(runnable, string);
        }
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(runnable, string);
            }
        }, this.controlContext);
    }

    public Object getService(final ServiceReference serviceReference, final BundleContext bundleContext) {
        if (System.getSecurityManager() == null) {
            return bundleContext.getService(serviceReference);
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundleContext.getService(serviceReference);
            }
        }, this.controlContext);
    }

    public Class forName(final String string) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Class.forName(string);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public void open(final ServiceTracker serviceTracker) {
        if (System.getSecurityManager() == null) {
            serviceTracker.open();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                serviceTracker.open();
                return null;
            }
        }, this.controlContext);
    }
}

