/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryDialog
extends Dialog {
    private static final int MARGIN_WIDTH = 3;
    private static final int MARGIN_HEIGHT = 3;
    private static final int SPACING = 3;
    private static final int SHELL_MARGIN_WIDTH = 20;
    private static final int INPUT_WIDTH_MINIMUM = 80;
    private TextModifyListener tml;
    private int maximum = Text.LIMIT;
    private int minimum = 0;
    private int queryType;
    private String promptText;
    private String value;
    private static final String QUERYDIALOG_OK_KEY = "QueryDialog_Ok";
    private static final String QUERYDIALOG_CANCEL_KEY = "QueryDialog_Cancel";
    private static final String MOBILE_PROPERTY_NAME = "mobile";
    private static String strOk;
    private static String strCancel;
    Thread thread;
    public static final int STANDARD = 0;
    public static final int PASSWORD = 1;
    public static final int NUMERIC = 2;
    public static final int TIME = 3;
    public static final int DATE = 4;

    public QueryDialog(Shell parent) {
        this(parent, 65536, 0);
    }

    public QueryDialog(Shell parent, int style) {
        this(parent, style, 0);
    }

    public QueryDialog(Shell parent, int style, int queryType) {
        super(parent, style);
        if (queryType != 0 && queryType != 1 && queryType != 2 && queryType != 3 && queryType != 4) {
            SWT.error(5);
            return;
        }
        this.queryType = queryType;
        this.tml = new TextModifyListener();
        ResourceBundle rb = ResourceBundle.getBundle(MOBILE_PROPERTY_NAME, Locale.getDefault());
        strOk = rb.getString(QUERYDIALOG_OK_KEY);
        strCancel = rb.getString(QUERYDIALOG_CANCEL_KEY);
        rb = null;
        this.thread = Thread.currentThread();
    }

    public String open() {
        int prompth;
        int promptw;
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (this.value == null) {
            this.value = "";
        }
        Shell parent = this.getParent();
        final Display display = parent.getDisplay();
        int maxw = display.getBounds().width;
        int maxh = display.getBounds().height;
        if (SWT.getPlatform().equals("win32")) {
            maxw /= 2;
            maxh /= 2;
        }
        final Shell shell = new Shell(parent, 67680);
        shell.setText(this.getText());
        Label prompt = new Label(shell, 16448);
        if (this.promptText != null) {
            prompt.setText(this.promptText);
        }
        int textStyle = 18436;
        if (this.queryType == 1) {
            textStyle |= 0x400000;
        }
        final Text input = new Text(shell, textStyle);
        input.setTextLimit(this.maximum);
        if (this.value != null) {
            input.setText(this.value);
        }
        input.pack();
        this.tml.setMaximum(this.maximum);
        this.tml.setMinimum(this.minimum);
        this.tml.setQueryType(this.queryType);
        this.tml.setValue(this.value);
        input.addModifyListener(this.tml);
        Button okButton = new Button(shell, 0);
        okButton.setText(strOk);
        okButton.pack();
        Button cancelButton = new Button(shell, 0);
        cancelButton.setText(strCancel);
        cancelButton.pack();
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.spacing = 3;
        shell.setLayout(layout);
        int lineCount = 0;
        if (prompt.getText().length() == 0) {
            promptw = 0;
            prompth = 0;
        } else {
            Text text = new Text(shell, 16450);
            FormData fdMsg = new FormData();
            fdMsg.left = new FormAttachment(0, 0);
            fdMsg.top = new FormAttachment(0, 0);
            fdMsg.right = new FormAttachment(100, 0);
            fdMsg.bottom = new FormAttachment(100, 0);
            text.setLayoutData(fdMsg);
            if (this.promptText != null) {
                text.setText(this.promptText);
            }
            text.pack();
            shell.setSize(maxw - 20, maxh);
            lineCount = text.getLineCount();
            if (lineCount <= 1) {
                text.pack();
            }
            promptw = text.getBounds().width;
            prompth = text.getLineCount() * text.getLineHeight();
            text.dispose();
            text = null;
            fdMsg = null;
        }
        prompt.setSize(promptw, prompth);
        FormData fdPrompt = new FormData();
        fdPrompt.left = new FormAttachment(0, 0);
        fdPrompt.top = new FormAttachment(0, 0);
        if (lineCount > 1 || promptw + 20 + 80 > maxw) {
            fdPrompt.right = new FormAttachment(100, 0);
        }
        fdPrompt.bottom = new FormAttachment(0, prompth);
        prompt.setLayoutData(fdPrompt);
        FormData fdText = new FormData();
        if (lineCount > 1 || promptw + 20 + 80 > maxw) {
            fdText.left = new FormAttachment(0, 0);
            fdText.top = new FormAttachment(prompt, 0);
        } else {
            fdText.left = new FormAttachment(prompt, 0);
            fdText.top = new FormAttachment(0, 0);
        }
        fdText.right = new FormAttachment(100, 0);
        input.setLayoutData(fdText);
        int useWidth = okButton.getSize().x + cancelButton.getSize().x + 3 + 3 + 3;
        int sx = (maxw - 20 - useWidth) / 2;
        FormData fdOKButton = new FormData();
        fdOKButton.left = new FormAttachment(0, sx);
        fdOKButton.top = new FormAttachment(input, 0);
        okButton.setLayoutData(fdOKButton);
        FormData fdCancelButton = new FormData();
        fdCancelButton.left = new FormAttachment(okButton, okButton.getBorderWidth());
        fdCancelButton.top = new FormAttachment(input, 0);
        cancelButton.setLayoutData(fdCancelButton);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String value = input.getText();
                int type = QueryDialog.this.tml.getQueryType();
                boolean valid = true;
                if (type == 3) {
                    if (!QueryDialog.this.tml.isValidTimeFormat(value)) {
                        valid = false;
                    }
                } else if (type == 4) {
                    if (!QueryDialog.this.tml.isValidDateFormat(value)) {
                        valid = false;
                    }
                } else {
                    int maximum;
                    int minimum;
                    if (type == 2 && !QueryDialog.this.tml.isValidNumericFormat(value)) {
                        valid = false;
                    }
                    if (valid && (minimum = QueryDialog.this.tml.getMinimum()) != 0 && value.length() < minimum) {
                        valid = false;
                    }
                    if (valid && (maximum = QueryDialog.this.tml.getMaximum()) != 0 && value.length() > maximum) {
                        valid = false;
                    }
                }
                if (valid) {
                    QueryDialog.this.tml.setResult(value);
                    shell.close();
                } else {
                    input.setFocus();
                    display.beep();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        shell.pack();
        int shellw = maxw - 20;
        int shellh = shell.getBounds().height > maxh ? maxh : shell.getBounds().height;
        int shellx = 10;
        int shelly = (maxh - shellh) / 2;
        if (SWT.getPlatform().equals("win32")) {
            shellx = (display.getBounds().width - shellw) / 2;
            shelly = maxh / 2;
        }
        shell.setBounds(shellx, shelly, shellw, shellh);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.tml.getResult();
    }

    public void setMaximum(int maximum) {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (this.queryType == 3 || this.queryType == 4) {
            return;
        }
        if (maximum < 0 || maximum < this.minimum) {
            SWT.error(4);
            return;
        }
        if (maximum > Text.LIMIT) {
            SWT.error(5);
            return;
        }
        this.maximum = maximum;
    }

    public void setMinimum(int minimum) {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (this.queryType == 3 || this.queryType == 4) {
            return;
        }
        if (minimum < 0 || minimum > this.maximum) {
            SWT.error(4);
            return;
        }
        this.minimum = minimum;
    }

    public void setPromptText(String promptText, String defaultValue) {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (defaultValue == null) {
            SWT.error(4);
            return;
        }
        if (!defaultValue.equals("")) {
            if (this.queryType == 4) {
                String localeDate = this.tml.convISO8601ToLocaleDate(defaultValue);
                if (localeDate == null) {
                    SWT.error(5);
                    return;
                }
                this.value = localeDate;
            } else {
                if (!this.tml.isValidFormat(defaultValue, this.queryType)) {
                    SWT.error(5);
                    return;
                }
                this.value = defaultValue;
            }
        }
        this.promptText = promptText;
    }

    public class TextModifyListener
    implements ModifyListener {
        private int queryType = 0;
        private String value;
        private String result = null;
        private int maximum;
        private int minimum;

        public void setMaximum(int maximum) {
            this.maximum = maximum;
        }

        public int getMaximum() {
            return this.maximum;
        }

        public void setMinimum(int minimum) {
            this.minimum = minimum;
        }

        public int getMinimum() {
            return this.minimum;
        }

        public void setQueryType(int queryType) {
            this.queryType = queryType;
        }

        public int getQueryType() {
            return this.queryType;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getResult() {
            if (this.queryType == 4) {
                return this.convLocaleDateToISO8601(this.value);
            }
            return this.result;
        }

        public boolean isValidNumericFormat(String value) {
            if (value == null) {
                return false;
            }
            if (value.equals("")) {
                return false;
            }
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) >= '0' && value.charAt(i) <= '9') continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValidTimeFormat(String value) {
            if (value == null) {
                return false;
            }
            if (value.equals("")) {
                return false;
            }
            if (value.length() != 8) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(value, ":");
            if (st.countTokens() != 3) {
                st = null;
                return false;
            }
            try {
                String sh = st.nextToken();
                if (sh.length() != 2) {
                    sh = null;
                    boolean bl = false;
                    return bl;
                }
                String ss = st.nextToken();
                if (ss.length() != 2) {
                    ss = null;
                    boolean bl = false;
                    return bl;
                }
                String sm = st.nextToken();
                if (sm.length() != 2) {
                    sm = null;
                    boolean bl = false;
                    return bl;
                }
                int ih = Integer.parseInt(sh);
                int im = Integer.parseInt(sm);
                int is = Integer.parseInt(ss);
                sh = null;
                sm = null;
                ss = null;
                if (ih < 0 || ih > 24 || im < 0 || im > 59 || is < 0 || is > 60) {
                    boolean bl = false;
                    return bl;
                }
                if (ih == 24 && (im != 0 || is != 0)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NumberFormatException nfe) {
                boolean bl = false;
                return bl;
            }
            finally {
                st = null;
            }
            st = null;
            return true;
        }

        public boolean isValidDateFormat(String value) {
            Date date;
            if (value == null) {
                return false;
            }
            if (value.equals("")) {
                return false;
            }
            boolean valid = true;
            Locale locale = Locale.getDefault();
            DateFormat df = DateFormat.getDateInstance(3, locale);
            df.setLenient(false);
            try {
                date = df.parse(value);
                if (date == null) {
                    valid = false;
                }
            }
            catch (ParseException pe) {
                valid = false;
            }
            df = null;
            locale = null;
            date = null;
            return valid;
        }

        public String convLocaleDateToISO8601(String value) {
            try {
                Locale locale = Locale.getDefault();
                DateFormat df = DateFormat.getDateInstance(3, locale);
                df.setLenient(false);
                Date date = df.parse(value);
                Calendar calendar = Calendar.getInstance(locale);
                calendar.setTime(date);
                int y = calendar.get(1);
                int m = calendar.get(2) + 1;
                int d = calendar.get(5);
                StringBuffer sb = new StringBuffer();
                if (y < 1000) {
                    sb.append("0");
                } else if (y < 100) {
                    sb.append("00");
                } else if (y < 10) {
                    sb.append("000");
                }
                sb.append(String.valueOf(y));
                sb.append("-");
                if (m < 10) {
                    sb.append("0");
                }
                sb.append(String.valueOf(m));
                sb.append("-");
                if (d < 10) {
                    sb.append("0");
                }
                sb.append(String.valueOf(d));
                locale = null;
                df = null;
                date = null;
                calendar = null;
                return sb.toString();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String convISO8601ToLocaleDate(String value) {
            try {
                if (value == null) {
                    return null;
                }
                if (value.equals("")) {
                    return null;
                }
                if (value.length() != 10) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(value, "-");
                if (st.countTokens() != 3) {
                    st = null;
                    return null;
                }
                String sy = st.nextToken();
                if (sy.length() != 4) {
                    sy = null;
                    st = null;
                    return null;
                }
                String sm = st.nextToken();
                if (sm.length() != 2) {
                    sm = null;
                    st = null;
                    return null;
                }
                String sd = st.nextToken();
                if (sd.length() != 2) {
                    sd = null;
                    st = null;
                    return null;
                }
                int iy = Integer.parseInt(sy);
                int im = Integer.parseInt(sm);
                int id = Integer.parseInt(sd);
                sy = null;
                sm = null;
                sd = null;
                st = null;
                int maxDay = 31;
                if (im == 2) {
                    maxDay = iy % 400 == 0 ? 29 : (iy % 100 == 0 ? 28 : (iy % 4 == 0 ? 29 : 28));
                } else if (im == 4 || im == 6 || im == 9 || im == 10) {
                    maxDay = 30;
                }
                if (id > maxDay) {
                    return null;
                }
                Locale locale = Locale.getDefault();
                Calendar calendar = Calendar.getInstance(locale);
                calendar.set(iy, im - 1, id);
                DateFormat df = DateFormat.getDateInstance(3, locale);
                df.setLenient(false);
                String localeDate = df.format(calendar.getTime());
                locale = null;
                calendar = null;
                df = null;
                return localeDate;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isValidFormat(String value, int type) {
            if (value == null) {
                return false;
            }
            if (value.equals("")) {
                return true;
            }
            switch (type) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    return this.isValidNumericFormat(value);
                }
                case 3: {
                    return this.isValidTimeFormat(value);
                }
            }
            return true;
        }

        public void modifyText(ModifyEvent e) {
            boolean valid = true;
            Text input = (Text)e.widget;
            if (this.value != null && this.value.equals(input.getText())) {
                return;
            }
            if (input.getText().equals("")) {
                valid = true;
            } else if (this.queryType == 2) {
                valid = this.isValidNumericFormat(input.getText());
            }
            if (valid) {
                this.value = input.getText();
            } else {
                int position = input.getCaretPosition() - 1;
                input.setText(this.value);
                input.setSelection(position);
                e.display.beep();
            }
        }
    }
}

