/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.io.InputStream;
import java.util.Date;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TimedMessageBox
extends Dialog {
    private static final int MARGIN_WIDTH = 3;
    private static final int MARGIN_HEIGHT = 3;
    private static final int SHELL_MARGIN_WIDTH = 20;
    private static final int SPACING = 3;
    private static final int MENU_HEIGHT = 26;
    private static final int DEFAULT_DURATION = 5000;
    private long duration = 5000L;
    private int iconStyle = 0;
    Label label;
    Text text;
    Image image;
    String message;
    Thread thread;

    public TimedMessageBox(Shell parent) {
        this(parent, 65538);
    }

    public TimedMessageBox(Shell parent, int style) {
        super(parent, TimedMessageBox.checkStyle(style));
        if ((style & 0x10) == 16) {
            this.iconStyle = 16;
        } else if ((style & 2) == 2) {
            this.iconStyle = 2;
        } else if ((style & 8) == 8) {
            this.iconStyle = 8;
        } else if ((style & 1) == 1) {
            this.iconStyle = 1;
        }
        this.thread = Thread.currentThread();
    }

    static int checkStyle(int style) {
        if ((style & 0x38000) == 0) {
            style |= 0x10000;
        }
        return style;
    }

    public Image getImage() {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        return this.image;
    }

    public String getMessage() {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        return this.message;
    }

    public void open() {
        int msgh;
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        int maxw = display.getBounds().width;
        int maxh = display.getBounds().height;
        Shell shell = new Shell(parent, 67680);
        shell.setText(this.getText());
        Text text = new Text(shell, 16450);
        Label icon = new Label(shell, 16384);
        if (this.image == null) {
            this.image = this.getSystemIcon(display, this.iconStyle);
        }
        if (this.image != null) {
            icon.setImage(this.image);
        }
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.spacing = 3;
        shell.setLayout(layout);
        FormData fdIcon = new FormData();
        fdIcon.left = new FormAttachment(0, 0);
        fdIcon.top = new FormAttachment(0, 0);
        icon.setLayoutData(fdIcon);
        icon.pack();
        int iconh = icon.getBounds().height;
        shell.pack();
        int titleHeight = shell.getBounds().height - iconh - 6;
        int shellw = maxw - 20;
        int shellh = maxh - titleHeight - 26;
        int shellx = 10;
        int shelly = 0;
        if (SWT.getPlatform().equals("win32")) {
            shellw = maxw / 2;
            shellh = maxh / 2;
            shellx = shellw / 2;
            shelly = shellh / 2;
        }
        FormData fdMsg = new FormData();
        fdMsg.left = new FormAttachment(icon, 0);
        fdMsg.top = new FormAttachment(0, 0);
        fdMsg.right = new FormAttachment(100, 0);
        fdMsg.bottom = new FormAttachment(100, 0);
        text.setLayoutData(fdMsg);
        if (this.message != null) {
            text.setText(this.message);
        }
        text.pack();
        int msgw = text.getBounds().width;
        int h = msgh = text.getLineCount() * text.getLineHeight();
        if (iconh > msgh) {
            h = iconh;
        }
        if (h + titleHeight < shellh) {
            shellh = h + titleHeight + 6;
            if (SWT.getPlatform().equals("wm2003")) {
                shelly = (maxh - shellh) / 2;
            }
        }
        Label msg = new Label(shell, 16448);
        msg.setLayoutData(fdMsg);
        if (this.message != null) {
            msg.setText(this.message);
        }
        msg.setSize(msgw, msgh);
        text.dispose();
        text = null;
        shell.setBounds(shellx, shelly, shellw, shellh);
        shell.open();
        new Thread(new DisposeThread(shell)).start();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setImage(Image image) {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (image == null) {
            SWT.error(4);
            return;
        }
        if (image.internal_handle == 0) {
            SWT.error(5);
            return;
        }
        this.image = image;
    }

    public void setMessage(String string) {
        if (this.thread != Thread.currentThread()) {
            SWT.error(22);
        }
        if (string == null) {
            SWT.error(4);
            return;
        }
        this.message = new String(string);
    }

    private Image getSystemIcon(Display display, int style) {
        String iconName = this.getSystemIconName(style);
        if (iconName != null) {
            InputStream stream = this.getClass().getResourceAsStream("/resources/" + iconName);
            return new Image((Device)display, stream);
        }
        return null;
    }

    private String getSystemIconName(int style) {
        switch (style) {
            case 16: {
                return "IconWorking.png";
            }
            case 1: {
                return "IconError.png";
            }
            case 2: {
                return "IconInformation.png";
            }
            case 8: {
                return "IconWarning.png";
            }
        }
        return null;
    }

    public class DisposeThread
    implements Runnable {
        long sleepTime = 100L;
        final Shell shell;
        final Display display;
        final long start;

        public DisposeThread(Shell shell) {
            this.shell = shell;
            this.display = shell.getDisplay();
            this.start = new Date().getTime();
        }

        public void run() {
            while (!this.shell.isDisposed()) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    return;
                }
                long check = new Date().getTime();
                if (check - this.start < TimedMessageBox.this.duration) continue;
                this.display.asyncExec(new Runnable(this){
                    private final /* synthetic */ DisposeThread this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.shell.dispose();
                    }
                });
            }
        }
    }
}

