/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterFactoryProxy;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public final class AdapterManagerListener
implements IRegistryChangeListener,
IAdapterManagerProvider {
    public static final String ADAPTER_POINT_ID = "org.eclipse.core.runtime.adapters";
    private AdapterManager theAdapterManager = AdapterManager.getDefault();

    public AdapterManagerListener() {
        this.theAdapterManager.registerLazyFactoryProvider((IAdapterManagerProvider)this);
    }

    public boolean addFactories(AdapterManager adapterManager) {
        IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint(ADAPTER_POINT_ID);
        if (iExtensionPoint == null) {
            return false;
        }
        boolean bl = false;
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                AdapterFactoryProxy adapterFactoryProxy = AdapterFactoryProxy.createProxy(iConfigurationElementArray[n2]);
                if (adapterFactoryProxy != null) {
                    adapterManager.registerFactory((IAdapterFactory)adapterFactoryProxy, adapterFactoryProxy.getAdaptableType());
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        return bl;
    }

    private void registerExtension(IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            AdapterFactoryProxy adapterFactoryProxy = AdapterFactoryProxy.createProxy(iConfigurationElementArray[n]);
            if (adapterFactoryProxy != null) {
                this.theAdapterManager.registerFactory((IAdapterFactory)adapterFactoryProxy, adapterFactoryProxy.getAdaptableType());
            }
            ++n;
        }
    }

    public synchronized void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        HashSet<String> hashSet = null;
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        boolean bl = false;
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            if (ADAPTER_POINT_ID.equals(iExtensionDeltaArray[n].getExtensionPoint().getUniqueIdentifier())) {
                bl = true;
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    this.registerExtension(iExtensionDeltaArray[n].getExtension());
                } else {
                    if (hashSet == null) {
                        hashSet = new HashSet<String>();
                    }
                    hashSet.add(iExtensionDeltaArray[n].getExtension().getUniqueIdentifier());
                }
            }
            ++n;
        }
        if (bl) {
            this.theAdapterManager.flushLookup();
        }
        if (hashSet == null) {
            return;
        }
        Iterator iterator = this.theAdapterManager.getFactories().values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                String string;
                IAdapterFactory iAdapterFactory = (IAdapterFactory)iterator2.next();
                if (!(iAdapterFactory instanceof AdapterFactoryProxy) || !hashSet.contains(string = ((AdapterFactoryProxy)iAdapterFactory).getOwnerId())) continue;
                iterator2.remove();
            }
        }
    }

    public synchronized void stop() {
        RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

