/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public final class RuntimeLog {
    private static ArrayList logListeners = new ArrayList(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogListener(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(iLogListener);
            logListeners.add(iLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogListener(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(iLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.contains(iLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(IStatus iStatus) {
        ILogListener[] iLogListenerArray;
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            iLogListenerArray = logListeners.toArray(new ILogListener[logListeners.size()]);
        }
        int n = 0;
        while (n < iLogListenerArray.length) {
            try {
                iLogListenerArray[n].logging(iStatus, "org.eclipse.core.runtime");
            }
            catch (Exception exception) {
                RuntimeLog.handleException(exception);
            }
            catch (LinkageError linkageError) {
                RuntimeLog.handleException(linkageError);
            }
            ++n;
        }
    }

    private static void handleException(Throwable throwable) {
        if (!(throwable instanceof OperationCanceledException)) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.size() == 0;
        }
    }
}

