/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class WorkbenchConfigurer
implements IWorkbenchConfigurer {
    private Map extraData = new HashMap();
    private boolean saveAndRestore = false;
    private boolean isEmergencyClosing = false;

    WorkbenchConfigurer() {
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public void declareImage(String string, ImageDescriptor imageDescriptor, boolean bl) {
        if (string == null || imageDescriptor == null) {
            throw new IllegalArgumentException();
        }
        WorkbenchImages.declareImage(string, imageDescriptor, bl);
    }

    public IWorkbenchWindowConfigurer getWindowConfigurer(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        return ((WorkbenchWindow)iWorkbenchWindow).getWindowConfigurer();
    }

    public boolean getSaveAndRestore() {
        return this.saveAndRestore;
    }

    public void setSaveAndRestore(boolean bl) {
        this.saveAndRestore = bl;
    }

    public Object getData(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(string);
    }

    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (object != null) {
            this.extraData.put(string, object);
        } else {
            this.extraData.remove(string);
        }
    }

    public void emergencyClose() {
        if (!this.isEmergencyClosing) {
            this.isEmergencyClosing = true;
            if (Workbench.getInstance() != null && !Workbench.getInstance().isClosing()) {
                Workbench.getInstance().close(3, true);
            }
        }
    }

    public boolean emergencyClosing() {
        return this.isEmergencyClosing;
    }

    public IStatus restoreState() {
        return ((Workbench)this.getWorkbench()).restoreState();
    }

    public void openFirstTimeWindow() {
        ((Workbench)this.getWorkbench()).openFirstTimeWindow();
    }
}

