/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.ConfigurationParser;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Locker;
import org.eclipse.update.internal.configurator.Locker_JavaIo;
import org.eclipse.update.internal.configurator.Locker_JavaNio;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.XMLPrintHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlatformConfiguration
implements IPlatformConfiguration,
IConfigurationConstants {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private static final String XML_ENCODING = "UTF-8";
    private Configuration config;
    private URL configLocation;
    private HashMap externalLinkSites = new HashMap();
    private long changeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid;
    private Locker lock = null;
    private static int defaultPolicy = 1;
    private static boolean checkNio = false;
    private static boolean useNio;
    private static final String ECLIPSE = "eclipse";
    private static final String CONFIG_HISTORY = "history";
    private static final String PLATFORM_XML = "platform.xml";
    private static final String CONFIG_NAME = "org.eclipse.update/platform.xml";
    private static final String CONFIG_INI = "config.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String LINKS = "links";
    private static final String[] BOOTSTRAP_PLUGINS;
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.ide.workbench";
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static URL installURL;

    static {
        BOOTSTRAP_PLUGINS = new String[0];
    }

    private PlatformConfiguration(Location location) throws CoreException, IOException {
        this.config = null;
        this.initializeCurrent(location);
        if (this.config != null) {
            this.setDefaultPolicy();
        }
        if (!this.isTransient()) {
            this.configureExternalLinks();
        }
        this.validateSites();
        if (this.isTransient()) {
            return;
        }
        this.changeStamp = this.computeChangeStamp();
        if (this.changeStamp > this.config.getDate().getTime()) {
            this.reconcile();
        }
    }

    PlatformConfiguration(URL uRL) throws Exception {
        this.initialize(uRL);
    }

    private void setDefaultPolicy() {
        int n;
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = this.getConfiguredSites();
        if (iSiteEntryArray != null && iSiteEntryArray.length > 0 && (n = iSiteEntryArray[0].getSitePolicy().getType()) == 2) {
            defaultPolicy = n;
        }
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public IPlatformConfiguration.ISiteEntry createSiteEntry(URL uRL, IPlatformConfiguration.ISitePolicy iSitePolicy) {
        return new SiteEntry(uRL, iSitePolicy);
    }

    public IPlatformConfiguration.ISitePolicy createSitePolicy(int n, String[] stringArray) {
        return new SitePolicy(n, stringArray);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String string, String string2, String string3, boolean bl, String string4, URL[] uRLArray) {
        return new FeatureEntry(string, string2, string3, bl, string4, uRLArray);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String string, String string2, String string3, String string4, boolean bl, String string5, URL[] uRLArray) {
        return new FeatureEntry(string, string2, string3, string4, bl, string5, uRLArray);
    }

    public void configureSite(IPlatformConfiguration.ISiteEntry iSiteEntry) {
        this.configureSite(iSiteEntry, false);
    }

    public synchronized void configureSite(IPlatformConfiguration.ISiteEntry iSiteEntry, boolean bl) {
        if (iSiteEntry == null) {
            return;
        }
        URL uRL = iSiteEntry.getURL();
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        if (this.config.getSiteEntry(string) != null && !bl) {
            return;
        }
        if (iSiteEntry instanceof SiteEntry) {
            this.config.addSiteEntry(string, (SiteEntry)iSiteEntry);
        }
    }

    public synchronized void unconfigureSite(IPlatformConfiguration.ISiteEntry iSiteEntry) {
        if (iSiteEntry == null) {
            return;
        }
        URL uRL = iSiteEntry.getURL();
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        if (iSiteEntry instanceof SiteEntry) {
            this.config.removeSiteEntry(string);
        }
    }

    public IPlatformConfiguration.ISiteEntry[] getConfiguredSites() {
        if (this.config == null) {
            return new IPlatformConfiguration.ISiteEntry[0];
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        ArrayList<SiteEntry> arrayList = new ArrayList<SiteEntry>(siteEntryArray.length);
        int n = 0;
        while (n < siteEntryArray.length) {
            if (siteEntryArray[n].isEnabled()) {
                arrayList.add(siteEntryArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IPlatformConfiguration.ISiteEntry[arrayList.size()]);
    }

    public IPlatformConfiguration.ISiteEntry findConfiguredSite(URL uRL) {
        return this.findConfiguredSite(uRL, true);
    }

    public SiteEntry findConfiguredSite(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        SiteEntry siteEntry = this.config.getSiteEntry(string);
        if (siteEntry == null) {
            try {
                string = UpdateURLDecoder.decode(string, XML_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            siteEntry = this.config.getSiteEntry(string);
        }
        if (siteEntry == null && bl) {
            try {
                siteEntry = this.findConfiguredSite(Utils.asPlatformURL(uRL), false);
            }
            catch (Exception exception) {}
        }
        return siteEntry;
    }

    public synchronized void configureFeatureEntry(IPlatformConfiguration.IFeatureEntry iFeatureEntry) {
        if (iFeatureEntry == null) {
            return;
        }
        String string = iFeatureEntry.getFeatureIdentifier();
        if (string == null) {
            return;
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            try {
                URL uRL = new URL(siteEntryArray[n].getURL(), "features/" + iFeatureEntry.getFeatureIdentifier() + "_" + iFeatureEntry.getFeatureVersion() + "/");
                if (new File(uRL.getFile()).exists()) {
                    siteEntryArray[n].addFeatureEntry(iFeatureEntry);
                } else {
                    uRL = new URL(siteEntryArray[n].getURL(), "features/" + iFeatureEntry.getFeatureIdentifier() + "/");
                    if (new File(uRL.getFile()).exists()) {
                        siteEntryArray[n].addFeatureEntry(iFeatureEntry);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
            ++n;
        }
    }

    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry iFeatureEntry) {
        if (iFeatureEntry == null) {
            return;
        }
        String string = iFeatureEntry.getFeatureIdentifier();
        if (string == null) {
            return;
        }
        this.config.unconfigureFeatureEntry(iFeatureEntry);
    }

    public IPlatformConfiguration.IFeatureEntry[] getConfiguredFeatureEntries() {
        ArrayList<FeatureEntry> arrayList = new ArrayList<FeatureEntry>();
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            FeatureEntry[] featureEntryArray = siteEntryArray[n].getFeatureEntries();
            int n2 = 0;
            while (n2 < featureEntryArray.length) {
                arrayList.add(featureEntryArray[n2]);
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new FeatureEntry[arrayList.size()]);
    }

    public IPlatformConfiguration.IFeatureEntry findConfiguredFeatureEntry(String string) {
        if (string == null) {
            return null;
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            FeatureEntry featureEntry = siteEntryArray[n].getFeatureEntry(string);
            if (featureEntry != null) {
                return featureEntry;
            }
            ++n;
        }
        return null;
    }

    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    public long getChangeStamp() {
        if (this.config.getLinkedConfig() == null) {
            return this.config.getDate().getTime();
        }
        return Math.max(this.config.getDate().getTime(), this.config.getLinkedConfig().getDate().getTime());
    }

    public long getFeaturesChangeStamp() {
        return 0L;
    }

    public long getPluginsChangeStamp() {
        return 0L;
    }

    public String getApplicationIdentifier() {
        IPlatformConfiguration.IFeatureEntry iFeatureEntry;
        String string = ConfigurationActivator.getBundleContext().getProperty("eclipse.application");
        if (string != null) {
            return string;
        }
        String string2 = this.getPrimaryFeatureIdentifier();
        if (string2 != null && (iFeatureEntry = this.findConfiguredFeatureEntry(string2)) != null && iFeatureEntry.getFeatureApplication() != null) {
            return iFeatureEntry.getFeatureApplication();
        }
        return DEFAULT_FEATURE_APPLICATION;
    }

    public String getPrimaryFeatureIdentifier() {
        IPlatformConfiguration.IFeatureEntry iFeatureEntry;
        String string = ConfigurationActivator.getBundleContext().getProperty("eclipse.product");
        if (string != null && (iFeatureEntry = this.findConfiguredFeatureEntry(string)) != null && iFeatureEntry.canBePrimary()) {
            return string;
        }
        return null;
    }

    public URL[] getPluginPath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Utils.debug("computed plug-in path:");
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = this.getConfiguredSites();
        int n = 0;
        while (n < iSiteEntryArray.length) {
            String[] stringArray = iSiteEntryArray[n].getPlugins();
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    URL uRL = new URL(((SiteEntry)iSiteEntryArray[n]).getResolvedURL(), stringArray[n2]);
                    arrayList.add(uRL);
                    Utils.debug("   " + uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    Utils.debug("   bad URL: " + malformedURLException);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new URL[0]);
    }

    public Set getPluginPaths() {
        HashSet<String> hashSet = new HashSet<String>();
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = this.getConfiguredSites();
        int n = 0;
        while (n < iSiteEntryArray.length) {
            String[] stringArray = iSiteEntryArray[n].getPlugins();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashSet.add(stringArray[n2]);
                ++n2;
            }
            ++n;
        }
        return hashSet;
    }

    public PluginEntry[] getPlugins() {
        ArrayList<PluginEntry> arrayList = new ArrayList<PluginEntry>();
        Utils.debug("computed plug-ins:");
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = this.getConfiguredSites();
        int n = 0;
        while (n < iSiteEntryArray.length) {
            if (!(iSiteEntryArray[n] instanceof SiteEntry)) {
                Utils.debug("Site " + iSiteEntryArray[n].getURL() + " is not a SiteEntry");
            } else {
                PluginEntry[] pluginEntryArray = ((SiteEntry)iSiteEntryArray[n]).getPluginEntries();
                int n2 = 0;
                while (n2 < pluginEntryArray.length) {
                    arrayList.add(pluginEntryArray[n2]);
                    Utils.debug("   " + pluginEntryArray[n2].getURL());
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new PluginEntry[0]);
    }

    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    public void setBootstrapPluginLocation(String string, URL uRL) {
    }

    public boolean isUpdateable() {
        return true;
    }

    public boolean isTransient() {
        if (this.config != null) {
            return this.config.isTransient();
        }
        return false;
    }

    public void isTransient(boolean bl) {
        if (this != PlatformConfiguration.getCurrent() && this.config != null) {
            this.config.setTransient(bl);
        }
    }

    public synchronized void refresh() {
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = this.getConfiguredSites();
        int n = 0;
        while (n < iSiteEntryArray.length) {
            ((SiteEntry)iSiteEntryArray[n]).refresh();
            ++n;
        }
    }

    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save(URL var1_1) throws IOException {
        block26: {
            block27: {
                if (var1_1 == null) {
                    throw new IOException(Messages.cfig_unableToSave_noURL);
                }
                var2_2 = null;
                if (var1_1.getProtocol().equals("file")) break block27;
                var3_3 = var1_1.openConnection();
                var3_3.setDoOutput(true);
                var2_2 = var3_3.getOutputStream();
                try {
                    try {
                        this.saveAsXML(var2_2);
                        this.config.setDirty(false);
                    }
                    catch (CoreException var4_5) {
                        Utils.log(var4_5.getMessage());
                        Utils.log(var4_5.getStatus());
                        throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{var1_1.toExternalForm()}));
                    }
                }
                catch (Throwable var6_7) {
                    var5_9 = null;
                    var2_2.close();
                    throw var6_7;
                }
                {
                    var5_10 = null;
                    var2_2.close();
                    return;
                }
            }
            var3_4 = new File(var1_1.getFile().replace('/', File.separatorChar));
            if (!var3_4.getName().equals("platform.xml")) {
                if (var3_4.exists() && var3_4.isFile()) {
                    Utils.log(String.valueOf(Messages.PlatformConfiguration_expectingPlatformXMLorDirectory) + var3_4.getName());
                    var3_4 = var3_4.getParentFile();
                }
                var3_4 = new File(var3_4, "org.eclipse.update/platform.xml");
            }
            if ((var4_6 = var3_4.getParentFile()) != null && !var4_6.exists()) {
                var4_6.mkdirs();
            }
            var5_11 = new File(var3_4.getAbsolutePath());
            var6_8 = new File(String.valueOf(var3_4.getAbsolutePath()) + ".tmp");
            if (var3_4.exists()) {
                var7_12 = new File(var4_6, "history");
                if (!var7_12.exists()) {
                    var7_12.mkdir();
                }
                var8_17 = var3_4.lastModified();
                var10_20 = new File(var7_12, String.valueOf(String.valueOf(var8_17)) + ".xml");
                var11_21 = 1L;
                while (true) {
                    if (!var10_20.exists() || var11_21 >= 100L) {
                        if (var10_20.exists() || var3_4.renameTo(var10_20)) break;
                        Utils.log(Messages.PlatformConfiguration_cannotBackupConfig);
                        break;
                    }
                    var10_20 = new File(var7_12, String.valueOf(String.valueOf(var8_17 + var11_21++)) + ".xml");
                }
            }
            var2_2 = new FileOutputStream(var6_8);
            try {
                try {
                    this.saveAsXML(var2_2);
                    try {
                        var2_2.flush();
                        ((FileOutputStream)var2_2).getFD().sync();
                    }
                    catch (SyncFailedException var7_13) {
                        Utils.log(var7_13.getMessage());
                    }
                    catch (IOException var7_14) {
                        Utils.log(var7_14.getMessage());
                    }
                    try {
                        var2_2.close();
                        var2_2 = null;
                    }
                    catch (IOException var7_15) {
                        Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseStream) + var6_8);
                        Utils.log(var7_15.getMessage());
                    }
                    var6_8.setLastModified(this.config.getDate().getTime());
                    this.config.setLastModified(var6_8.lastModified());
                    this.changeStamp = this.config.getDate().getTime();
                    this.config.setDirty(false);
                }
                catch (CoreException v0) {
                    throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{var6_8.getAbsolutePath()}));
                }
            }
            catch (Throwable var9_22) {
                var8_18 = null;
                if (var2_2 == null) throw var9_22;
                try {
                    var2_2.close();
                    throw var9_22;
                }
                catch (IOException v1) {
                    Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseTempFile) + var6_8);
                }
                throw var9_22;
            }
            {
                var8_19 = null;
                if (var2_2 == null) break block26;
            }
            ** try [egrp 7[TRYBLOCK] [9 : 639->646)] { 
lbl93:
            // 1 sources

            var2_2.close();
            break block26;
lbl95:
            // 1 sources

            catch (IOException v2) {
                Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseTempFile) + var6_8);
            }
        }
        if ((var7_16 = var6_8.renameTo(var5_11)) != false) return;
        Utils.log(Messages.PlatformConfiguration_cannotRenameTempFile);
        throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{var6_8.getAbsolutePath()}));
    }

    public static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    public static synchronized void startup(URL uRL, Location location) throws Exception {
        installURL = uRL;
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(location);
            if (PlatformConfiguration.currentPlatformConfiguration.config == null) {
                throw new Exception(String.valueOf(Messages.PlatformConfiguration_cannotLoadConfig) + location.getURL());
            }
            if (PlatformConfiguration.currentPlatformConfiguration.config.isDirty() && !currentPlatformConfiguration.isTransient()) {
                currentPlatformConfiguration.save();
            }
        }
    }

    public static synchronized void shutdown() throws IOException {
        PlatformConfiguration platformConfiguration = PlatformConfiguration.getCurrent();
        if (platformConfiguration != null && platformConfiguration.config.isDirty() && !platformConfiguration.isTransient()) {
            try {
                platformConfiguration.save();
            }
            catch (IOException iOException) {
                Utils.debug("Unable to save configuration " + iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initializeCurrent(Location location) throws IOException {
        URL uRL;
        block11: {
            uRL = new URL(location.getURL(), CONFIG_NAME);
            try {
                this.getConfigurationLock(location.getURL());
                try {
                    this.config = this.loadConfig(uRL);
                    Utils.debug("Using configuration " + uRL.toString());
                }
                catch (Exception exception) {
                    block10: {
                        try {
                            Location location2 = location.getParentLocation();
                            if (location2 == null) {
                                throw new IOException();
                            }
                            URL uRL2 = new URL(location2.getURL(), CONFIG_NAME);
                            this.config = this.loadConfig(uRL2);
                            if (uRL2.equals(uRL)) break block10;
                            this.linkInitializedState(this.config, location2, location);
                            Utils.debug("Configuration initialized from    " + uRL2.toString());
                        }
                        catch (Exception exception2) {
                            Utils.debug("Creating default configuration from " + uRL.toExternalForm());
                            this.createDefaultConfiguration(uRL);
                        }
                    }
                    Object var5_5 = null;
                    this.configLocation = uRL;
                    if (this.config.getURL() == null) {
                        this.config.setURL(uRL);
                    }
                    PlatformConfiguration.verifyPath(this.configLocation);
                    Utils.debug("Creating configuration " + uRL.toString());
                    this.clearConfigurationLock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.configLocation = uRL;
                if (this.config.getURL() == null) {
                    this.config.setURL(uRL);
                }
                PlatformConfiguration.verifyPath(this.configLocation);
                Utils.debug("Creating configuration " + uRL.toString());
                this.clearConfigurationLock();
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.configLocation = uRL;
                if (this.config.getURL() != null) break block11;
                this.config.setURL(uRL);
            }
        }
        PlatformConfiguration.verifyPath(this.configLocation);
        Utils.debug("Creating configuration " + uRL.toString());
        this.clearConfigurationLock();
    }

    private synchronized void initialize(URL uRL) throws Exception {
        if (uRL != null) {
            this.config = this.loadConfig(uRL);
            Utils.debug("Using configuration " + uRL.toString());
        }
        if (this.config == null) {
            this.config = new Configuration();
            Utils.debug("Creating empty configuration object");
        }
        this.config.setURL(uRL);
        this.configLocation = uRL;
    }

    private void createDefaultConfiguration(URL uRL) throws IOException {
        this.config = new Configuration();
        this.config.setURL(uRL);
        SiteEntry siteEntry = (SiteEntry)this.getRootSite();
        this.configureSite(siteEntry);
        try {
            siteEntry.loadFromDisk(0L);
        }
        catch (CoreException coreException) {
            Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotLoadDefaultSite) + siteEntry.getResolvedURL());
            return;
        }
    }

    private IPlatformConfiguration.ISiteEntry getRootSite() {
        IPlatformConfiguration.ISitePolicy iSitePolicy = this.createSitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
        URL uRL = null;
        try {
            uRL = new URL("platform:/base/");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = PlatformConfiguration.getInstallURL();
        }
        IPlatformConfiguration.ISiteEntry iSiteEntry = this.createSiteEntry(uRL, iSitePolicy);
        return iSiteEntry;
    }

    private void getConfigurationLock(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return;
        }
        File file = new File(uRL.getFile(), "org.eclipse.update" + File.separator + CONFIG_FILE_LOCK_SUFFIX);
        PlatformConfiguration.verifyPath(uRL);
        this.lock = PlatformConfiguration.createLocker(file);
        try {
            this.lock.lock();
        }
        catch (IOException iOException) {
            this.lock = null;
        }
    }

    private void clearConfigurationLock() {
        if (this.lock != null) {
            this.lock.release();
        }
    }

    private static Locker createLocker(File file) {
        if (!checkNio) {
            useNio = true;
            try {
                Class.forName("java.nio.channels.FileLock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                useNio = false;
            }
        }
        if (useNio) {
            return new Locker_JavaNio(file);
        }
        return new Locker_JavaIo(file);
    }

    private long computeChangeStamp() {
        this.featuresChangeStamp = this.computeFeaturesChangeStamp();
        this.pluginsChangeStamp = this.computePluginsChangeStamp();
        this.changeStamp = Math.max(this.featuresChangeStamp, this.pluginsChangeStamp);
        this.changeStamp = this.changeStamp / 1000L * 1000L;
        return this.changeStamp;
    }

    private long computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return this.featuresChangeStamp;
        }
        long l = 0L;
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            l = Math.max(l, siteEntryArray[n].getFeaturesChangeStamp());
            ++n;
        }
        this.featuresChangeStamp = l;
        this.featuresChangeStampIsValid = true;
        return this.featuresChangeStamp;
    }

    private long computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return this.pluginsChangeStamp;
        }
        long l = 0L;
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            l = Math.max(l, siteEntryArray[n].getPluginsChangeStamp());
            ++n;
        }
        this.pluginsChangeStamp = l;
        this.pluginsChangeStampIsValid = true;
        return this.pluginsChangeStamp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureExternalLinks() {
        URL uRL = PlatformConfiguration.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(uRL)) {
            return;
        }
        try {
            uRL = new URL(uRL, "links/");
        }
        catch (MalformedURLException malformedURLException) {
            Utils.debug("Unable to obtain link URL");
            return;
        }
        File file = new File(uRL.getFile());
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            Utils.debug("No links detected in " + uRL.toExternalForm());
            return;
        }
        int n = 0;
        while (true) {
            block16: {
                Object var8_8;
                if (n >= fileArray.length) {
                    return;
                }
                if (fileArray[n].isDirectory()) break block16;
                Utils.debug("Link file " + fileArray[n].getAbsolutePath());
                Properties properties = new Properties();
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(fileArray[n]);
                        properties.load(fileInputStream);
                        this.configureExternalLinkSite(fileArray[n], properties);
                    }
                    catch (IOException iOException) {
                        Utils.debug("   unable to load link file " + iOException);
                        var8_8 = null;
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    if (fileInputStream == null) throw throwable;
                    try {}
                    catch (IOException iOException) {}
                    fileInputStream.close();
                    throw throwable;
                    throw throwable;
                }
                {
                    var8_8 = null;
                    if (fileInputStream == null) break block16;
                }
                try {}
                catch (IOException iOException) {}
                fileInputStream.close();
            }
            ++n;
        }
    }

    private void configureExternalLinkSite(File file, Properties properties) {
        URL uRL;
        Object object;
        String string;
        String string2 = properties.getProperty(LINK_PATH);
        if (string2 == null) {
            Utils.debug("   no path definition");
            return;
        }
        boolean bl = true;
        if (string2.startsWith("r ")) {
            bl = false;
            string = string2.substring(2).trim();
        } else {
            string = string2.startsWith("rw ") ? string2.substring(3).trim() : string2.trim();
        }
        try {
            object = new File(string);
            object = new File((File)object, ECLIPSE);
            uRL = ((File)object).toURL();
            if (this.findConfiguredSite(uRL, true) != null) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Utils.debug("  bad URL " + malformedURLException);
            return;
        }
        object = (SiteEntry)this.externalLinkSites.get(uRL);
        if (object == null) {
            IPlatformConfiguration.ISitePolicy iSitePolicy = this.createSitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
            object = (SiteEntry)this.createSiteEntry(uRL, iSitePolicy);
        }
        ((SiteEntry)object).setUpdateable(bl);
        ((SiteEntry)object).setLinkFileName(file.getAbsolutePath());
        this.configureSite((IPlatformConfiguration.ISiteEntry)object);
        this.config.setDirty(true);
        Utils.debug("   " + (bl ? "R/W -> " : "R/O -> ") + uRL.toString());
    }

    private void validateSites() {
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            URL uRL = siteEntryArray[n].getResolvedURL();
            if (PlatformConfiguration.supportsDetection(uRL)) {
                File file;
                String string;
                File file2 = new File(uRL.getFile().replace('/', File.separatorChar));
                if (!file2.exists()) {
                    this.unconfigureSite(siteEntryArray[n]);
                    Utils.debug("Site " + uRL + " does not exist ... removing from configuration");
                }
                if ((string = siteEntryArray[n].getLinkFileName()) != null && !(file = new File(string)).exists()) {
                    this.unconfigureSite(siteEntryArray[n]);
                    this.config.setDirty(true);
                    Utils.debug("Site " + uRL + " is no longer linked ... removing from configuration");
                }
            }
            ++n;
        }
    }

    private void linkInitializedState(Configuration configuration, Location location, Location location2) {
        try {
            URL uRL = new URL(location2.getURL(), CONFIG_INI);
            if (!uRL.getProtocol().equals("file")) {
                return;
            }
            File file = new File(uRL.getFile());
            Properties properties = new Properties();
            String string = Utils.makeRelative(Utils.getInstallURL(), location.getURL()).toExternalForm();
            properties.put("osgi.sharedConfiguration.area", string);
            properties.store(new FileOutputStream(file), "Linked configuration");
            this.config = new Configuration(new Date());
            this.config.setURL(new URL(location2.getURL(), CONFIG_NAME));
            this.config.setLinkedConfig(configuration);
            this.config.setDirty(true);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private Configuration loadConfig(URL uRL) throws Exception {
        if (uRL == null) {
            throw new IOException(Messages.cfig_unableToLoad_noURL);
        }
        ConfigurationParser configurationParser = null;
        try {
            configurationParser = new ConfigurationParser();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getTargetException();
        }
        this.config = null;
        Exception exception = null;
        try {
            this.config = configurationParser.parse(uRL);
            if (this.config == null) {
                throw new Exception(Messages.PlatformConfiguration_cannotFindConfigFile);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            try {
                URL uRL2 = new URL(String.valueOf(uRL.toExternalForm()) + CONFIG_FILE_TEMP_SUFFIX);
                this.config = configurationParser.parse(uRL2);
                if (this.config == null) {
                    throw new Exception();
                }
                this.config.setDirty(true);
            }
            catch (Exception exception3) {
                try {
                    File[] fileArray;
                    File file;
                    File file2;
                    if ("file".equals(uRL.getProtocol()) && (file2 = (file = new File(uRL.getFile().replace('/', File.separatorChar))).getParentFile()) != null && file2.exists() && (fileArray = file2.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile() && file.getName().endsWith(".xml");
                        }
                    })) != null && fileArray.length > 0) {
                        URL uRL3 = fileArray[fileArray.length - 1].toURL();
                        this.config = configurationParser.parse(uRL3);
                    }
                    if (this.config == null) {
                        throw exception;
                    }
                    this.config.setDirty(true);
                }
                catch (IOException iOException) {
                    throw exception;
                }
            }
        }
        return this.config;
    }

    public static boolean supportsDetection(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            return true;
        }
        if (string.equals("platform")) {
            URL uRL2 = null;
            try {
                uRL2 = PlatformConfiguration.resolvePlatformURL(uRL);
            }
            catch (IOException iOException) {
                return false;
            }
            return uRL2.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL uRL) {
        Serializable serializable;
        String string = uRL.getProtocol();
        String string2 = null;
        if (string.equals("file")) {
            string2 = uRL.getFile();
        } else if (string.equals("platform")) {
            serializable = null;
            try {
                serializable = PlatformConfiguration.resolvePlatformURL(uRL);
                if (((URL)serializable).getProtocol().equals("file")) {
                    string2 = ((URL)serializable).getFile();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2 != null && (serializable = new File(string2).getParentFile()) != null) {
            ((File)serializable).mkdirs();
        }
    }

    public static URL resolvePlatformURL(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("platform")) {
            uRL = FileLocator.toFileURL((URL)uRL);
            File file = new File(uRL.getFile());
            uRL = file.toURL();
        }
        return uRL;
    }

    public static URL getInstallURL() {
        return installURL;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAsXML(OutputStream outputStream) throws CoreException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, XML_ENCODING));
        try {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setExpandEntityReferences(false);
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                if (this.config == null) {
                    throw Utils.newCoreException(Messages.PlatformConfiguration_cannotSaveNonExistingConfig, null);
                }
                this.config.setDate(new Date());
                Element element = this.config.toXML(document);
                document.appendChild(element);
                XMLPrintHandler.printNode(bufferedWriter, document, XML_ENCODING);
            }
            catch (Exception exception) {
                throw Utils.newCoreException("", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            bufferedWriter.flush();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        bufferedWriter.flush();
    }

    private void reconcile() throws CoreException {
        long l = this.config.getDate().getTime();
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            long l2 = siteEntryArray[n].getChangeStamp();
            if (l2 > l) {
                siteEntryArray[n].loadFromDisk(l);
            }
            ++n;
        }
        this.config.setDirty(true);
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

