/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BufferedRandomInputStream
extends InputStream {
    private RandomAccessFile inputFile;
    private String filePath;
    private int buffer_size;
    private int buffer_pos;
    private byte[] buffer;

    public BufferedRandomInputStream(File file) throws IOException {
        this(file, 2048);
    }

    public BufferedRandomInputStream(File file, int n) throws IOException {
        this.filePath = file.getCanonicalPath();
        this.inputFile = new RandomAccessFile(file, "r");
        this.buffer = new byte[n];
        this.resetBuffer();
    }

    private void resetBuffer() throws IOException {
        this.buffer_pos = 0;
        this.buffer_size = 0;
    }

    private int fillBuffer() throws IOException {
        this.buffer_pos = 0;
        this.buffer_size = this.inputFile.read(this.buffer, 0, this.buffer.length);
        return this.buffer_size;
    }

    public int read() throws IOException {
        if (this.buffer_pos >= this.buffer_size && this.fillBuffer() <= 0) {
            return -1;
        }
        return this.buffer[this.buffer_pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buffer_size - this.buffer_pos;
        if (n2 <= n3) {
            System.arraycopy(this.buffer, this.buffer_pos, byArray, n, n2);
            this.buffer_pos += n2;
            return n2;
        }
        System.arraycopy(this.buffer, this.buffer_pos, byArray, n, n3);
        int n4 = this.inputFile.read(byArray, n + n3, n2 - n3);
        this.fillBuffer();
        return n3 + n4;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.buffer_size - this.buffer_pos;
        if (l <= (long)n) {
            this.buffer_pos = (int)((long)this.buffer_pos + l);
            return l;
        }
        this.resetBuffer();
        return n + this.inputFile.skipBytes((int)(l - (long)n));
    }

    public int available() throws IOException {
        return this.buffer_size - this.buffer_pos;
    }

    public void close() throws IOException {
        this.inputFile.close();
        this.inputFile = null;
        this.buffer = null;
    }

    public String toString() {
        return this.filePath;
    }

    public void seek(long l) throws IOException {
        this.inputFile.seek(l);
        this.resetBuffer();
    }

    public long length() throws IOException {
        return this.inputFile.length();
    }
}

