/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class UpdatingScreen
extends AbsScreen {
    private static final int PROGRESS_UNIT = 10;
    private Composite pane;
    private Label updatingItem;
    private ProgressBar updateProgress;
    private UpdateSearchRequest searchRequest;
    private UpdateMonitor updateFeatureMonitor;
    private UpdateFeaturesThread updateFeaturesThread;
    private int totalSearchedFeaturesCount = 0;
    private boolean isSingleThread = true;
    private boolean isExisted = false;

    UpdatingScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(Messages.UpdateAllFeatures);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new RowLayout(256));
        new Label(this.pane, 0).setText(Messages.Updating);
        this.updatingItem = new Label(this.pane, 0);
        this.updateProgress = new ProgressBar(this.screen, 65536);
        this.fillSpace();
        this.setButtons(0, 2, 0);
        this.screen.layout();
    }

    protected void refresh() {
        this.cancelButton.setEnabled(true);
        this.updatingItem.setText("");
        this.updateProgress.setSelection(0);
        this.pane.layout();
    }

    protected void action() {
        Object object;
        this.cancelButton.setFocus();
        if (this.view.availableFeatures.size() == 0) {
            this.isSingleThread = false;
            object = this.view.localSite.getRawFeatureReferences();
            IFeature[] iFeatureArray = new IFeature[((ISiteFeatureReference[])object).length];
            int n = 0;
            while (n < ((ISiteFeatureReference[])object).length) {
                try {
                    iFeatureArray[n] = object[n].getFeature(null);
                    if (AppPlugin.DEBUG) {
                        System.out.println("[ eUpdate debug ] Feature being assigned to search: " + iFeatureArray[n].getLabel());
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                ++n;
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest(iFeatureArray);
        } else {
            this.isSingleThread = true;
            object = (IFeature)this.view.availableFeatures.elementAt(0);
            if (AppPlugin.DEBUG) {
                System.out.println("[ eUpdate debug ] Feature being assigned to search: " + object.getLabel());
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest(new IFeature[]{object});
        }
        this.totalSearchedFeaturesCount = this.searchRequest.getCategory().getQueries().length;
        if (this.totalSearchedFeaturesCount == 0) {
            object = new MessageBox(this.screen.getShell(), 34);
            object.setText(Messages.UpdateStatus);
            object.setMessage(Messages.NoUpdateAvailable);
            object.open();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, true);
        }
        this.updateFeatureMonitor = new UpdateMonitor();
        object = OperationsManager.getValidator().validatePlatformConfigValid();
        if (object != null) {
            System.out.println(object.getMessage());
            return;
        }
        this.updateProgress.setMaximum((this.totalSearchedFeaturesCount + 1) * 10);
        this.updateFeaturesThread = new UpdateFeaturesThread("", this.searchRequest, this.updateFeatureMonitor);
        this.updateFeaturesThread.start();
        Display.getCurrent().timerExec(1000, new Runnable(){

            public void run() {
                if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 1) {
                    UpdatingScreen.this.updatingItem.setText(UpdatingScreen.this.updateFeaturesThread.getUpdatingItem());
                    UpdatingScreen.this.pane.layout();
                    UpdatingScreen.this.updateProgress.setSelection((int)((double)UpdatingScreen.this.updateProgress.getMaximum() * (UpdatingScreen.this.updateFeatureMonitor.getDoneWorksCount() / (double)(UpdatingScreen.this.totalSearchedFeaturesCount + 1))));
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    if (UpdatingScreen.this.isExisted) {
                        return;
                    }
                    UpdatingScreen.this.isExisted = true;
                    if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 2) {
                        UpdatingScreen.this.updatingItem.setText(NLS.bind((String)Messages.FeatureUpdated, (Object[])new Object[]{new Integer(UpdatingScreen.this.updateFeaturesThread.getTotalUpdatedFeaturesCount()).toString()}));
                        UpdatingScreen.this.pane.layout();
                        UpdatingScreen.this.updateProgress.setSelection(UpdatingScreen.this.updateProgress.getMaximum());
                        UpdatingScreen.this.view.enableRestartCommand = true;
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 194);
                        messageBox.setText(Messages.ConfirmRestart);
                        messageBox.setMessage(NLS.bind((String)Messages.RecommendToRestart, (Object[])UpdatingScreen.this.view.RuntimeName));
                        if (messageBox.open() == 64) {
                            System.getProperties().put("eworkbench.returnCode", new Integer(1));
                            PlatformUI.getWorkbench().close();
                            return;
                        }
                    } else if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 3) {
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 34);
                        messageBox.setText(Messages.UpdateStatus);
                        messageBox.setMessage(Messages.NoUpdateAvailable);
                        messageBox.open();
                    } else {
                        MessageBox messageBox = new MessageBox(UpdatingScreen.this.screen.getShell(), 33);
                        messageBox.setText(Messages.UpdateStatus);
                        if (UpdatingScreen.this.isSingleThread) {
                            messageBox.setMessage(Messages.UpdateNotCompleted);
                        } else {
                            messageBox.setMessage(Messages.UpdateNotAllCompleted);
                        }
                        messageBox.open();
                    }
                    UpdatingScreen.this.isExisted = false;
                    UpdatingScreen.this.cancelButton.setEnabled(false);
                    UpdatingScreen.this.updateFeaturesThread = null;
                    UpdatingScreen.this.setVisible(false);
                    NormalView normalView = UpdatingScreen.this.view;
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                }
            }
        });
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.cancelButton && this.updateFeaturesThread != null && this.updateFeaturesThread.getStatus() == 1) {
            this.updateFeatureMonitor.setCanceled(true);
        }
    }

    public static final IInstallConfiguration getConfiguration() {
        IInstallConfiguration iInstallConfiguration = null;
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iInstallConfiguration;
    }

    private class UpdateFeaturesThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int NO_UPDATE = 3;
        public static final int ENDED = 4;
        private UpdateSearchRequest request;
        private UpdateMonitor monitor;
        private UpdateSearchResultCollector collector;
        private int currentStatus;
        private int totalSearchedFeaturesCount = 0;
        private int totalUpdatedFeaturesCount = 0;

        public UpdateFeaturesThread(String string, UpdateSearchRequest updateSearchRequest, UpdateMonitor updateMonitor) {
            super(string);
            this.request = updateSearchRequest;
            this.monitor = updateMonitor;
            this.currentStatus = 0;
            this.collector = new UpdateSearchResultCollector();
            this.totalSearchedFeaturesCount = updateSearchRequest.getCategory().getQueries().length;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray;
            block14: {
                this.currentStatus = 1;
                UpdatingScreen.this.updateFeatureMonitor.beginTask(Messages.StartUpdating, this.totalSearchedFeaturesCount + 1);
                UpdatingScreen.this.updateFeatureMonitor.setTaskName(Messages.SearchingUpdates);
                try {
                    this.request.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                    if (UpdatingScreen.this.updateFeatureMonitor.isCanceled()) {
                        this.currentStatus = 4;
                        return;
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    if (UpdatingScreen.this.searchRequest.getCategory().getQueries().length != coreException.getStatus().getChildren().length) break block14;
                    this.currentStatus = 4;
                    return;
                }
            }
            if ((iInstallFeatureOperationArray = this.collector.getOperations()) == null || iInstallFeatureOperationArray.length == 0) {
                this.currentStatus = 3;
                this.monitor.done();
                return;
            }
            this.totalUpdatedFeaturesCount = iInstallFeatureOperationArray.length;
            ArrayList arrayList = DuplicateConflictsValidator.computeDuplicateConflicts(iInstallFeatureOperationArray, UpdatingScreen.getConfiguration());
            if (arrayList != null) {
                this.currentStatus = 4;
                this.monitor.done();
                return;
            }
            IBatchOperation iBatchOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(iInstallFeatureOperationArray);
            try {
                try {
                    boolean bl = false;
                    if (!this.monitor.isCanceled()) {
                        bl = iBatchOperation.execute((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, this.monitor.getTotalWorksCount() - 1), null);
                    }
                    if (this.monitor.isCanceled() || !bl) {
                        this.removeOldVersion(iInstallFeatureOperationArray, true);
                        this.currentStatus = 4;
                        Object var5_8 = null;
                        this.monitor.done();
                        return;
                    }
                    this.removeOldVersion(iInstallFeatureOperationArray, false);
                    if (AppPlugin.DEBUG) {
                        System.out.println("Updating is finished successfully.");
                    }
                    this.currentStatus = 2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.currentStatus = 4;
                    invocationTargetException.printStackTrace();
                }
                catch (CoreException coreException) {
                    this.currentStatus = 4;
                    coreException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.monitor.done();
                throw throwable;
            }
            {
                Object var5_10 = null;
                this.monitor.done();
                return;
            }
        }

        public String getUpdatingItem() {
            return this.monitor.getTaskName();
        }

        public int getStatus() {
            return this.currentStatus;
        }

        public int getTotalUpdatedFeaturesCount() {
            return this.totalUpdatedFeaturesCount;
        }

        private void removeOldVersion(IInstallFeatureOperation[] iInstallFeatureOperationArray, boolean bl) {
            try {
                IConfiguredSite iConfiguredSite = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0];
                IFeatureReference[] iFeatureReferenceArray = null;
                if (bl) {
                    iFeatureReferenceArray = iConfiguredSite.getFeatureReferences();
                }
                boolean bl2 = false;
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation iUnconfigureAndUninstallFeatureOperation = null;
                int n = 0;
                while (n < iInstallFeatureOperationArray.length) {
                    try {
                        if (bl) {
                            bl2 = false;
                            int n2 = 0;
                            while (n2 < iFeatureReferenceArray.length) {
                                if (iInstallFeatureOperationArray[n].getFeature().getVersionedIdentifier().equals(iFeatureReferenceArray[n2].getVersionedIdentifier())) {
                                    bl2 = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!bl2) {
                                return;
                            }
                        }
                        iUnconfigureAndUninstallFeatureOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(iConfiguredSite, iInstallFeatureOperationArray[n].getOldFeature());
                        iUnconfigureAndUninstallFeatureOperation.execute(null, null);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    ++n;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return;
            }
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature iFeature) {
            if (AppPlugin.DEBUG) {
                System.out.println("[ eUpdate debug ] searched and got this feature:");
                System.out.println("[ eUpdate debug ] \tLabel   is " + iFeature.getLabel());
                System.out.println("[ eUpdate debug ] \tID      is " + iFeature.getVersionedIdentifier().getIdentifier());
                System.out.println("[ eUpdate debug ] \tVersion is " + iFeature.getVersionedIdentifier().getVersion());
                System.out.println("[ eUpdate debug ] \tURL     is " + iFeature.getURL().toString());
            }
            IInstallFeatureOperation iInstallFeatureOperation = OperationsManager.getOperationFactory().createInstallOperation(null, iFeature, null, null, null);
            IConfiguredSite iConfiguredSite = UpdateUtils.getDefaultTargetSite(UpdatingScreen.getConfiguration(), iInstallFeatureOperation);
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdateUtils.getAffinitySite(UpdatingScreen.getConfiguration(), iFeature);
            }
            if (iConfiguredSite == null) {
                iConfiguredSite = UpdatingScreen.this.view.localSite.getCurrentConfiguredSite();
            }
            iInstallFeatureOperation.setTargetSite(iConfiguredSite);
            this.operations.add(iInstallFeatureOperation);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] iInstallFeatureOperationArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(iInstallFeatureOperationArray);
            return iInstallFeatureOperationArray;
        }
    }
}

